"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolstatuserror import ToolStatusError, ToolStatusErrorTypedDict
from .toolstatusfile import ToolStatusFile, ToolStatusFileTypedDict
from .toolstatusparameter import ToolStatusParameter, ToolStatusParameterTypedDict
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal
from typing_extensions import NotRequired, TypedDict


Name = Literal[
    "math:calculator",
    "math:statistics",
    "math:calendar",
    "web:search",
    "web:url",
    "code:python-interpreter",
    "file:text",
]
r"""The name of the built-in tool."""

Status = Literal["STARTED", "UPDATING", "ENDED", "ERRORED"]
r"""Indicates the current execution status of the tool."""


class ToolStatusDataTypedDict(TypedDict):
    name: Name
    r"""The name of the built-in tool."""
    parameters: List[ToolStatusParameterTypedDict]
    status: Status
    r"""Indicates the current execution status of the tool."""
    timestamp: float
    r"""The Unix timestamp (in seconds) for when the event occurred."""
    tool_call_id: str
    r"""The ID of the tool call."""
    error: NotRequired[Nullable[ToolStatusErrorTypedDict]]
    files: NotRequired[Nullable[List[ToolStatusFileTypedDict]]]
    message: NotRequired[Nullable[str]]
    r"""Message generated by the tool's execution."""
    result: NotRequired[Nullable[str]]
    r"""The output from the tool's execution."""


class ToolStatusData(BaseModel):
    name: Name
    r"""The name of the built-in tool."""

    parameters: List[ToolStatusParameter]

    status: Status
    r"""Indicates the current execution status of the tool."""

    timestamp: float
    r"""The Unix timestamp (in seconds) for when the event occurred."""

    tool_call_id: str
    r"""The ID of the tool call."""

    error: OptionalNullable[ToolStatusError] = UNSET

    files: OptionalNullable[List[ToolStatusFile]] = UNSET

    message: OptionalNullable[str] = UNSET
    r"""Message generated by the tool's execution."""

    result: OptionalNullable[str] = UNSET
    r"""The output from the tool's execution."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["error", "files", "message", "result"]
        nullable_fields = ["error", "files", "message", "result"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
