"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from friendli.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class UserMessageTypedDict(TypedDict):
    content: str
    r"""The content of user message."""
    role: Literal["user"]
    r"""The role of the messages author."""
    name: NotRequired[Nullable[str]]
    r"""The name for the participant to distinguish between participants with the same role."""


class UserMessage(BaseModel):
    content: str
    r"""The content of user message."""

    ROLE: Annotated[
        Annotated[Literal["user"], AfterValidator(validate_const("user"))],
        pydantic.Field(alias="role"),
    ] = "user"
    r"""The role of the messages author."""

    name: OptionalNullable[str] = UNSET
    r"""The name for the participant to distinguish between participants with the same role."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
