# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthenticationRuleArgs', 'AuthenticationRule']

@pulumi.input_type
class AuthenticationRuleArgs:
    def __init__(__self__, *,
                 if_auth_fail: pulumi.Input[builtins.str],
                 if_process_fail: pulumi.Input[builtins.str],
                 if_user_not_found: pulumi.Input[builtins.str],
                 policy_set_id: pulumi.Input[builtins.str],
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 identity_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rank: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthenticationRule resource.
        :param pulumi.Input[builtins.str] if_auth_fail: Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
               `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_process_fail: Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_user_not_found: Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[builtins.str] condition_id: UUID for condition
        :param pulumi.Input[builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[builtins.str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[builtins.str] identity_source_name: Identity source name from the identity stores
        :param pulumi.Input[builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[builtins.str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        pulumi.set(__self__, "if_auth_fail", if_auth_fail)
        pulumi.set(__self__, "if_process_fail", if_process_fail)
        pulumi.set(__self__, "if_user_not_found", if_user_not_found)
        pulumi.set(__self__, "policy_set_id", policy_set_id)
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if identity_source_name is not None:
            pulumi.set(__self__, "identity_source_name", identity_source_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="ifAuthFail")
    def if_auth_fail(self) -> pulumi.Input[builtins.str]:
        """
        Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
        `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_auth_fail")

    @if_auth_fail.setter
    def if_auth_fail(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "if_auth_fail", value)

    @property
    @pulumi.getter(name="ifProcessFail")
    def if_process_fail(self) -> pulumi.Input[builtins.str]:
        """
        Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_process_fail")

    @if_process_fail.setter
    def if_process_fail(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "if_process_fail", value)

    @property
    @pulumi.getter(name="ifUserNotFound")
    def if_user_not_found(self) -> pulumi.Input[builtins.str]:
        """
        Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_user_not_found")

    @if_user_not_found.setter
    def if_user_not_found(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "if_user_not_found", value)

    @property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Input[builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_set_id", value)

    @property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="identitySourceName")
    def identity_source_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity source name from the identity stores
        """
        return pulumi.get(self, "identity_source_name")

    @identity_source_name.setter
    def identity_source_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_source_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _AuthenticationRuleState:
    def __init__(__self__, *,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 identity_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_auth_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_process_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_user_not_found: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 rank: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthenticationRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[builtins.str] condition_id: UUID for condition
        :param pulumi.Input[builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[builtins.str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[builtins.str] identity_source_name: Identity source name from the identity stores
        :param pulumi.Input[builtins.str] if_auth_fail: Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
               `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_process_fail: Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_user_not_found: Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[builtins.str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if identity_source_name is not None:
            pulumi.set(__self__, "identity_source_name", identity_source_name)
        if if_auth_fail is not None:
            pulumi.set(__self__, "if_auth_fail", if_auth_fail)
        if if_process_fail is not None:
            pulumi.set(__self__, "if_process_fail", if_process_fail)
        if if_user_not_found is not None:
            pulumi.set(__self__, "if_user_not_found", if_user_not_found)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_set_id is not None:
            pulumi.set(__self__, "policy_set_id", policy_set_id)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="identitySourceName")
    def identity_source_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity source name from the identity stores
        """
        return pulumi.get(self, "identity_source_name")

    @identity_source_name.setter
    def identity_source_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_source_name", value)

    @property
    @pulumi.getter(name="ifAuthFail")
    def if_auth_fail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
        `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_auth_fail")

    @if_auth_fail.setter
    def if_auth_fail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_auth_fail", value)

    @property
    @pulumi.getter(name="ifProcessFail")
    def if_process_fail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_process_fail")

    @if_process_fail.setter
    def if_process_fail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_process_fail", value)

    @property
    @pulumi.getter(name="ifUserNotFound")
    def if_user_not_found(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_user_not_found")

    @if_user_not_found.setter
    def if_user_not_found(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_user_not_found", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_set_id", value)

    @property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("ise:deviceadmin/authenticationRule:AuthenticationRule")
class AuthenticationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationRuleChildrenArgs', 'AuthenticationRuleChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 identity_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_auth_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_process_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_user_not_found: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 rank: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Device Admin Authentication Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AuthenticationRule("example",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            identity_source_name="Internal Endpoints",
            if_auth_fail="REJECT",
            if_process_fail="DROP",
            if_user_not_found="REJECT")
        ```

        ## Import

        ```sh
        $ pulumi import ise:deviceadmin/authenticationRule:AuthenticationRule example "76d24097-41c4-4558-a4d0-a8c07ac08470,76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationRuleChildrenArgs', 'AuthenticationRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[builtins.str] condition_id: UUID for condition
        :param pulumi.Input[builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[builtins.str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[builtins.str] identity_source_name: Identity source name from the identity stores
        :param pulumi.Input[builtins.str] if_auth_fail: Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
               `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_process_fail: Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_user_not_found: Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[builtins.str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Device Admin Authentication Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AuthenticationRule("example",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            identity_source_name="Internal Endpoints",
            if_auth_fail="REJECT",
            if_process_fail="DROP",
            if_user_not_found="REJECT")
        ```

        ## Import

        ```sh
        $ pulumi import ise:deviceadmin/authenticationRule:AuthenticationRule example "76d24097-41c4-4558-a4d0-a8c07ac08470,76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationRuleChildrenArgs', 'AuthenticationRuleChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 identity_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_auth_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_process_fail: Optional[pulumi.Input[builtins.str]] = None,
                 if_user_not_found: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 rank: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationRuleArgs.__new__(AuthenticationRuleArgs)

            __props__.__dict__["childrens"] = childrens
            __props__.__dict__["condition_attribute_name"] = condition_attribute_name
            __props__.__dict__["condition_attribute_value"] = condition_attribute_value
            __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
            __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
            __props__.__dict__["condition_id"] = condition_id
            __props__.__dict__["condition_is_negate"] = condition_is_negate
            __props__.__dict__["condition_operator"] = condition_operator
            __props__.__dict__["condition_type"] = condition_type
            __props__.__dict__["default"] = default
            __props__.__dict__["identity_source_name"] = identity_source_name
            if if_auth_fail is None and not opts.urn:
                raise TypeError("Missing required property 'if_auth_fail'")
            __props__.__dict__["if_auth_fail"] = if_auth_fail
            if if_process_fail is None and not opts.urn:
                raise TypeError("Missing required property 'if_process_fail'")
            __props__.__dict__["if_process_fail"] = if_process_fail
            if if_user_not_found is None and not opts.urn:
                raise TypeError("Missing required property 'if_user_not_found'")
            __props__.__dict__["if_user_not_found"] = if_user_not_found
            __props__.__dict__["name"] = name
            if policy_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_set_id'")
            __props__.__dict__["policy_set_id"] = policy_set_id
            __props__.__dict__["rank"] = rank
            __props__.__dict__["state"] = state
        super(AuthenticationRule, __self__).__init__(
            'ise:deviceadmin/authenticationRule:AuthenticationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationRuleChildrenArgs', 'AuthenticationRuleChildrenArgsDict']]]]] = None,
            condition_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
            condition_attribute_value: Optional[pulumi.Input[builtins.str]] = None,
            condition_dictionary_name: Optional[pulumi.Input[builtins.str]] = None,
            condition_dictionary_value: Optional[pulumi.Input[builtins.str]] = None,
            condition_id: Optional[pulumi.Input[builtins.str]] = None,
            condition_is_negate: Optional[pulumi.Input[builtins.bool]] = None,
            condition_operator: Optional[pulumi.Input[builtins.str]] = None,
            condition_type: Optional[pulumi.Input[builtins.str]] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            identity_source_name: Optional[pulumi.Input[builtins.str]] = None,
            if_auth_fail: Optional[pulumi.Input[builtins.str]] = None,
            if_process_fail: Optional[pulumi.Input[builtins.str]] = None,
            if_user_not_found: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_set_id: Optional[pulumi.Input[builtins.str]] = None,
            rank: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthenticationRule':
        """
        Get an existing AuthenticationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationRuleChildrenArgs', 'AuthenticationRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[builtins.str] condition_id: UUID for condition
        :param pulumi.Input[builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[builtins.str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[builtins.str] identity_source_name: Identity source name from the identity stores
        :param pulumi.Input[builtins.str] if_auth_fail: Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
               `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_process_fail: Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] if_user_not_found: Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        :param pulumi.Input[builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[builtins.str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationRuleState.__new__(_AuthenticationRuleState)

        __props__.__dict__["childrens"] = childrens
        __props__.__dict__["condition_attribute_name"] = condition_attribute_name
        __props__.__dict__["condition_attribute_value"] = condition_attribute_value
        __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
        __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
        __props__.__dict__["condition_id"] = condition_id
        __props__.__dict__["condition_is_negate"] = condition_is_negate
        __props__.__dict__["condition_operator"] = condition_operator
        __props__.__dict__["condition_type"] = condition_type
        __props__.__dict__["default"] = default
        __props__.__dict__["identity_source_name"] = identity_source_name
        __props__.__dict__["if_auth_fail"] = if_auth_fail
        __props__.__dict__["if_process_fail"] = if_process_fail
        __props__.__dict__["if_user_not_found"] = if_user_not_found
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_set_id"] = policy_set_id
        __props__.__dict__["rank"] = rank
        __props__.__dict__["state"] = state
        return AuthenticationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def childrens(self) -> pulumi.Output[Optional[Sequence['outputs.AuthenticationRuleChildren']]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="identitySourceName")
    def identity_source_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identity source name from the identity stores
        """
        return pulumi.get(self, "identity_source_name")

    @property
    @pulumi.getter(name="ifAuthFail")
    def if_auth_fail(self) -> pulumi.Output[builtins.str]:
        """
        Action to perform when authentication fails such as Bad credentials, disabled user and so on - Choices: `REJECT`,
        `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_auth_fail")

    @property
    @pulumi.getter(name="ifProcessFail")
    def if_process_fail(self) -> pulumi.Output[builtins.str]:
        """
        Action to perform when ISE is unable to access the identity database - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_process_fail")

    @property
    @pulumi.getter(name="ifUserNotFound")
    def if_user_not_found(self) -> pulumi.Output[builtins.str]:
        """
        Action to perform when user is not found in any of identity stores - Choices: `REJECT`, `DROP`, `CONTINUE`
        """
        return pulumi.get(self, "if_user_not_found")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Output[builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @property
    @pulumi.getter
    def rank(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

