# Generated by Django 2.2.14 on 2020-07-23 05:37

import re

import django.contrib.postgres.fields.jsonb
import django.core.validators
import django.db.models.deletion
import localized_fields.fields.char_field
import localized_fields.fields.text_field
from django.db import migrations, models

import alexandria.core.models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "created_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "created_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "modified_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "modified_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "slug",
                    models.SlugField(max_length=255, primary_key=True, serialize=False),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        required=[], verbose_name="category name"
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="category description",
                    ),
                ),
                (
                    "color",
                    models.CharField(
                        default="#FFFFFF",
                        max_length=18,
                        validators=[
                            django.core.validators.RegexValidator(
                                re.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"),
                                "Enter a valid color.",
                                "invalid",
                            )
                        ],
                    ),
                ),
            ],
            options={"abstract": False},
            bases=(
                alexandria.core.models.PermissionMixin,
                alexandria.core.models.VisibilityMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="Document",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "created_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "created_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "modified_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "modified_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=alexandria.core.models.make_uuid,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="document title",
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="document description",
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="documents",
                        to="alexandria_core.Category",
                    ),
                ),
            ],
            options={"abstract": False},
            bases=(
                alexandria.core.models.PermissionMixin,
                alexandria.core.models.VisibilityMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "created_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "created_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "modified_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "modified_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "slug",
                    models.SlugField(max_length=255, primary_key=True, serialize=False),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        required=[], verbose_name="tag name"
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="tag description",
                    ),
                ),
            ],
            options={"abstract": False},
            bases=(
                alexandria.core.models.PermissionMixin,
                alexandria.core.models.VisibilityMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="File",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "created_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "created_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "modified_by_user",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="created by user",
                    ),
                ),
                (
                    "modified_by_group",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="created by group",
                    ),
                ),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=alexandria.core.models.make_uuid,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("original", "original"), ("thumbnail", "thumbnail")],
                        default="original",
                        max_length=23,
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="file name")),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="files",
                        to="alexandria_core.Document",
                    ),
                ),
                (
                    "original",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="renderings",
                        to="alexandria_core.File",
                    ),
                ),
            ],
            options={"ordering": ["-created_at"]},
            bases=(
                alexandria.core.models.PermissionMixin,
                alexandria.core.models.VisibilityMixin,
                models.Model,
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="tags",
            field=models.ManyToManyField(
                blank=True, related_name="documents", to="alexandria_core.Tag"
            ),
        ),
    ]
