#   Copyright 2024 The PyMC Labs Developers
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
"""CLV models and utilities."""

from pymc_marketing.clv.models import (
    BetaGeoBetaBinomModel,
    BetaGeoModel,
    GammaGammaModel,
    GammaGammaModelIndividual,
    ParetoNBDModel,
    ShiftedBetaGeoModelIndividual,
)
from pymc_marketing.clv.plotting import (
    plot_customer_exposure,
    plot_frequency_recency_matrix,
    plot_probability_alive_matrix,
)
from pymc_marketing.clv.utils import (
    customer_lifetime_value,
    rfm_segments,
    rfm_summary,
    rfm_train_test_split,
)

__all__ = (
    "BetaGeoModel",
    "BetaGeoBetaBinomModel",
    "ParetoNBDModel",
    "GammaGammaModel",
    "GammaGammaModelIndividual",
    "ShiftedBetaGeoModelIndividual",
    "customer_lifetime_value",
    "plot_customer_exposure",
    "plot_frequency_recency_matrix",
    "plot_probability_alive_matrix",
    "rfm_segments",
    "rfm_summary",
    "rfm_train_test_split",
)
