#   Copyright 2024 The PyMC Labs Developers
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

"""CLV models."""

from pymc_marketing.clv.models.basic import CLVModel
from pymc_marketing.clv.models.beta_geo import BetaGeoModel
from pymc_marketing.clv.models.beta_geo_beta_binom import BetaGeoBetaBinomModel
from pymc_marketing.clv.models.gamma_gamma import (
    GammaGammaModel,
    GammaGammaModelIndividual,
)
from pymc_marketing.clv.models.pareto_nbd import ParetoNBDModel
from pymc_marketing.clv.models.shifted_beta_geo import ShiftedBetaGeoModelIndividual

__all__ = (
    "CLVModel",
    "BetaGeoBetaBinomModel",
    "GammaGammaModel",
    "GammaGammaModelIndividual",
    "BetaGeoModel",
    "ParetoNBDModel",
    "ShiftedBetaGeoModelIndividual",
)
