import { Construct } from 'constructs';
import { CfnResource } from './cfn-resource';
import { Duration } from './duration';
import { Stack } from './stack';
/**
 * (experimental) Initialization props for the `NestedStack` construct.
 *
 * @experimental
 */
export interface NestedStackProps {
    /**
     * (experimental) The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     *
     * Each parameter has a name corresponding
     * to a parameter defined in the embedded template and a value representing
     * the value that you want to set for the parameter.
     *
     * The nested stack construct will automatically synthesize parameters in order
     * to bind references from the parent stack(s) into the nested stack.
     *
     * @default - no user-defined parameters are passed to the nested stack
     * @experimental
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
     *
     * When CloudFormation detects that the nested stack has reached the
     * CREATE_COMPLETE state, it marks the nested stack resource as
     * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
     * If the timeout period expires before the nested stack reaches
     * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
     * back both the nested stack and parent stack.
     *
     * @default - no timeout
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) The Simple Notification Service (SNS) topics to publish stack related events.
     *
     * @default - notifications are not sent for this stack.
     * @experimental
     */
    readonly notificationArns?: string[];
}
/**
 * (experimental) A CloudFormation nested stack.
 *
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 *
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 *
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 *
 * @experimental
 */
export declare class NestedStack extends Stack {
    /**
     * (experimental) Checks if `x` is an object of type `NestedStack`.
     *
     * @experimental
     */
    static isNestedStack(x: any): x is NestedStack;
    /**
     * (experimental) The name of the CloudFormation template file emitted to the output directory during synthesis.
     *
     * @experimental
     */
    readonly templateFile: string;
    /**
     * (experimental) If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource.
     *
     * `undefined` for top-level (non-nested) stacks.
     *
     * @experimental
     */
    readonly nestedStackResource?: CfnResource;
    private readonly parameters;
    private readonly resource;
    private readonly _contextualStackId;
    private readonly _contextualStackName;
    private _templateUrl?;
    private _parentStack;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: NestedStackProps);
    /**
     * (experimental) An attribute that represents the name of the nested stack.
     *
     * This is a context aware attribute:
     * - If this is referenced from the parent stack, it will return a token that parses the name from the stack ID.
     * - If this is referenced from the context of the nested stack, it will return `{ "Ref": "AWS::StackName" }`
     *
     * @experimental
     * @attribute true
     * @example
     *
     * mystack-mynestedstack-sggfrhxhum7w
     */
    get stackName(): string;
    /**
     * (experimental) An attribute that represents the ID of the stack.
     *
     * This is a context aware attribute:
     * - If this is referenced from the parent stack, it will return `{ "Ref": "LogicalIdOfNestedStackResource" }`.
     * - If this is referenced from the context of the nested stack, it will return `{ "Ref": "AWS::StackId" }`
     *
     * @experimental
     * @attribute true
     * @example
     *
     * "arn:aws:cloudformation:us-east-2:123456789012:stack/mystack-mynestedstack-sggfrhxhum7w/f449b250-b969-11e0-a185-5081d0136786"
     */
    get stackId(): string;
    /**
     * (experimental) Assign a value to one of the nested stack parameters.
     *
     * @param name The parameter name (ID).
     * @param value The value to assign.
     * @experimental
     */
    setParameter(name: string, value: string): void;
    private contextualAttribute;
}
