# Terminology

### Function Parameters

See "global_doc.md" for more information.

# Structures

### FileStream

A structure that represents a file stream.

It is 0x48 bytes long. 

A filestream has a cursor which is the offset of the first next byte to read. 

# Functions

## Input/Output

### DatatransferInit()

Used to initialize data transfer mode to get data from the ROM cartridge.

### DatatransferQuit()

Used to finalize data transfer from the ROM cartridge.

Always use that to end data transfer mode initialized with DatatransferInit.

The game will crash if you don't end this mode.

### FFill(r0: FileStream)

Fills the structure with the correct parameters.

Must be done before opening a file.

### FOpen(r0: FileStream, r1: Path)

Opens a file from the rom filesystem given by the path.

Must be in data transfer mode.

Similar to the 'fopen' functions in C language.

### r0: Size = FGetSize(r0: FileStream)

Gets the size of the opened file.

### FRead(r0: FileStream, r1: Buffer, r2: Size)

Reads Size bytes from the file and puts them in the Buffer.

Moves the cursor accordingly.

Must be in data transfer mode.

Similar to the 'fread' functions in C language.

### FSeek(r0: FileStream, r1: Offset, r2: Whence)

See the C language documentation about 'fseek'.

Moves the cursor to an Offset position relative to the starting point Whence.
Offset can be negative.

Whence can be: 

SEEK_SET (=0x0): the beginning of the file
SEEK_CUR (=0x1): the current position of the cursor
SEEK_END (=0x2): the end of the file\*
\* Maybe not implemented, so it may not work

Must be in data transfer mode.

### FClose(r0: FileStream)

See the C language documentation about 'fclose'.

Closes the file stream.

IMPORTANT! It is possible keep a file stream open even if data transfer mode was ended! 

That means a file stream that wasn't closed can be used again once data transfer mode is initialized.

Must be in data transfer mode.

### r0: nb_char = SPrintF(r0: str, r1: format, ...)

See the C language documentation about 'sprintf'.

The first two additional parameters are passed using registers r2 and r3, 

the others are passed using the heap (starting from \[r13\], each parameter is 4 bytes).

## General Information

### r0: LangID = GetLang()

## String Manipulation

### r0: dest = StrCpy(r0: dest, r1: src)

See the C language documentation about 'strcpy'.

### r0: dest = StrNCpy(r0: dest, r1: src, r2: n)

See the C language documentation about 'strncpy'.

## Math

### r0: q, r1: r = EuclidianDivision(r0: n, r1: d)

