import * as React from 'react';
import { IRuntime, ISchema } from './PipelineService';
interface IProps {
    runtimes: IRuntime[];
    schema: ISchema[];
}
interface IState {
    displayedRuntimeOptions: IRuntime[];
    fileTypes: Record<string, string>[];
    selectedRuntimePlatform: string;
    validSchemas: ISchema[];
}
export declare class PipelineExportDialog extends React.Component<IProps, IState> {
    state: {
        displayedRuntimeOptions: IRuntime[];
        fileTypes: Record<string, string>[];
        selectedRuntimePlatform: string;
        validSchemas: ISchema[];
    };
    handleUpdate: (event: React.ChangeEvent<HTMLSelectElement>) => void;
    updateRuntimeOptions: (platformSelection: string) => IRuntime[];
    updateFileTypeOptions: (platformSelection: string) => Record<string, string>[];
    componentDidMount(): void;
    render(): React.ReactNode;
}
export {};
