"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuntimesWidget = void 0;
const metadata_common_1 = require("@elyra/metadata-common");
const ui_components_1 = require("@elyra/ui-components");
const react_1 = __importDefault(require("react"));
const PipelineService_1 = require("./PipelineService");
const RUNTIMES_METADATA_CLASS = 'elyra-metadata-runtimes';
const addTrailingSlash = (url) => {
    return url.endsWith('/') ? url : url + '/';
};
const getGithubURLFromAPI = (apiEndpoint) => {
    // For Enterprise Server the api is located at <hostname>/api/
    let baseURL = new URL(apiEndpoint).origin;
    // For Github.com and Github AE the api is located at api.<hostname>
    baseURL = baseURL.replace('api.', '');
    return addTrailingSlash(baseURL);
};
/**
 * A React Component for displaying the runtimes list.
 */
class RuntimesDisplay extends metadata_common_1.MetadataDisplay {
    renderExpandableContent(metadata) {
        const apiEndpoint = addTrailingSlash(metadata.metadata.api_endpoint);
        const cosEndpoint = addTrailingSlash(metadata.metadata.cos_endpoint);
        let githubRepoElement = null;
        let metadata_props = null;
        for (const schema of this.props.schemas) {
            if (schema.name === metadata.schema_name) {
                metadata_props = schema.properties.metadata.properties;
            }
        }
        if (metadata.schema_name === 'airflow' && metadata_props) {
            const githubRepoUrl = getGithubURLFromAPI(metadata.metadata.github_api_endpoint) +
                metadata.metadata.github_repo +
                '/tree/' +
                metadata.metadata.github_branch +
                '/';
            githubRepoElement = (react_1.default.createElement("span", null,
                react_1.default.createElement("h6", null, metadata_props.github_repo.title),
                react_1.default.createElement("a", { href: githubRepoUrl, target: "_blank", rel: "noreferrer noopener" }, githubRepoUrl),
                react_1.default.createElement("br", null),
                react_1.default.createElement("br", null)));
        }
        return (react_1.default.createElement("div", null,
            react_1.default.createElement("h6", null, metadata_props ? metadata_props.api_endpoint.title : 'API Endpoint'),
            react_1.default.createElement("a", { href: apiEndpoint, target: "_blank", rel: "noreferrer noopener" }, apiEndpoint),
            react_1.default.createElement("br", null),
            react_1.default.createElement("br", null),
            githubRepoElement,
            react_1.default.createElement("h6", null, metadata_props
                ? metadata_props.cos_endpoint.title
                : 'Cloud Object Storage'),
            react_1.default.createElement("a", { href: cosEndpoint, target: "_blank", rel: "noreferrer noopener" }, cosEndpoint)));
    }
}
/**
 * A widget for displaying runtimes.
 */
class RuntimesWidget extends metadata_common_1.MetadataWidget {
    constructor(props) {
        super(props);
    }
    fetchMetadata() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield PipelineService_1.PipelineService.getRuntimes(false).catch(error => ui_components_1.RequestErrors.serverError(error));
        });
    }
    renderDisplay(metadata) {
        if (Array.isArray(metadata) && !metadata.length) {
            // Empty metadata
            return (react_1.default.createElement("div", null,
                react_1.default.createElement("br", null),
                react_1.default.createElement("h6", { className: "elyra-no-metadata-msg" }, "Click the + button to add a new Runtime")));
        }
        return (react_1.default.createElement(RuntimesDisplay, { metadata: metadata, updateMetadata: this.updateMetadata, openMetadataEditor: this.openMetadataEditor, namespace: PipelineService_1.RUNTIMES_NAMESPACE, sortMetadata: true, schemas: this.schemas, className: RUNTIMES_METADATA_CLASS }));
    }
}
exports.RuntimesWidget = RuntimesWidget;
//# sourceMappingURL=RuntimesWidget.js.map