"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringArrayInput = void 0;
const core_1 = require("@blueprintjs/core");
const react_1 = __importDefault(require("react"));
class StringArrayInput extends react_1.default.Component {
    constructor(parameters, controller, data) {
        super({});
        this.deleteHandler = (index) => {
            delete this.values[index];
            this.controller.updatePropertyValue({ name: this.parameter }, this.values);
        };
        this.onTextAreaChange = (props) => {
            this.values = props.value.split('\n');
        };
        this.onInputChange = (event, index) => {
            event.target.value
                .split('\n')
                .forEach((element, valueIndex) => {
                if (valueIndex === 0) {
                    this.values[index] = element;
                }
                else {
                    this.values.splice(index, 0, element);
                }
            });
            this.values[index] = event.target.value;
            this.controller.updatePropertyValue({ name: this.parameter }, this.values);
        };
        this.addHandler = () => {
            this.values.push('');
            this.controller.updatePropertyValue({ name: this.parameter }, this.values);
        };
        this.singleItemLabel = data.single_item_label;
        this.placeholder = data.placeholder;
        this.fileBrowser = data.filebrowser;
        this.parameter = parameters['name'];
        this.controller = controller;
        this.deleteHandler = this.deleteHandler.bind(this);
        this.onTextAreaChange = this.onTextAreaChange.bind(this);
        this.onInputChange = this.onInputChange.bind(this);
        this.addHandler = this.addHandler.bind(this);
    }
    static id() {
        return 'elyra-string-array-input';
    }
    renderControl() {
        this.values = this.controller.getPropertyValue(this.parameter);
        return (react_1.default.createElement("div", null,
            react_1.default.createElement("div", { id: this.parameter }, this.values.map((value, index) => (react_1.default.createElement(core_1.ControlGroup, { key: this.parameter + index + 'ControlGroup', style: { marginBottom: 4 } },
                react_1.default.createElement(core_1.InputGroup, { fill: true, key: this.parameter + index + 'InputGroup', className: "jp-InputGroup", defaultValue: value, placeholder: this.placeholder, onChange: (event) => {
                        this.onInputChange(event, index);
                    } }),
                this.fileBrowser ? (react_1.default.createElement(core_1.Button, { className: "jp-Button", icon: "folder-close", onClick: () => {
                        const actionHandler = this.controller.getHandlers()
                            .actionHandler;
                        if (typeof actionHandler === 'function') {
                            actionHandler('add_dependencies', this.controller.getAppData(), { parameter_ref: 'dependencies', index: index });
                        }
                    } })) : (react_1.default.createElement("div", null)),
                react_1.default.createElement(core_1.Button, { className: "jp-Button", icon: "cross", onClick: () => {
                        this.deleteHandler(index);
                    } }))))),
            react_1.default.createElement("div", { style: { display: 'flex' } },
                react_1.default.createElement(core_1.Button, { className: "jp-Button", onClick: this.addHandler, style: { marginTop: 8 } },
                    "Add ",
                    this.singleItemLabel ? this.singleItemLabel : 'item'))));
    }
}
exports.StringArrayInput = StringArrayInput;
exports.default = StringArrayInput;
//# sourceMappingURL=StringArrayInput.js.map