"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formDialogWidget = void 0;
const apputils_1 = require("@jupyterlab/apputils");
const messaging_1 = require("@lumino/messaging");
const widgets_1 = require("@lumino/widgets");
const formDialogWidget = (dialogComponent) => {
    const widget = apputils_1.ReactWidget.create(dialogComponent);
    // Immediately update the body even though it has not yet attached in
    // order to trigger a render of the DOM nodes from the React element.
    messaging_1.MessageLoop.sendMessage(widget, widgets_1.Widget.Msg.UpdateRequest);
    widget.getValue = () => {
        const form = widget.node.querySelector('form');
        const formValues = {};
        for (const element of Object.values(form.elements)) {
            switch (element.type) {
                case 'checkbox':
                    formValues[element.name] = element.checked;
                    break;
                default:
                    formValues[element.name] = element.value;
                    break;
            }
        }
        return formValues;
    };
    return widget;
};
exports.formDialogWidget = formDialogWidget;
//# sourceMappingURL=formDialogWidget.js.map