import { LabShell } from '@jupyterlab/application';
/**
 * A utilities class for static functions.
 */
export default class Utils {
    static getUUID(): any;
    /**
     * Utility to create a one node pipeline to submit a single file as a pipeline
     */
    static generateSingleFilePipeline(filename: string, runtime_platform: string, runtime_config: string, runtimeImage: string, dependencies: string[], envObject: {
        [key: string]: string;
    }): any;
    /**
     * Check if the provided pipeline is empty (no nodes)
     *
     * @param pipelineDefinition
     */
    static isEmptyPipeline(pipelineDefinition: any): boolean;
    /**
     * Check if the provided pipeline is clear of nodes and comments
     *
     * @param pipelineDefinition
     */
    static isEmptyCanvas(pipelineDefinition: any): boolean;
    /**
     * Read the version of a Pipeline. If no version is found return 0
     *
     * @param pipelineDefinition
     */
    static getPipelineVersion(pipelineDefinition: any): number;
    /**
     * Read an application specific field from the pipeline definition
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static getPipelineAppdataField(node: any, fieldName: string): string;
    /**
     * Check if an application specific field from the pipeline defintion exists
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static hasPipelineAppdataField(node: any, fieldName: string): boolean;
    /**
     * Delete an application specific field from the pipeline definition
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static deletePipelineAppdataField(node: any, fieldName: string): void;
    /**
     * Rename an application specific field from the pepileine definition if it exists by
     * by copying the field value to the new field name and then deleting the previously
     * existing field
     */
    static renamePipelineAppdataField(node: any, currentFieldName: string, newFieldName: string): void;
    /**
     * Break an array into an array of "chunks", each "chunk" having "n" elements.
     * The final "chuck" may have less than "n" elements.
     * Example:
     * chunkArray(['a', 'b', 'c', 'd', 'e', 'f', 'g'], 4)
     * -> [['a', 'b', 'c', 'd'], ['e', 'f', 'g']]
     */
    static chunkArray<T extends {}>(arr: T[], n: number): T[][];
    /**
     * Check if the object is not an array, but the result of a Dialog instead
     */
    static isDialogResult(runtimesObj: any): boolean;
    /**
     * From a given widget, find the application shell and return it
     */
    static getLabShell: (widget: any) => LabShell;
}
