"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSubmissionDialog = void 0;
const React = __importStar(require("react"));
const PipelineService_1 = require("./PipelineService");
const utils_1 = __importDefault(require("./utils"));
const EnvForm = ({ env }) => {
    if (env.length > 0) {
        return (React.createElement(React.Fragment, null,
            React.createElement("br", null),
            React.createElement("br", null),
            React.createElement("div", null, "Environment Variables:"),
            React.createElement("br", null),
            utils_1.default.chunkArray(env, 4).map((col, i) => (React.createElement("div", { key: i }, col.map(envVar => (React.createElement("div", { key: envVar },
                React.createElement("label", { htmlFor: envVar },
                    envVar,
                    ":"),
                React.createElement("br", null),
                React.createElement("input", { type: "text", id: envVar, className: "envVar", name: envVar, size: 30 })))))))));
    }
    return null;
};
class FileSubmissionDialog extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            displayedRuntimeOptions: new Array(),
            includeDependency: true,
            selectedRuntimePlatform: '',
            validSchemas: new Array()
        };
        this.handleCheck = (event) => {
            this.setState({
                includeDependency: !this.state.includeDependency
            });
        };
        this.handleUpdate = (event) => {
            const selectedPlatform = event.target.value;
            this.setState({
                displayedRuntimeOptions: this.updateRuntimeOptions(selectedPlatform),
                selectedRuntimePlatform: selectedPlatform
            });
        };
        this.updateRuntimeOptions = (platformSelection) => {
            const filteredRuntimeOptions = PipelineService_1.PipelineService.filterRuntimes(this.props.runtimes, platformSelection);
            PipelineService_1.PipelineService.sortRuntimesByDisplayName(filteredRuntimeOptions);
            return filteredRuntimeOptions;
        };
    }
    componentDidMount() {
        const { schema, runtimes } = this.props;
        const validSchemas = PipelineService_1.PipelineService.filterValidSchema(runtimes, schema);
        const selectedRuntimePlatform = validSchemas[0] && validSchemas[0].name;
        const displayedRuntimeOptions = this.updateRuntimeOptions(selectedRuntimePlatform);
        this.setState({
            displayedRuntimeOptions: displayedRuntimeOptions,
            selectedRuntimePlatform: selectedRuntimePlatform,
            validSchemas: validSchemas
        });
    }
    render() {
        const { env, images } = this.props;
        const { displayedRuntimeOptions, includeDependency, validSchemas } = this.state;
        const fileDependencyContent = includeDependency ? (React.createElement("div", { key: "dependencies" },
            React.createElement("br", null),
            React.createElement("input", { type: "text", id: "dependencies", className: "jp-mod-styled", name: "dependencies", placeholder: "*.py", defaultValue: "*.py", size: 30 }))) : null;
        return (React.createElement("form", { className: "elyra-dialog-form" },
            React.createElement("label", { htmlFor: "runtime_platform" }, "Runtime Platform:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", onChange: this.handleUpdate }, validSchemas.map(schema => (React.createElement("option", { key: schema.name, value: schema.name }, schema.display_name)))),
            React.createElement("label", { htmlFor: "runtime_config" }, "Runtime Configuration:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config" }, displayedRuntimeOptions.map(runtime => (React.createElement("option", { key: runtime.name, value: runtime.name }, runtime.display_name)))),
            React.createElement("label", { htmlFor: "framework" }, "Runtime Image:"),
            React.createElement("br", null),
            React.createElement("select", { id: "framework", name: "framework", className: "elyra-form-framework" }, Object.entries(images).map(([key, val]) => (React.createElement("option", { key: key, value: key }, val)))),
            React.createElement("br", null),
            React.createElement("input", { type: "checkbox", className: "elyra-Dialog-checkbox", id: "dependency_include", name: "dependency_include", size: 20, checked: this.state.includeDependency, onChange: this.handleCheck }),
            React.createElement("label", { htmlFor: "dependency_include" }, "Include File Dependencies:"),
            React.createElement("br", null),
            fileDependencyContent,
            React.createElement(EnvForm, { env: env })));
    }
}
exports.FileSubmissionDialog = FileSubmissionDialog;
//# sourceMappingURL=FileSubmissionDialog.js.map