"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineSubmissionDialog = void 0;
const React = __importStar(require("react"));
const PipelineService_1 = require("./PipelineService");
class PipelineSubmissionDialog extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            displayedRuntimeOptions: new Array(),
            selectedRuntimePlatform: this.props.schema[0] && this.props.schema[0].name,
            validSchemas: new Array()
        };
        this.handleUpdate = (event) => {
            const selectedPlatform = event.target.value;
            const runtimeOptions = this.updateRuntimeOptions(selectedPlatform);
            this.setState({
                displayedRuntimeOptions: runtimeOptions,
                selectedRuntimePlatform: selectedPlatform
            });
        };
        this.updateRuntimeOptions = (platformSelection) => {
            const filteredRuntimeOptions = PipelineService_1.PipelineService.filterRuntimes(this.props.runtimes, platformSelection);
            PipelineService_1.PipelineService.sortRuntimesByDisplayName(filteredRuntimeOptions);
            return filteredRuntimeOptions;
        };
    }
    componentDidMount() {
        const { schema, runtimes } = this.props;
        this.setState({
            displayedRuntimeOptions: this.updateRuntimeOptions(this.state.selectedRuntimePlatform),
            validSchemas: PipelineService_1.PipelineService.filterValidSchema(runtimes, schema)
        });
    }
    render() {
        const { name } = this.props;
        const { displayedRuntimeOptions, selectedRuntimePlatform, validSchemas } = this.state;
        return (React.createElement("form", { className: "elyra-dialog-form" },
            React.createElement("label", { htmlFor: "pipeline_name" }, "Pipeline Name:"),
            React.createElement("br", null),
            React.createElement("input", { type: "text", id: "pipeline_name", name: "pipeline_name", defaultValue: name, "data-form-required": true }),
            React.createElement("br", null),
            React.createElement("br", null),
            React.createElement("label", { htmlFor: "runtime_platform" }, "Runtime Platform:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", "data-form-required": true, defaultValue: selectedRuntimePlatform, onChange: this.handleUpdate }, validSchemas.map(schema => (React.createElement("option", { key: schema.name, value: schema.name }, schema.display_name)))),
            React.createElement("label", { htmlFor: "runtime_config" }, "Runtime Configuration:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config", "data-form-required": true }, displayedRuntimeOptions.map(runtime => (React.createElement("option", { key: runtime.name, value: runtime.name }, runtime.display_name))))));
    }
}
exports.PipelineSubmissionDialog = PipelineSubmissionDialog;
//# sourceMappingURL=PipelineSubmissionDialog.js.map