/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.dag;

import io.ray.serve.dag.DAGNodeBase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public abstract class DAGNode
implements DAGNodeBase {
    private final Object[] boundArgs;
    private final Map<String, Object> boundOptions;
    private final Map<String, Object> boundOtherArgsToResolve;
    private String stableUuid = UUID.randomUUID().toString().replace("-", "");

    public DAGNode(Object[] args, Map<String, Object> options, Map<String, Object> otherArgsToResolve) {
        this.boundArgs = args != null ? args : new Object[]{};
        this.boundOptions = options != null ? options : new HashMap();
        this.boundOtherArgsToResolve = otherArgsToResolve != null ? otherArgsToResolve : new HashMap();
    }

    @Override
    public <T> T applyRecursive(Function<DAGNodeBase, T> fn) {
        if (!(fn instanceof CachingFn)) {
            CachingFn<DAGNodeBase> newFun = new CachingFn<DAGNodeBase>(fn);
            return (T)newFun.apply(this.applyAndReplaceAllChildNodes(node -> node.applyRecursive(newFun)));
        }
        return fn.apply(this.applyAndReplaceAllChildNodes(node -> node.applyRecursive(fn)));
    }

    @Override
    public <T> DAGNodeBase applyAndReplaceAllChildNodes(Function<DAGNodeBase, T> fn) {
        Object[] newArgs = new Object[this.boundArgs.length];
        for (int i = 0; i < this.boundArgs.length; ++i) {
            newArgs[i] = this.boundArgs[i] instanceof DAGNodeBase ? fn.apply((DAGNodeBase)this.boundArgs[i]) : this.boundArgs[i];
        }
        return this.copy(newArgs, this.boundOptions, this.boundOtherArgsToResolve);
    }

    @Override
    public DAGNodeBase copy(Object[] newArgs, Map<String, Object> newOptions, Map<String, Object> newOtherArgsToResolve) {
        DAGNode instance = (DAGNode)this.copyImpl(newArgs, newOptions, newOtherArgsToResolve);
        instance.stableUuid = this.stableUuid;
        return instance;
    }

    public Object[] getBoundArgs() {
        return this.boundArgs;
    }

    public Map<String, Object> getBoundOptions() {
        return this.boundOptions;
    }

    public Map<String, Object> getBoundOtherArgsToResolve() {
        return this.boundOtherArgsToResolve;
    }

    @Override
    public String getStableUuid() {
        return this.stableUuid;
    }

    private static class CachingFn<T>
    implements Function<DAGNodeBase, T> {
        private final Map<String, T> cache = new HashMap<String, T>();
        private final Function<DAGNodeBase, T> function;

        public CachingFn(Function<DAGNodeBase, T> function) {
            this.function = function;
        }

        @Override
        public T apply(DAGNodeBase t2) {
            return (T)this.cache.computeIfAbsent(t2.getStableUuid(), key -> this.function.apply(t2));
        }
    }
}

