/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ConstantEvaluators;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.WasmRuntimeException;
import com.dylibso.chicory.runtime.alloc.DefaultMemAllocStrategy;
import com.dylibso.chicory.runtime.alloc.MemAllocStrategy;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.UninstantiableException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public final class ByteBufferMemory
implements Memory {
    private final MemoryLimits limits;
    private DataSegment[] dataSegments;
    private ByteBuffer buffer;
    private int nPages;
    private final MemAllocStrategy allocStrategy;

    public ByteBufferMemory(MemoryLimits limits) {
        this(limits, new DefaultMemAllocStrategy(Memory.bytes(limits.maximumPages())));
    }

    public ByteBufferMemory(MemoryLimits limits, MemAllocStrategy allocStrategy) {
        this.allocStrategy = allocStrategy;
        this.limits = limits;
        this.buffer = ByteBuffer.allocate(allocStrategy.initial(65536 * limits.initialPages())).order(ByteOrder.LITTLE_ENDIAN);
        this.nPages = limits.initialPages();
    }

    private ByteBuffer allocateByteBuffer(int capacity) {
        if (capacity > this.buffer.capacity()) {
            int nextCapacity = this.allocStrategy.next(this.buffer.capacity(), capacity);
            return ByteBuffer.allocate(nextCapacity).order(ByteOrder.LITTLE_ENDIAN);
        }
        return this.buffer;
    }

    @Override
    public int pages() {
        return this.nPages;
    }

    @Override
    public int grow(int size) {
        int prevPages = this.nPages;
        int numPages = prevPages + size;
        if (numPages > this.maximumPages() || numPages < prevPages) {
            return -1;
        }
        ByteBuffer newBuffer = this.allocateByteBuffer(65536 * numPages);
        if (newBuffer != this.buffer) {
            ByteBuffer oldBuffer = this.buffer;
            int position = oldBuffer.position();
            oldBuffer.rewind();
            newBuffer.put(oldBuffer);
            newBuffer.position(position);
            this.buffer = newBuffer;
        }
        this.nPages = numPages;
        return prevPages;
    }

    @Override
    public int initialPages() {
        return this.limits.initialPages();
    }

    @Override
    public int maximumPages() {
        return Math.min(this.limits.maximumPages(), Short.MAX_VALUE);
    }

    @Override
    public void initialize(Instance instance, DataSegment[] dataSegments) {
        this.dataSegments = dataSegments;
        if (dataSegments == null) {
            return;
        }
        for (DataSegment s : dataSegments) {
            if (s instanceof ActiveDataSegment) {
                ActiveDataSegment segment = (ActiveDataSegment)s;
                List<Instruction> offsetExpr = segment.offsetInstructions();
                byte[] data = segment.data();
                int offset = (int)ConstantEvaluators.computeConstantValue(instance, offsetExpr)[0];
                ByteBufferMemory.checkBounds(offset, data.length, 65536 * this.nPages, msg -> new UninstantiableException((String)msg));
                this.buffer.position(offset);
                this.buffer.put(data, 0, data.length);
                continue;
            }
            if (s instanceof PassiveDataSegment) continue;
            throw new ChicoryException("Data segment should be active or passive: " + String.valueOf(s));
        }
    }

    private static void checkBounds(int addr, int size, int limit, Function<String, ChicoryException> exceptionFactory) {
        if (addr < 0 || size < 0 || addr > limit || size > 0 && addr + size > limit) {
            String errorMsg = "out of bounds memory access: attempted to access address: " + addr + " but limit is: " + limit + " and size: " + size;
            throw exceptionFactory.apply(errorMsg);
        }
    }

    private static RuntimeException outOfBoundsException(RuntimeException e, int addr, int size, int limit) {
        if (e instanceof IndexOutOfBoundsException || e instanceof BufferOverflowException || e instanceof BufferUnderflowException || e instanceof IllegalArgumentException || e instanceof NegativeArraySizeException) {
            String errorMsg = "out of bounds memory access: attempted to access address: " + addr + " but limit is: " + limit + " and size: " + size;
            return new WasmRuntimeException(errorMsg);
        }
        return e;
    }

    @Override
    public void initPassiveSegment(int segmentId, int dest, int offset, int size) {
        DataSegment segment = this.dataSegments[segmentId];
        this.write(dest, segment.data(), offset, size);
    }

    private int sizeInBytes() {
        return 65536 * this.nPages;
    }

    @Override
    public void write(int addr, byte[] data, int offset, int size) {
        try {
            this.buffer.position(addr);
            this.buffer.put(data, offset, size);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, size, this.sizeInBytes());
        }
    }

    @Override
    public byte read(int addr) {
        try {
            return this.buffer.get(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 1, this.sizeInBytes());
        }
    }

    @Override
    public byte[] readBytes(int addr, int len) {
        try {
            byte[] bytes = new byte[len];
            this.buffer.position(addr);
            this.buffer.get(bytes);
            return bytes;
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, len, this.sizeInBytes());
        }
    }

    @Override
    public void writeI32(int addr, int data) {
        try {
            this.buffer.putInt(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public int readInt(int addr) {
        try {
            return this.buffer.getInt(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public void writeLong(int addr, long data) {
        try {
            this.buffer.putLong(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public long readLong(int addr) {
        try {
            return this.buffer.getLong(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public void writeShort(int addr, short data) {
        try {
            this.buffer.putShort(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public short readShort(int addr) {
        try {
            return this.buffer.getShort(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public long readU16(int addr) {
        try {
            return this.buffer.getShort(addr) & 0xFFFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 2, this.sizeInBytes());
        }
    }

    @Override
    public void writeByte(int addr, byte data) {
        try {
            this.buffer.put(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 1, this.sizeInBytes());
        }
    }

    @Override
    public void writeF32(int addr, float data) {
        try {
            this.buffer.putFloat(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public long readF32(int addr) {
        try {
            return this.buffer.getInt(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public float readFloat(int addr) {
        try {
            return this.buffer.getFloat(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 4, this.sizeInBytes());
        }
    }

    @Override
    public void writeF64(int addr, double data) {
        try {
            this.buffer.putDouble(addr, data);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public double readDouble(int addr) {
        try {
            return this.buffer.getDouble(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public long readF64(int addr) {
        try {
            return this.buffer.getLong(addr);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, addr, 8, this.sizeInBytes());
        }
    }

    @Override
    public void zero() {
        this.fill((byte)0, 0, this.sizeInBytes());
    }

    @Override
    public void fill(byte value2, int fromIndex, int toIndex) {
        try {
            Arrays.fill(this.buffer.array(), fromIndex, toIndex, value2);
            this.buffer.position(0);
        }
        catch (RuntimeException e) {
            throw ByteBufferMemory.outOfBoundsException(e, fromIndex, toIndex - fromIndex, this.sizeInBytes());
        }
    }

    @Override
    public void drop(int segment) {
        this.dataSegments[segment] = PassiveDataSegment.EMPTY;
    }
}

