/*
 * Decompiled with CFR 0.152.
 */
package config;

import annotations.PollutesGlobalState;
import certora.CVTVersion;
import config.CommandLineParserKt;
import config.Config;
import config.ConfigRegister;
import config.ConfigType;
import config.ConfigTypeKt;
import config.DefaultCommandLineParser;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertReporter;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import utils.CertoraInternalErrorType;
import utils.CertoraInternalException;
import utils.CheckedUrl;
import utils.LazyKt;
import utils.OutPrinter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001b\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0004J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001bH\u0002J2\u0010\"\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010&\u001a\u00020\nH\u0002J\u001b\u0010'\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020\nH\u0007J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006,"}, d2={"Lconfig/DefaultCommandLineParser;", "", "()V", "options", "Lorg/apache/commons/cli/Options;", "getOptions", "()Lorg/apache/commons/cli/Options;", "options$delegate", "Lkotlin/Lazy;", "basicChecksSkippedByApache", "", "cmdLineArgs", "Lorg/apache/commons/cli/CommandLine;", "originalArgs", "", "", "(Lorg/apache/commons/cli/CommandLine;[Ljava/lang/String;)V", "checkLegalConfig", "getCommandLineArgs", "args", "([Ljava/lang/String;)Lorg/apache/commons/cli/CommandLine;", "noSuchOptionErrStr", "opt", "printErrAndExit", "", "msg", "withProverArgsDocLink", "", "exitcode", "", "printHelp", "helpFormatter", "Lorg/apache/commons/cli/HelpFormatter;", "all", "printMsgAndExit", "withHelp", "allHelp", "withVersion", "printVersion", "processArgsAndConfig", "([Ljava/lang/String;)V", "reportCommandLineParsingErrors", "setExecNameAndDirectory", "withAddendum", "Shared"})
@SourceDebugExtension(value={"SMAP\nCommandLineParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineParser.kt\nconfig/DefaultCommandLineParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,341:1\n1#2:342\n11065#3:343\n11400#3,3:344\n12720#3,3:393\n766#4:347\n857#4:348\n1360#4:349\n1446#4,2:350\n1549#4:352\n1620#4,3:353\n1448#4,3:356\n858#4:359\n1855#4,2:360\n1774#4,4:362\n1549#4:366\n1620#4,3:367\n1477#4:370\n1502#4,3:371\n1505#4,3:381\n766#4:384\n857#4,2:385\n1855#4:387\n1855#4,2:388\n1856#4:390\n1855#4,2:391\n372#5,7:374\n*S KotlinDebug\n*F\n+ 1 CommandLineParser.kt\nconfig/DefaultCommandLineParser\n*L\n133#1:343\n133#1:344,3\n280#1:393,3\n169#1:347\n169#1:348\n170#1:349\n170#1:350,2\n170#1:352\n170#1:353,3\n170#1:356,3\n169#1:359\n173#1:360,2\n185#1:362,4\n186#1:366\n186#1:367,3\n201#1:370\n201#1:371,3\n201#1:381,3\n201#1:384\n201#1:385,2\n207#1:387\n208#1:388,2\n207#1:390\n235#1:391,2\n201#1:374,7\n*E\n"})
public class DefaultCommandLineParser {
    @NotNull
    private final Lazy options$delegate = LazyKt.lazy(options.2.INSTANCE);

    @NotNull
    public final Options getOptions() {
        Lazy lazy2 = this.options$delegate;
        return (Options)lazy2.getValue();
    }

    @NotNull
    public final String withAddendum(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        return msg + ". See " + CheckedUrl.CLI_ARGS + " for more help.";
    }

    private final Void printErrAndExit(String msg, boolean withProverArgsDocLink, int exitcode) {
        if (!(exitcode != 0)) {
            boolean $i$a$-check-DefaultCommandLineParser$printErrAndExit$22 = false;
            String $i$a$-check-DefaultCommandLineParser$printErrAndExit$22 = "Not expected to print error if exitcode is going to be 0";
            throw new IllegalStateException($i$a$-check-DefaultCommandLineParser$printErrAndExit$22.toString());
        }
        String updatedMsg = withProverArgsDocLink ? this.withAddendum(msg) : msg;
        boolean bl = false;
        this.printMsgAndExit(updatedMsg, false, false, false, exitcode);
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Void printErrAndExit$default(DefaultCommandLineParser defaultCommandLineParser, String string, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printErrAndExit");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return defaultCommandLineParser.printErrAndExit(string, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Void printMsgAndExit(@Nullable String msg, boolean withHelp, boolean allHelp, boolean withVersion, int exitcode) {
        if (!(withHelp || !allHelp)) {
            boolean $i$a$-check-DefaultCommandLineParser$printMsgAndExit$22 = false;
            String $i$a$-check-DefaultCommandLineParser$printMsgAndExit$22 = "Can't ask to not show help but also ask all advanced help";
            throw new IllegalStateException($i$a$-check-DefaultCommandLineParser$printMsgAndExit$22.toString());
        }
        if (msg != null) {
            if (exitcode != 0) {
                LoggerKt.alwaysError(Logger.Companion, msg);
            } else {
                LoggerKt.always(Logger.Companion, msg, false);
            }
            this.reportCommandLineParsingErrors(msg);
        }
        if (withVersion) {
            this.printVersion();
        }
        if (withHelp) {
            void it2;
            HelpFormatter helpFormatter;
            HelpFormatter $i$a$-check-DefaultCommandLineParser$printMsgAndExit$22 = helpFormatter = new HelpFormatter();
            DefaultCommandLineParser defaultCommandLineParser = this;
            boolean bl = false;
            it2.setWidth(120);
            defaultCommandLineParser.printHelp(helpFormatter, this.getOptions(), allHelp);
        }
        System.exit(exitcode);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void reportCommandLineParsingErrors(String msg) {
        OutPrinter.print$default(OutPrinter.INSTANCE, msg, false, 2, null);
        OutPrinter.INSTANCE.close();
        CVTAlertReporter alertReporter = CVTAlertReporter.Companion.invoke();
        if (!alertReporter.isInit()) {
            alertReporter.init();
        }
        CVTAlertReporter.reportAlert$default(alertReporter, CVTAlertType.GENERAL, CVTAlertSeverity.ERROR, null, msg, null, CheckedUrl.CLI_ARGS, null, 64, null);
        alertReporter.close();
    }

    private final void printVersion() {
        String toolName = "CertoraProver/CVT";
        System.out.print((Object)(toolName + " version (" + CVTVersion.Companion.getInternalVersionString() + ")"));
    }

    /*
     * WARNING - void declaration
     */
    private final CommandLine getCommandLineArgs(String[] args2) {
        try {
            CommandLine parsedArgs = new DefaultParser().parse(this.getOptions(), args2);
            ConfigType.BooleanCmdLine booleanCmdLine = Config.INSTANCE.getShowHelp();
            Intrinsics.checkNotNull(parsedArgs);
            if (booleanCmdLine.isConfigured(parsedArgs)) {
                this.printMsgAndExit(null, true, false, false, 0);
                throw new KotlinNothingValueException();
            }
            if (Config.INSTANCE.getShowVersion().isConfigured(parsedArgs)) {
                this.printMsgAndExit(null, false, false, true, 0);
                throw new KotlinNothingValueException();
            }
            if (Config.INSTANCE.getShowAdvancedHelp().isConfigured(parsedArgs)) {
                this.printMsgAndExit(null, true, true, false, 0);
                throw new KotlinNothingValueException();
            }
            if (parsedArgs.getArgs().length > 1) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int n = parsedArgs.getArgs().length;
                String[] stringArray = parsedArgs.getArgs();
                Intrinsics.checkNotNullExpressionValue(stringArray, "getArgs(...)");
                Object[] objectArray = stringArray;
                int n2 = n;
                DefaultCommandLineParser defaultCommandLineParser = this;
                boolean $i$f$map = false;
                void var5_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.toString());
                }
                collection = (List)destination$iv$iv;
                DefaultCommandLineParser.printErrAndExit$default(defaultCommandLineParser, "Only one argument is expected, got " + n2 + ": " + CollectionsKt.joinToString$default(collection, ",", null, null, 0, null, null, 62, null) + ".", false, 0, 6, null);
                throw new KotlinNothingValueException();
            }
            return parsedArgs;
        }
        catch (MissingArgumentException e) {
            Object object = e.getMessage();
            if (object == null) {
                object = "Missing argument for option: " + e.getOption();
            }
            DefaultCommandLineParser.printErrAndExit$default(this, (String)object, true, 0, 4, null);
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            this.printMsgAndExit(e.getMessage(), true, false, false, 1);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void printHelp(HelpFormatter helpFormatter, Options options, boolean all) {
        v0 = options.getOptions();
        Intrinsics.checkNotNullExpressionValue(v0, "getOptions(...)");
        var5_4 = v0;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Option)element$iv$iv;
            $i$a$-filter-DefaultCommandLineParser$printHelp$filteredOptions$1 = false;
            if (all) ** GOTO lbl-1000
            $this$flatMap$iv = Config.INSTANCE.getOptionsForHelpMsg();
            $i$f$flatMap = false;
            var16_19 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ConfigType.CmdLine)element$iv$iv;
                $i$a$-flatMap-DefaultCommandLineParser$printHelp$filteredOptions$1$1 = false;
                $this$map$iv = it.getAllOptions();
                $i$f$map = false;
                var25_28 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var30_33 = (Option)item$iv$iv;
                    var31_34 = destination$iv$iv;
                    $i$a$-map-DefaultCommandLineParser$printHelp$filteredOptions$1$1$1 = false;
                    var31_34.add(ConfigTypeKt.realOpt((Option)it));
                }
                list$iv$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            v1 = (List)destination$iv$iv;
            Intrinsics.checkNotNull(it);
            if (v1.contains(ConfigTypeKt.realOpt(it))) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        filteredOptions = (List)destination$iv$iv;
        optionsForUsage = new Options();
        $this$forEach$iv = filteredOptions;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Option)element$iv;
            $i$a$-forEach-DefaultCommandLineParser$printHelp$1 = false;
            optionsForUsage.addOption(it);
        }
        helpFormatter.printHelp("certoraRun ... --prover_args '-optionName value -flag'", optionsForUsage);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLegalConfig(CommandLine cmdLineArgs) {
        int n;
        if (ConfigType.MainFileName.INSTANCE.getOrNull() != null && Config.INSTANCE.getIsUseCache()) {
            DefaultCommandLineParser.printErrAndExit$default(this, "Caching only available when running from scripts, and not directly on files", false, 0, 6, null);
            throw new KotlinNothingValueException();
        }
        Iterable $this$count$iv = Config.INSTANCE.getSolverMemLimit().getAllOptions();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Option it2 = (Option)element$iv;
                boolean bl = false;
                if (!cmdLineArgs.hasOption(ConfigTypeKt.realOpt(it2)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n > 1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$count$iv = Config.INSTANCE.getSolverMemLimit().getAllOptions();
            DefaultCommandLineParser defaultCommandLineParser = this;
            boolean $i$f$map = false;
            void count$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Option option2 = (Option)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ConfigTypeKt.realOpt((Option)it3));
            }
            DefaultCommandLineParser.printErrAndExit$default(defaultCommandLineParser, "Must use at most one out of " + (List)destination$iv$iv, false, 0, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void basicChecksSkippedByApache(CommandLine cmdLineArgs, String[] originalArgs) {
        void $this$filterTo$iv$iv;
        Object it2;
        Iterable $this$groupByTo$iv$iv;
        Option[] optionArray = cmdLineArgs.getOptions();
        Intrinsics.checkNotNullExpressionValue(optionArray, "getOptions(...)");
        List<Object> optionsList = ArraysKt.toList((Object[])optionArray);
        boolean bl = false;
        Iterable $this$groupBy$iv = optionsList;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it2 = (Option)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = ((Option)it2).getOpt();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (List)element$iv$iv;
            boolean bl4 = false;
            if (!(it2.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List optListsWithDups = (List)destination$iv$iv;
        if (!((Collection)optListsWithDups).isEmpty()) {
            Iterable $this$forEach$iv = optListsWithDups;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List dupOpts = (List)element$iv;
                boolean bl5 = false;
                Iterable $this$forEach$iv2 = dupOpts;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Option opt = (Option)element$iv2;
                    boolean bl6 = false;
                    if (opt.getValues() != null && opt.getValues().length > 1) {
                        DefaultCommandLineParser.printErrAndExit$default(this, "Option " + opt + " should not get multiple values: " + opt.getValues(), true, 0, 4, null);
                        throw new KotlinNothingValueException();
                    }
                    String dummyOption = "-" + opt.getOpt() + opt.getValue();
                    if (!ArraysKt.contains(originalArgs, dummyOption)) continue;
                    DefaultCommandLineParser.printErrAndExit$default(this, this.noSuchOptionErrStr(dummyOption), true, 0, 4, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    @NotNull
    protected final String noSuchOptionErrStr(@NotNull String opt) {
        Intrinsics.checkNotNullParameter(opt, "opt");
        return "There is no such option " + opt;
    }

    @PollutesGlobalState
    public final void processArgsAndConfig(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        OutPrinter.init$default(OutPrinter.INSTANCE, null, 1, null);
        CommandLine cmdLineArgs = this.getCommandLineArgs(args2);
        this.basicChecksSkippedByApache(cmdLineArgs, args2);
        if (cmdLineArgs.getArgs().length == 1) {
            String string = cmdLineArgs.getArgs()[0];
            Intrinsics.checkNotNullExpressionValue(string, "get(...)");
            ConfigType.MainFileName.INSTANCE.set((Serializable)((Object)string));
        }
        Iterable $this$forEach$iv = ConfigRegister.INSTANCE.getRegisteredConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigType conf = (ConfigType)element$iv;
            boolean bl = false;
            if (!(conf instanceof ConfigType.CmdLine)) continue;
            try {
                ((ConfigType.CmdLine)conf).setFromCLI(cmdLineArgs);
            }
            catch (Exception e) {
                String concatenatedOption;
                Option matchedOption = ((ConfigType.CmdLine)conf).getMatchedOption(cmdLineArgs);
                if (!(matchedOption != null)) {
                    boolean $i$a$-check-DefaultCommandLineParser$processArgsAndConfig$1$22 = false;
                    String $i$a$-check-DefaultCommandLineParser$processArgsAndConfig$1$22 = "Exception can't be thrown if option does not exist in cmd line arguments";
                    throw new IllegalStateException($i$a$-check-DefaultCommandLineParser$processArgsAndConfig$1$22.toString());
                }
                String optionValue = cmdLineArgs.getOptionValue(ConfigTypeKt.realOpt(matchedOption));
                if (ConfigTypeKt.realOpt(matchedOption).length() == 1 && ArraysKt.contains(args2, concatenatedOption = "-" + ConfigTypeKt.realOpt(matchedOption) + optionValue)) {
                    DefaultCommandLineParser.printErrAndExit$default(this, "Invalid option " + concatenatedOption, true, 0, 4, null);
                    throw new KotlinNothingValueException();
                }
                DefaultCommandLineParser.printErrAndExit$default(this, "Bad argument " + ConfigTypeKt.realOpt(matchedOption) + " = " + optionValue + ": " + e.getMessage(), true, 0, 4, null);
                throw new KotlinNothingValueException();
            }
        }
        this.checkLegalConfig(cmdLineArgs);
    }

    /*
     * WARNING - void declaration
     */
    @PollutesGlobalState
    public final void setExecNameAndDirectory() {
        if (((Boolean)Config.INSTANCE.getOverwriteMainOutputDir().get()).booleanValue()) {
            String execName = (String)Config.INSTANCE.getMainOutputFolder().get();
            if (!((Boolean)Config.INSTANCE.getAvoidAnyOutput().get()).booleanValue()) {
                try {
                    CommandLineParserKt.access$getLogger$p().info((Function0<? extends Object>)new Function0<Object>(execName){
                        final /* synthetic */ String $execName;
                        {
                            this.$execName = $execName;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Deleting " + this.$execName + " directory, if it already exists: " + new File(this.$execName).exists();
                        }
                    });
                    FilesKt.deleteRecursively(new File(execName));
                }
                catch (Exception e) {
                    throw new Exception("Failed to overwrite output directory " + execName + ": " + e);
                }
                new File(execName).mkdir();
            }
            ConfigType.ExecName.INSTANCE.set((Serializable)((Object)execName));
        } else {
            int n;
            File cwd = new File(".");
            Regex regex = new Regex(Config.INSTANCE.getMainOutputFolder().get() + "-(\\d+).*");
            int n2 = 1;
            String[] stringArray = cwd.list();
            if (stringArray != null) {
                void $this$fold$iv;
                void initial$iv;
                String[] stringArray2 = stringArray;
                boolean bl = false;
                int n3 = n2;
                boolean $i$f$fold = false;
                void accumulator$iv = initial$iv;
                int n4 = ((void)$this$fold$iv).length;
                for (int i = 0; i < n4; ++i) {
                    int n5;
                    void filename;
                    void element$iv;
                    void var13_16 = element$iv = $this$fold$iv[i];
                    void num = accumulator$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(filename);
                    MatchResult match = Regex.find$default(regex, (CharSequence)filename, 0, 2, null);
                    if (match != null) {
                        String newNum = match.getDestructured().getMatch().getGroupValues().get(1);
                        n5 = Math.max((int)num, Integer.parseInt(newNum));
                    } else {
                        n5 = num;
                    }
                    accumulator$iv = n5;
                }
                void var19_21 = accumulator$iv;
                n2 = n3;
                n = var19_21;
            } else {
                n = 0;
            }
            int number = n2 + n;
            String runName = "certora";
            String fixedRunName = StringsKt.takeLast(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(runName, ':', '-', false, 4, null), '/', '-', false, 4, null), '\\', '-', false, 4, null), 25);
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-LLL--HH-mm");
            Intrinsics.checkNotNull(now);
            Intrinsics.checkNotNull(formatter);
            String execName = DefaultCommandLineParser.setExecNameAndDirectory$execNamePattern(number, fixedRunName, now, formatter);
            ConfigType.ExecName.INSTANCE.set((Serializable)((Object)execName));
            if (!((Boolean)Config.INSTANCE.getAvoidAnyOutput().get()).booleanValue()) {
                int attemptNo;
                boolean successMkdir = new File((String)ConfigType.ExecName.INSTANCE.get()).mkdir();
                DateTimeFormatter retryFormatter = DateTimeFormatter.ofPattern("dd-LLL--HH-mm-n");
                for (attemptNo = 1; !successMkdir && attemptNo < ((Number)Config.INSTANCE.getMaxNumOfAttemptsToCreateMainOutputDir().get()).intValue(); ++attemptNo) {
                    LocalDateTime localDateTime = LocalDateTime.now();
                    Intrinsics.checkNotNullExpressionValue(localDateTime, "now(...)");
                    Intrinsics.checkNotNull(retryFormatter);
                    ConfigType.ExecName.INSTANCE.set((Serializable)((Object)DefaultCommandLineParser.setExecNameAndDirectory$execNamePattern(number, fixedRunName, localDateTime, retryFormatter)));
                    successMkdir = new File((String)ConfigType.ExecName.INSTANCE.get()).mkdir();
                    if (!successMkdir) continue;
                }
                if (!successMkdir) {
                    throw new CertoraInternalException(CertoraInternalErrorType.MULTIPLE_LOCAL_CVT_INSTANCES, "Could not mkdir " + execName + " nor any refreshed names for " + attemptNo + " times, giving up", null, 4, null);
                }
            }
        }
    }

    private static final String setExecNameAndDirectory$execNamePattern(int number, String fixedRunName, LocalDateTime t, DateTimeFormatter formatter) {
        return StringsKt.replace$default(Config.INSTANCE.getMainOutputFolder().get() + "-" + number + "-" + fixedRunName + "-" + t.format(formatter), ':', '-', false, 4, null);
    }
}

