/*
 * Decompiled with CFR 0.152.
 */
package dwarf;

import config.Config;
import datastructures.LinkedArrayHashMap;
import datastructures.stdcollections.MapsKt;
import dwarf.DebugInfoReader;
import dwarf.DebugInfoReaderKt;
import dwarf.LlvmSymbolizerOutput;
import dwarf.Symbol;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertReporter;
import report.CVTAlertSeverity;
import report.CVTAlertType;
import utils.Range;
import utils.SourcePosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0004J&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u000eJ&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J$\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldwarf/DebugInfoReader;", "", "()V", "elfFile", "", "fileExistsInSourcesDir", "", "range", "Lutils/Range$Range;", "findFunctionRangeInSourcesDir", "mangledName", "getInlinedFrames", "", "Lkotlin/ULong;", "", "addresses", "getInlinedFramesInSourcesDir", "init", "", "llvmSymbolizerOutputToRange", "Lkotlin/Pair;", "llvmSymbolizerOutput", "Ldwarf/LlvmSymbolizerOutput;", "symbolToRange", "symbol", "Ldwarf/Symbol;", "Shared"})
@SourceDebugExtension(value={"SMAP\nDebugInfoReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugInfoReader.kt\ndwarf/DebugInfoReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\ndatastructures/stdcollections/MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,327:1\n1#2:328\n1#2:356\n107#3:329\n403#4:330\n1238#5,2:331\n766#5:333\n857#5,2:334\n1241#5:336\n1549#5:337\n1620#5,3:338\n1855#5,2:341\n1855#5,2:344\n1603#5,9:346\n1855#5:355\n1856#5:357\n1612#5:358\n96#6:343\n*S KotlinDebug\n*F\n+ 1 DebugInfoReader.kt\ndwarf/DebugInfoReader\n*L\n247#1:356\n153#1:329\n153#1:330\n153#1:331,2\n154#1:333\n154#1:334,2\n153#1:336\n182#1:337\n182#1:338,3\n183#1:341,2\n217#1:344,2\n247#1:346,9\n247#1:355\n247#1:357\n247#1:358\n211#1:343\n*E\n"})
public final class DebugInfoReader {
    @NotNull
    public static final DebugInfoReader INSTANCE = new DebugInfoReader();
    @Nullable
    private static String elfFile;

    private DebugInfoReader() {
    }

    public final void init(@NotNull String elfFile) {
        Intrinsics.checkNotNullParameter(elfFile, "elfFile");
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info(init.1.INSTANCE);
        DebugInfoReader.elfFile = elfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Range.Range findFunctionRangeInSourcesDir(@NotNull String mangledName) {
        int n;
        Object it22;
        boolean bl;
        Intrinsics.checkNotNullParameter(mangledName, "mangledName");
        boolean bl2 = bl = elfFile != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DebugInfoReader$findFunctionRangeInSourcesDir$22 = false;
            String $i$a$-assert-DebugInfoReader$findFunctionRangeInSourcesDir$22 = "called findFunctionLocation before initializing the ELF file path";
            throw new AssertionError((Object)$i$a$-assert-DebugInfoReader$findFunctionRangeInSourcesDir$22);
        }
        String[] $i$a$-assert-DebugInfoReader$findFunctionRangeInSourcesDir$22 = new String[]{"llvm-dwarfdump", "--name", mangledName, elfFile};
        List<String> cmd2 = CollectionsKt.mutableListOf($i$a$-assert-DebugInfoReader$findFunctionRangeInSourcesDir$22);
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(mangledName, cmd2){
            final /* synthetic */ String $mangledName;
            final /* synthetic */ List<String> $cmd;
            {
                this.$mangledName = $mangledName;
                this.$cmd = $cmd;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Running command to get range of function '" + this.$mangledName + "': " + CollectionsKt.joinToString$default(this.$cmd, " ", null, null, 0, null, null, 62, null);
            }
        });
        ProcessBuilder pb = new ProcessBuilder(cmd2);
        Process llvmDwarfDumpProcess = pb.start();
        InputStream inputStream = llvmDwarfDumpProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n2 = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
        object = null;
        try {
            it22 = (BufferedReader)closeable;
            boolean bl3 = false;
            it22 = TextStreamsKt.readText((Reader)it22);
        }
        catch (Throwable it22) {
            object = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        Object llvmDwarfDumpStdout = it22;
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>((String)llvmDwarfDumpStdout){
            final /* synthetic */ String $llvmDwarfDumpStdout;
            {
                this.$llvmDwarfDumpStdout = $llvmDwarfDumpStdout;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "llvm-dwarfdump process stdout: " + this.$llvmDwarfDumpStdout;
            }
        });
        if (llvmDwarfDumpProcess.waitFor() != 0) {
            Object object2;
            it22 = llvmDwarfDumpProcess.getErrorStream();
            Throwable bl3 = null;
            try {
                Object it3 = (InputStream)it22;
                boolean bl4 = false;
                it3 = ((InputStream)it3).readAllBytes();
                object2 = it3;
            }
            catch (Throwable it3) {
                bl3 = it3;
                throw it3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it22, bl3);
            }
            Intrinsics.checkNotNullExpressionValue(object2, "use(...)");
            object = object2;
            String errorText = new String((byte[])object, Charsets.UTF_8);
            CVTAlertReporter.Companion.reportAlert$default(CVTAlertReporter.Companion, CVTAlertType.DIAGNOSABILITY, CVTAlertSeverity.WARNING, null, "Failed to read range of function '" + mangledName + "' - proceeding without debug information.", null, null, null, 96, null);
            DebugInfoReaderKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(mangledName, errorText){
                final /* synthetic */ String $mangledName;
                final /* synthetic */ String $errorText;
                {
                    this.$mangledName = $mangledName;
                    this.$errorText = $errorText;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Failed to read range of function '" + this.$mangledName + "' - proceeding without debug information, reason " + this.$errorText;
                }
            });
            return null;
        }
        Regex fileRegex = new Regex("DW_AT_decl_file\\s+\\(\"([^\"]+)\"\\)");
        Regex lineRegex = new Regex("DW_AT_decl_line\\s+\\((\\d+)\\)");
        Regex columnRegex = new Regex("DW_AT_decl_column\\s+\\((\\d+)\\)");
        List fileMatches = SequencesKt.toList(Regex.findAll$default(fileRegex, (CharSequence)llvmDwarfDumpStdout, 0, 2, null));
        List lineMatches = SequencesKt.toList(Regex.findAll$default(lineRegex, (CharSequence)llvmDwarfDumpStdout, 0, 2, null));
        List columnMatches = SequencesKt.toList(Regex.findAll$default(columnRegex, (CharSequence)llvmDwarfDumpStdout, 0, 2, null));
        if (fileMatches.size() != 1 || lineMatches.size() != 1) {
            DebugInfoReaderKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(fileMatches, lineMatches){
                final /* synthetic */ List<MatchResult> $fileMatches;
                final /* synthetic */ List<MatchResult> $lineMatches;
                {
                    this.$fileMatches = $fileMatches;
                    this.$lineMatches = $lineMatches;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Warning: Unexpected number of file (" + this.$fileMatches.size() + ") or line (" + this.$lineMatches.size() + ") matches in DWARF dump. Proceeding without debug information.";
                }
            });
            return null;
        }
        String file = ((MatchResult)CollectionsKt.first(fileMatches)).getGroupValues().get(1);
        int line = UInt.constructor-impl(UStringsKt.toUInt(((MatchResult)CollectionsKt.first(lineMatches)).getGroupValues().get(1)) - 1);
        if (columnMatches.size() == 1) {
            n = UInt.constructor-impl(UStringsKt.toUInt(((MatchResult)CollectionsKt.first(columnMatches)).getGroupValues().get(1)) - 1);
        } else if (columnMatches.size() > 1) {
            DebugInfoReaderKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(columnMatches){
                final /* synthetic */ List<MatchResult> $columnMatches;
                {
                    this.$columnMatches = $columnMatches;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Warning: Multiple column matches (" + this.$columnMatches.size() + ") found, using the first one.";
                }
            });
            n = UInt.constructor-impl(UStringsKt.toUInt(((MatchResult)CollectionsKt.first(columnMatches)).getGroupValues().get(1)) - 1);
        } else {
            n = 0;
        }
        int column2 = n;
        SourcePosition start = new SourcePosition(line, column2, null);
        SourcePosition end = new SourcePosition(UInt.constructor-impl(line + 1), 0, null);
        Range.Range range = new Range.Range(file, start, end);
        return this.fileExistsInSourcesDir(range) ? range : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ULong, List<Range.Range>> getInlinedFramesInSourcesDir(@NotNull List<ULong> addresses) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresses, "addresses");
        Map<ULong, List<Range.Range>> $this$mapValues$iv = this.getInlinedFrames(addresses);
        boolean $i$f$mapValues = false;
        Map<ULong, List<Range.Range>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedArrayHashMap($this$mapValues$iv.size(), 0.0f, 2, null);
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List inlinedFrames = (List)entry3.getValue();
            Iterable $this$filter$iv = inlinedFrames;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Range.Range it2 = (Range.Range)element$iv$iv;
                boolean bl3 = false;
                if (!INSTANCE.fileExistsInSourcesDir(it2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ULong, List<Range.Range>> getInlinedFrames(@NotNull List<ULong> addresses) {
        Object it22;
        Object item$iv$iv;
        Iterator $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(addresses, "addresses");
        boolean bl2 = bl = elfFile != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DebugInfoReader$getInlinedFrames$22 = false;
            String $i$a$-assert-DebugInfoReader$getInlinedFrames$22 = "called getInlinedFrames before initializing the ELF file path";
            throw new AssertionError((Object)$i$a$-assert-DebugInfoReader$getInlinedFrames$22);
        }
        String[] $i$a$-assert-DebugInfoReader$getInlinedFrames$22 = new String[]{"llvm-symbolizer", "--output-style", "JSON", "--exe", elfFile, "--inlines"};
        List<String> cmd2 = CollectionsKt.mutableListOf($i$a$-assert-DebugInfoReader$getInlinedFrames$22);
        Iterable $this$map$iv = addresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void addr;
            item$iv$iv = iterator2.next();
            long l = ((ULong)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string = UStringsKt.toString-JSWoG40((long)addr, 16).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add("0x" + string);
        }
        List hexAddresses = (List)destination$iv$iv;
        Iterable $this$forEach$iv = hexAddresses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String address2 = (String)element$iv;
            boolean bl4 = false;
            cmd2.add(address2);
        }
        String hexAddressesString = CollectionsKt.joinToString$default(hexAddresses, " ", null, null, 0, null, null, 62, null);
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(hexAddressesString, cmd2){
            final /* synthetic */ String $hexAddressesString;
            final /* synthetic */ List<String> $cmd;
            {
                this.$hexAddressesString = $hexAddressesString;
                this.$cmd = $cmd;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Running command to get addresses " + this.$hexAddressesString + " info: " + CollectionsKt.joinToString$default(this.$cmd, " ", null, null, 0, null, null, 62, null);
            }
        });
        ProcessBuilder pb = new ProcessBuilder(cmd2);
        Process llvmSymbolizerProcess = pb.start();
        InputStream inputStream = llvmSymbolizerProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        Closeable address2 = inputStream;
        Object bl4 = Charsets.UTF_8;
        item$iv$iv = new InputStreamReader((InputStream)address2, (Charset)bl4);
        int addr = 8192;
        address2 = item$iv$iv instanceof BufferedReader ? (BufferedReader)item$iv$iv : new BufferedReader((Reader)item$iv$iv, addr);
        bl4 = null;
        try {
            it22 = (BufferedReader)address2;
            boolean bl5 = false;
            it22 = TextStreamsKt.readText((Reader)it22);
        }
        catch (Throwable it22) {
            bl4 = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally(address2, (Throwable)bl4);
        }
        Object llvmSymbolizerProcessStdout = it22;
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>((String)llvmSymbolizerProcessStdout){
            final /* synthetic */ String $llvmSymbolizerProcessStdout;
            {
                this.$llvmSymbolizerProcessStdout = $llvmSymbolizerProcessStdout;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "llvm-symbolizer process stdout: " + this.$llvmSymbolizerProcessStdout;
            }
        });
        if (llvmSymbolizerProcess.waitFor() != 0) {
            byte[] byArray;
            it22 = llvmSymbolizerProcess.getErrorStream();
            Throwable bl5 = null;
            try {
                InputStream it3 = (InputStream)it22;
                boolean bl6 = false;
                byArray = it3.readAllBytes();
            }
            catch (Throwable throwable) {
                bl5 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it22, bl5);
            }
            Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
            bl4 = byArray;
            String errorText = new String((byte[])bl4, Charsets.UTF_8);
            CVTAlertReporter.Companion.reportAlert$default(CVTAlertReporter.Companion, CVTAlertType.DIAGNOSABILITY, CVTAlertSeverity.WARNING, null, "Failed to generate inlined frames for bytecode addresses " + hexAddressesString + " - proceeding without debug information.", null, null, null, 96, null);
            DebugInfoReaderKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(hexAddressesString, errorText){
                final /* synthetic */ String $hexAddressesString;
                final /* synthetic */ String $errorText;
                {
                    this.$hexAddressesString = $hexAddressesString;
                    this.$errorText = $errorText;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Failed to generate inlined frames for bytecode address " + this.$hexAddressesString + " - proceeding without debug information, reason " + this.$errorText;
                }
            });
            return MapsKt.mapOf();
        }
        Json this_$iv = JsonKt.Json$default(null, getInlinedFrames.llvmSymbolizerOutputList.1.INSTANCE, 1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List llvmSymbolizerOutputList2 = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer<LlvmSymbolizerOutput>(LlvmSymbolizerOutput.Companion.serializer()), (String)llvmSymbolizerProcessStdout);
        Map<ULong, List<Range.Range>> inlinedFrames = MapsKt.mutableMapOf();
        Iterable $this$forEach$iv2 = llvmSymbolizerOutputList2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LlvmSymbolizerOutput llvmSymbolizerOutput = (LlvmSymbolizerOutput)element$iv;
            boolean bl7 = false;
            Pair<ULong, List<Range.Range>> resultEntry = INSTANCE.llvmSymbolizerOutputToRange(llvmSymbolizerOutput);
            if (resultEntry == null) continue;
            inlinedFrames.put(resultEntry.getFirst(), resultEntry.getSecond());
        }
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(inlinedFrames){
            final /* synthetic */ Map<ULong, List<Range.Range>> $inlinedFrames;
            {
                this.$inlinedFrames = $inlinedFrames;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Generated inlined frames: " + this.$inlinedFrames;
            }
        });
        return inlinedFrames;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ULong, List<Range.Range>> llvmSymbolizerOutputToRange(LlvmSymbolizerOutput llvmSymbolizerOutput) {
        void $this$mapNotNullTo$iv$iv;
        if (llvmSymbolizerOutput.getAddress() == null || llvmSymbolizerOutput.getSymbol() == null) {
            return null;
        }
        if (!StringsKt.startsWith$default(llvmSymbolizerOutput.getAddress(), "0x", false, 2, null)) {
            DebugInfoReaderKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(llvmSymbolizerOutput){
                final /* synthetic */ LlvmSymbolizerOutput $llvmSymbolizerOutput;
                {
                    this.$llvmSymbolizerOutput = $llvmSymbolizerOutput;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "address '" + this.$llvmSymbolizerOutput.getAddress() + "' does not start with '0x'";
                }
            });
            return null;
        }
        String string = llvmSymbolizerOutput.getAddress().substring(2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        ULong uLongAddress = UStringsKt.toULongOrNull(string, 16);
        if (uLongAddress == null) {
            return null;
        }
        Iterable $this$mapNotNull$iv = llvmSymbolizerOutput.getSymbol();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Range.Range it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol symbol = (Symbol)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.symbolToRange(symbol) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inlinedFrames = (List)destination$iv$iv;
        return inlinedFrames.isEmpty() ? null : new Pair<ULong, List>(uLongAddress, inlinedFrames);
    }

    private final Range.Range symbolToRange(Symbol symbol) {
        if (symbol.getLine-pVg5ArA() == UInt.constructor-impl(0) || symbol.getColumn-pVg5ArA() == UInt.constructor-impl(0)) {
            return null;
        }
        int rangeLineNumber = UInt.constructor-impl(symbol.getLine-pVg5ArA() - UInt.constructor-impl(1));
        int rangeColNumber = UInt.constructor-impl(symbol.getColumn-pVg5ArA() - UInt.constructor-impl(1));
        SourcePosition sourcePositionStart = new SourcePosition(rangeLineNumber, rangeColNumber, null);
        SourcePosition sourcePositionEnd = new SourcePosition(UInt.constructor-impl(rangeLineNumber + UInt.constructor-impl(1)), UInt.constructor-impl(0), null);
        return new Range.Range(symbol.getFileName(), sourcePositionStart, sourcePositionEnd);
    }

    private final boolean fileExistsInSourcesDir(Range.Range range) {
        File file = new File(Config.INSTANCE.prependSourcesDir(range.getFile()));
        DebugInfoReaderKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(range, file){
            final /* synthetic */ Range.Range $range;
            final /* synthetic */ File $file;
            {
                this.$range = $range;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Considering range for file '" + this.$range.getFile() + "' at " + this.$range.getStart().getLineForIDE() + ":" + this.$range.getStart().getCharacterForIDE() + "-" + this.$range.getEnd().getLineForIDE() + ":" + this.$range.getEnd().getCharacterForIDE() + ". File '" + this.$file + "' exists: " + this.$file.exists();
            }
        });
        boolean pathIsRelative = !Paths.get(range.getFile(), new String[0]).isAbsolute();
        return pathIsRelative && file.exists();
    }
}

