/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlTagSkipType;
import org.owasp.shim.Java8Shim;

@Immutable
final class ElementAndAttributePolicies {
    final String elementName;
    final ElementPolicy elPolicy;
    final Map<String, AttributePolicy> attrPolicies;
    final HtmlTagSkipType htmlTagSkipType;

    ElementAndAttributePolicies(String elementName, ElementPolicy elPolicy, Map<? extends String, ? extends AttributePolicy> attrPolicies, HtmlTagSkipType htmlTagSkipType) {
        this.elementName = elementName;
        this.elPolicy = elPolicy;
        this.attrPolicies = Java8Shim.j8().mapCopyOf(attrPolicies);
        this.htmlTagSkipType = htmlTagSkipType;
    }

    ElementAndAttributePolicies and(ElementAndAttributePolicies p2) {
        String attrName;
        assert (this.elementName.equals(p2.elementName)) : this.elementName + " != " + p2.elementName;
        HashMap<String, AttributePolicy> joinedAttrPolicies = new HashMap<String, AttributePolicy>();
        for (Map.Entry<String, AttributePolicy> e : this.attrPolicies.entrySet()) {
            attrName = e.getKey();
            AttributePolicy a = e.getValue();
            AttributePolicy b = p2.attrPolicies.get(attrName);
            if (b != null) {
                a = AttributePolicy.Util.join(a, b);
            }
            joinedAttrPolicies.put(attrName, a);
        }
        for (Map.Entry<String, AttributePolicy> e : p2.attrPolicies.entrySet()) {
            attrName = e.getKey();
            if (this.attrPolicies.containsKey(attrName)) continue;
            joinedAttrPolicies.put(attrName, e.getValue());
        }
        return new ElementAndAttributePolicies(this.elementName, ElementPolicy.Util.join(this.elPolicy, p2.elPolicy), Collections.unmodifiableMap(joinedAttrPolicies), this.htmlTagSkipType.and(p2.htmlTagSkipType));
    }

    ElementAndAttributePolicies andGlobals(Map<String, AttributePolicy> globalAttrPolicies) {
        String attrName;
        if (globalAttrPolicies.isEmpty()) {
            return this;
        }
        LinkedHashMap<String, AttributePolicy> anded = null;
        for (Map.Entry<String, AttributePolicy> e : this.attrPolicies.entrySet()) {
            attrName = e.getKey();
            AttributePolicy globalAttrPolicy = globalAttrPolicies.get(attrName);
            if (globalAttrPolicy == null) continue;
            AttributePolicy attrPolicy = e.getValue();
            AttributePolicy joined = AttributePolicy.Util.join(attrPolicy, globalAttrPolicy);
            if (joined.equals(attrPolicy)) continue;
            if (anded == null) {
                anded = new LinkedHashMap<String, AttributePolicy>(this.attrPolicies);
            }
            anded.put(attrName, joined);
        }
        for (Map.Entry<String, AttributePolicy> e : globalAttrPolicies.entrySet()) {
            attrName = e.getKey();
            if (this.attrPolicies.containsKey(attrName)) continue;
            if (anded == null) {
                anded = new LinkedHashMap<String, AttributePolicy>(this.attrPolicies);
            }
            anded.put(attrName, e.getValue());
        }
        if (anded == null) {
            return this;
        }
        return new ElementAndAttributePolicies(this.elementName, this.elPolicy, anded, this.htmlTagSkipType);
    }
}

