/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssGrammar;
import org.owasp.html.CssSchema;
import org.owasp.html.Joinable;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

@TCB
final class StylingPolicy
implements AttributePolicy.JoinableAttributePolicy {
    final CssSchema cssSchema;
    final Function<String, String> urlRewriter;

    StylingPolicy(CssSchema cssSchema, Function<String, String> urlRewriter) {
        this.cssSchema = cssSchema;
        this.urlRewriter = urlRewriter;
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, String value2) {
        return value2 != null ? this.sanitizeCssProperties(value2) : null;
    }

    String sanitizeCssProperties(String style) {
        final StringBuilder sanitizedCss = new StringBuilder();
        CssGrammar.parsePropertyGroup(style, new CssGrammar.PropertyHandler(){
            CssSchema.Property cssProperty = CssSchema.DISALLOWED;
            List<CssSchema.Property> cssProperties = null;
            int propertyStart = 0;
            boolean hasTokens;
            boolean inQuotedIdents;
            String lastToken = null;
            private static final int IDENT_TO_STRING = 72;

            private void emitToken(String token2) {
                this.closeQuotedIdents();
                if (this.hasTokens) {
                    sanitizedCss.append(' ');
                }
                sanitizedCss.append(token2);
                this.hasTokens = true;
            }

            private void closeQuotedIdents() {
                if (this.inQuotedIdents) {
                    sanitizedCss.append('\'');
                    this.inQuotedIdents = false;
                }
            }

            private void sanitizeAndAppendUrl(String urlContent) {
                String rewrittenUrl;
                if (urlContent.length() < 1024 && (rewrittenUrl = StylingPolicy.this.urlRewriter.apply(urlContent)) != null && !rewrittenUrl.isEmpty()) {
                    if (this.hasTokens) {
                        sanitizedCss.append(' ');
                    }
                    sanitizedCss.append("url('").append(rewrittenUrl).append("')");
                    this.hasTokens = true;
                }
            }

            @Override
            public void url(String token2) {
                this.closeQuotedIdents();
                if (this.cssProperty != null && (this.cssProperty.bits & 0x10) != 0) {
                    String urlContent = CssGrammar.cssContent(Strings.stripHtmlSpaces(token2.substring(4, token2.length() - 1)));
                    this.sanitizeAndAppendUrl(urlContent);
                }
                this.lastToken = token2;
            }

            @Override
            public void startProperty(String propertyName) {
                if (this.cssProperties != null) {
                    this.cssProperties.clear();
                }
                this.cssProperty = StylingPolicy.this.cssSchema.forKey(propertyName);
                this.hasTokens = false;
                this.propertyStart = sanitizedCss.length();
                if (sanitizedCss.length() != 0) {
                    sanitizedCss.append(';');
                }
                sanitizedCss.append(propertyName).append(':');
            }

            @Override
            public void startFunction(String uncanonToken) {
                this.closeQuotedIdents();
                if (this.cssProperties == null) {
                    this.cssProperties = new ArrayList<CssSchema.Property>();
                }
                this.cssProperties.add(this.cssProperty);
                String token2 = Strings.toLowerCase(uncanonToken);
                String key = this.cssProperty.fnKeys.get(token2);
                CssSchema.Property property = this.cssProperty = key != null ? StylingPolicy.this.cssSchema.forKey(key) : CssSchema.DISALLOWED;
                if (this.cssProperty != CssSchema.DISALLOWED) {
                    this.emitToken(token2);
                }
                this.lastToken = token2;
            }

            @Override
            public void quotedString(String token2) {
                this.closeQuotedIdents();
                int meaning = this.cssProperty.bits & 0x50;
                if ((meaning & meaning - 1) == 0) {
                    if (meaning == 64 && token2.length() > 2 && StylingPolicy.isAlphanumericOrSpaceOrHyphen(token2, 1, token2.length() - 1)) {
                        this.emitToken(Strings.toLowerCase(token2));
                    } else if (meaning == 16) {
                        this.sanitizeAndAppendUrl(CssGrammar.cssContent(token2));
                    }
                }
                this.lastToken = token2;
            }

            @Override
            public void quantity(String token2) {
                int test;
                int n = test = token2.startsWith("-") ? 4 : 1;
                if ((this.cssProperty.bits & test) != 0 || this.cssProperty.literals.contains(token2)) {
                    this.emitToken(token2);
                }
                this.lastToken = token2;
            }

            @Override
            public void punctuation(String token2) {
                this.closeQuotedIdents();
                if (this.cssProperty.literals.contains(token2)) {
                    this.emitToken(token2);
                }
                this.lastToken = token2;
            }

            @Override
            public void identifier(String uncanonToken) {
                String token2 = Strings.toLowerCase(uncanonToken);
                if ("!".equals(this.lastToken) && "important".equals(token2)) {
                    this.emitToken("!important");
                } else if (this.cssProperty.literals.contains(token2)) {
                    this.emitToken(token2);
                } else if ((this.cssProperty.bits & 0x48) == 72) {
                    if (!this.inQuotedIdents) {
                        this.inQuotedIdents = true;
                        if (this.hasTokens) {
                            sanitizedCss.append(' ');
                        }
                        sanitizedCss.append('\'');
                        this.hasTokens = true;
                    } else {
                        sanitizedCss.append(' ');
                    }
                    sanitizedCss.append(Strings.toLowerCase(token2));
                }
                this.lastToken = token2;
            }

            @Override
            public void hash(String token2) {
                this.closeQuotedIdents();
                if ((this.cssProperty.bits & 2) != 0) {
                    this.emitToken(Strings.toLowerCase(token2));
                }
                this.lastToken = token2;
            }

            @Override
            public void endProperty() {
                if (!this.hasTokens) {
                    sanitizedCss.setLength(this.propertyStart);
                } else {
                    this.closeQuotedIdents();
                }
                this.lastToken = null;
            }

            @Override
            public void endFunction(String token2) {
                if (this.cssProperty != CssSchema.DISALLOWED) {
                    this.emitToken(")");
                }
                this.cssProperty = this.cssProperties.remove(this.cssProperties.size() - 1);
                this.lastToken = ")";
            }
        });
        return sanitizedCss.length() == 0 ? null : sanitizedCss.toString();
    }

    static boolean isAlphanumericOrSpaceOrHyphen(String token2, int start, int end) {
        for (int i = start; i < end; ++i) {
            int chLower;
            char ch = token2.charAt(i);
            if (!(ch <= ' ' ? ch != '\t' && ch != ' ' : !(48 <= (chLower = ch | 0x20) && chLower <= 57 || 97 <= chLower && chLower <= 122 || '-' == ch))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.cssSchema.equals(((StylingPolicy)o).cssSchema);
    }

    public int hashCode() {
        return this.cssSchema.hashCode();
    }

    @Override
    public Joinable.JoinStrategy<AttributePolicy.JoinableAttributePolicy> getJoinStrategy() {
        return StylingPolicyJoinStrategy.INSTANCE;
    }

    static final class StylingPolicyJoinStrategy
    implements Joinable.JoinStrategy<AttributePolicy.JoinableAttributePolicy> {
        static final StylingPolicyJoinStrategy INSTANCE = new StylingPolicyJoinStrategy();

        StylingPolicyJoinStrategy() {
        }

        @Override
        public AttributePolicy.JoinableAttributePolicy join(Iterable<? extends AttributePolicy.JoinableAttributePolicy> toJoin) {
            Function<String, String> identity = Function.identity();
            CssSchema cssSchema = null;
            Function<String, String> urlRewriter = identity;
            for (AttributePolicy.JoinableAttributePolicy joinableAttributePolicy : toJoin) {
                StylingPolicy sp = (StylingPolicy)joinableAttributePolicy;
                cssSchema = cssSchema == null ? sp.cssSchema : CssSchema.union(cssSchema, sp.cssSchema);
                urlRewriter = urlRewriter.equals(identity) || urlRewriter.equals(sp.urlRewriter) ? sp.urlRewriter : urlRewriter.compose(sp.urlRewriter);
            }
            return new StylingPolicy(cssSchema, urlRewriter);
        }
    }
}

