/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.Config;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLType;
import spec.cvlast.StorageComparisonChecker;
import spec.cvlast.StorageComparisonCheckerKt;
import spec.cvlast.transformer.CVLAstTransformer;
import spec.cvlast.transformer.CVLCmdTransformer;
import spec.cvlast.transformer.CVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0005j\b\u0012\u0004\u0012\u00020\u0002`\t2\u0006\u0010\u0004\u001a\u00020\u0006J\n\u0010\n\u001a\u00020\u000b*\u00020\f\u00a8\u0006\r"}, d2={"Lspec/cvlast/StorageComparisonChecker;", "Lspec/cvlast/transformer/CVLAstTransformer;", "Lspec/cvlast/typechecker/CVLError;", "()V", "ast", "Lutils/CollectingResult;", "Lspec/cvlast/CVLAst;", "check", "", "Lutils/VoidResult;", "isStorageOperand", "", "Lspec/cvlast/CVLExp;", "Shared"})
public final class StorageComparisonChecker
extends CVLAstTransformer<CVLError> {
    @NotNull
    public static final StorageComparisonChecker INSTANCE = new StorageComparisonChecker();

    private StorageComparisonChecker() {
        CVLExpTransformer<CVLError> cVLExpTransformer = new CVLExpTransformer<CVLError>(){

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp, CVLError> relop(@NotNull CVLExp.RelopExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return StorageComparisonCheckerKt.access$isStorageOperand(exp2.getR()) || StorageComparisonCheckerKt.access$isStorageOperand(exp2.getL()) ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Without grounding enabled, cannot use direct storage comparisons except in an assertion command.")) : CVLExpTransformer.DefaultImpls.relop(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs, CVLError> lhs(@NotNull CVLLhs lhs) {
                return CVLExpTransformer.DefaultImpls.lhs(this, lhs);
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs.Id, CVLError> idLhs(@NotNull CVLLhs.Id idLhs2) {
                return CVLExpTransformer.DefaultImpls.idLhs(this, idLhs2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> expr(@NotNull CVLExp exp2) {
                return CVLExpTransformer.DefaultImpls.expr(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> application(@NotNull CVLExp.ApplicationExp exp2) {
                return CVLExpTransformer.DefaultImpls.application(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> applyExp(@NotNull CVLExp.ApplyExp exp2) {
                return CVLExpTransformer.DefaultImpls.applyExp(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLBuiltIn, CVLError> builtin(@NotNull CVLExp.ApplyExp.CVLBuiltIn exp2) {
                return CVLExpTransformer.DefaultImpls.builtin(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp, CVLError> arithRelop(@NotNull CVLExp.RelopExp.ArithRelopExp exp2) {
                return CVLExpTransformer.DefaultImpls.arithRelop(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> const(@NotNull CVLExp.Constant exp2) {
                return CVLExpTransformer.DefaultImpls.const(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs.Array, CVLError> arrayLhs(@NotNull CVLLhs.Array arrayLhs2) {
                return CVLExpTransformer.DefaultImpls.arrayLhs(this, arrayLhs2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnresolvedApplyExp, CVLError> unresolvedApplyExp(@NotNull CVLExp.UnresolvedApplyExp exp2) {
                return CVLExpTransformer.DefaultImpls.unresolvedApplyExp(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.AddressFunctionCallExp, CVLError> addressFunctionCall(@NotNull CVLExp.AddressFunctionCallExp exp2) {
                return CVLExpTransformer.DefaultImpls.addressFunctionCall(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GeExp, CVLError> ge(@NotNull CVLExp.RelopExp.ArithRelopExp.GeExp exp2) {
                return CVLExpTransformer.DefaultImpls.ge(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GtExp, CVLError> gt(@NotNull CVLExp.RelopExp.ArithRelopExp.GtExp exp2) {
                return CVLExpTransformer.DefaultImpls.gt(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LeExp, CVLError> le(@NotNull CVLExp.RelopExp.ArithRelopExp.LeExp exp2) {
                return CVLExpTransformer.DefaultImpls.le(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LtExp, CVLError> lt(@NotNull CVLExp.RelopExp.ArithRelopExp.LtExp exp2) {
                return CVLExpTransformer.DefaultImpls.lt(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.EqExp, CVLError> eq(@NotNull CVLExp.RelopExp.EqExp exp2) {
                return CVLExpTransformer.DefaultImpls.eq(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.NeExp, CVLError> ne(@NotNull CVLExp.RelopExp.NeExp exp2) {
                return CVLExpTransformer.DefaultImpls.ne(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.AddExp, CVLError> add(@NotNull CVLExp.BinaryExp.AddExp exp2) {
                return CVLExpTransformer.DefaultImpls.add(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> enumConstant(@NotNull CVLExp.Constant.EnumConstant exp2) {
                return CVLExpTransformer.DefaultImpls.enumConstant(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.BoolLit, CVLError> boolLit(@NotNull CVLExp.Constant.BoolLit exp2) {
                return CVLExpTransformer.DefaultImpls.boolLit(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.NumberLit, CVLError> numberLit(@NotNull CVLExp.Constant.NumberLit exp2) {
                return CVLExpTransformer.DefaultImpls.numberLit(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.StringLit, CVLError> stringLit(@NotNull CVLExp.Constant.StringLit exp2) {
                return CVLExpTransformer.DefaultImpls.stringLit(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.StructLit, CVLError> structLit(@NotNull CVLExp.Constant.StructLit exp2) {
                return CVLExpTransformer.DefaultImpls.structLit(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.SignatureLiteralExp, CVLError> signatureLit(@NotNull CVLExp.Constant.SignatureLiteralExp exp2) {
                return CVLExpTransformer.DefaultImpls.signatureLit(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.Ghost, CVLError> ghost(@NotNull CVLExp.ApplyExp.Ghost exp2) {
                return CVLExpTransformer.DefaultImpls.ghost(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.CastExpr, CVLError> castExpression(@NotNull CVLExp.CastExpr exp2) {
                return CVLExpTransformer.DefaultImpls.castExpression(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> definition(@NotNull CVLExp.ApplyExp.Definition exp2) {
                return CVLExpTransformer.DefaultImpls.definition(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLFunction, CVLError> call(@NotNull CVLExp.ApplyExp.CVLFunction exp2) {
                return CVLExpTransformer.DefaultImpls.call(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.DivExp, CVLError> div(@NotNull CVLExp.BinaryExp.DivExp exp2) {
                return CVLExpTransformer.DefaultImpls.div(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ModExp, CVLError> mod(@NotNull CVLExp.BinaryExp.ModExp exp2) {
                return CVLExpTransformer.DefaultImpls.mod(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ExponentExp, CVLError> exponent(@NotNull CVLExp.BinaryExp.ExponentExp exp2) {
                return CVLExpTransformer.DefaultImpls.exponent(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.IffExp, CVLError> iff(@NotNull CVLExp.BinaryExp.IffExp exp2) {
                return CVLExpTransformer.DefaultImpls.iff(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ImpliesExp, CVLError> implies(@NotNull CVLExp.BinaryExp.ImpliesExp exp2) {
                return CVLExpTransformer.DefaultImpls.implies(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwOrExp, CVLError> bwor(@NotNull CVLExp.BinaryExp.BwOrExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwor(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwXOrExp, CVLError> bwxor(@NotNull CVLExp.BinaryExp.BwXOrExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwxor(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwAndExp, CVLError> bwand(@NotNull CVLExp.BinaryExp.BwAndExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwand(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwLeftShiftExp, CVLError> bwlsh(@NotNull CVLExp.BinaryExp.BwLeftShiftExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwlsh(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftExp, CVLError> bwrsh(@NotNull CVLExp.BinaryExp.BwRightShiftExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwrsh(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftWithZerosExp, CVLError> bwrshwzeros(@NotNull CVLExp.BinaryExp.BwRightShiftWithZerosExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwrshwzeros(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.BwNotExp, CVLError> bwnot(@NotNull CVLExp.UnaryExp.BwNotExp exp2) {
                return CVLExpTransformer.DefaultImpls.bwnot(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.ContractFunction, CVLError> invokeExp(@NotNull CVLExp.ApplyExp.ContractFunction exp2) {
                return CVLExpTransformer.DefaultImpls.invokeExp(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ArrayLitExp, CVLError> arrayexp(@NotNull CVLExp.ArrayLitExp exp2) {
                return CVLExpTransformer.DefaultImpls.arrayexp(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.CondExp, CVLError> condexp(@NotNull CVLExp.CondExp exp2) {
                return CVLExpTransformer.DefaultImpls.condexp(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LandExp, CVLError> land(@NotNull CVLExp.BinaryExp.LandExp exp2) {
                return CVLExpTransformer.DefaultImpls.land(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LorExp, CVLError> lor(@NotNull CVLExp.BinaryExp.LorExp exp2) {
                return CVLExpTransformer.DefaultImpls.lor(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.MulExp, CVLError> mul(@NotNull CVLExp.BinaryExp.MulExp exp2) {
                return CVLExpTransformer.DefaultImpls.mul(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.LNotExp, CVLError> neg(@NotNull CVLExp.UnaryExp.LNotExp exp2) {
                return CVLExpTransformer.DefaultImpls.neg(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> quant(@NotNull CVLExp.QuantifierExp exp2) {
                return CVLExpTransformer.DefaultImpls.quant(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> sum(@NotNull CVLExp.SumExp exp2) {
                return CVLExpTransformer.DefaultImpls.sum(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.FieldSelectExp, CVLError> fieldSel(@NotNull CVLExp.FieldSelectExp exp2) {
                return CVLExpTransformer.DefaultImpls.fieldSel(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.SetMemExp, CVLError> setmem(@NotNull CVLExp.SetMemExp exp2) {
                return CVLExpTransformer.DefaultImpls.setmem(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ArrayDerefExp, CVLError> arrayderef(@NotNull CVLExp.ArrayDerefExp exp2) {
                return CVLExpTransformer.DefaultImpls.arrayderef(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.SubExp, CVLError> sub(@NotNull CVLExp.BinaryExp.SubExp exp2) {
                return CVLExpTransformer.DefaultImpls.sub(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.UnaryMinusExp, CVLError> unaryMinus(@NotNull CVLExp.UnaryExp.UnaryMinusExp exp2) {
                return CVLExpTransformer.DefaultImpls.unaryMinus(this, exp2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> variable(@NotNull CVLExp.VariableExp exp2) {
                return CVLExpTransformer.DefaultImpls.variable(this, exp2);
            }
        };
        super(new CVLCmdTransformer<CVLError>(cVLExpTransformer){

            @Override
            @NotNull
            public CollectingResult<CVLCmd, CVLError> assertCmd(@NotNull CVLCmd.Simple.Assert cmd2) {
                Intrinsics.checkNotNullParameter(cmd2, "cmd");
                if (cmd2.getExp() instanceof CVLExp.RelopExp && StorageComparisonCheckerKt.access$isStorageOperand(((CVLExp.RelopExp)cmd2.getExp()).getR())) {
                    return ((CVLExp.RelopExp)cmd2.getExp()).getRelop() == CVLExp.RelopExp.CVLERelop.EQ ? (CollectingResult)CollectingResult.Companion.lift(cmd2) : (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(cmd2.getExp(), "Without grounding enabled, only assertions of storage equality are allowed."));
                }
                return super.assertCmd(cmd2);
            }
        }, null, 2, null);
    }

    public final boolean isStorageOperand(@NotNull CVLExp $this$isStorageOperand) {
        Intrinsics.checkNotNullParameter($this$isStorageOperand, "<this>");
        return $this$isStorageOperand.getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.BlockchainState || $this$isStorageOperand.getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.StorageReference;
    }

    @Override
    @NotNull
    public CollectingResult<CVLAst, CVLError> ast(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        return (Boolean)Config.INSTANCE.getGroundQuantifiers().get() != false ? (CollectingResult)CollectingResult.Companion.lift(ast2) : super.ast(ast2);
    }

    @NotNull
    public final CollectingResult<Unit, CVLError> check(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        return CollectingResult.Companion.map(this.ast(ast2), check.1.INSTANCE);
    }
}

