/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLhs;
import spec.cvlast.transformer.CVLExpTransformer;
import utils.CollectingResult;
import utils.ErrorCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J(\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020'H\u0016J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020+H\u0016J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020-H\u0016J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u00020/H\u0016J\u001c\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u000201H\u0016J\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u000203H\u0016J\u001c\u00104\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000b\u001a\u000205H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00066"}, d2={"Lspec/cvlast/transformer/CVLCmdTransformer;", "E", "", "expTransformer", "Lspec/cvlast/transformer/CVLExpTransformer;", "(Lspec/cvlast/transformer/CVLExpTransformer;)V", "getExpTransformer", "()Lspec/cvlast/transformer/CVLExpTransformer;", "applyCmd", "Lutils/CollectingResult;", "Lspec/cvlast/CVLCmd;", "cmd", "Lspec/cvlast/CVLCmd$Simple$Apply;", "assertCmd", "Lspec/cvlast/CVLCmd$Simple$Assert;", "assumeCmd", "Lspec/cvlast/CVLCmd$Simple$AssumeCmd$Assume;", "assumeInv", "Lspec/cvlast/CVLCmd$Simple$AssumeCmd$AssumeInvariant;", "blockCmd", "Lspec/cvlast/CVLCmd$Composite$Block;", "cmdList", "", "list", "composite", "Lspec/cvlast/CVLCmd$Composite;", "decl", "Lspec/cvlast/CVLCmd$Simple$Declaration;", "def", "Lspec/cvlast/CVLCmd$Simple$Definition;", "expCmd", "Lspec/cvlast/CVLCmd$Simple$Exp;", "havoc", "Lspec/cvlast/CVLCmd$Simple$Havoc;", "ifCmd", "Lspec/cvlast/CVLCmd$Composite$If;", "labelEndCmd", "Lspec/cvlast/CVLCmd$Simple$Label$End;", "labelStartCmd", "Lspec/cvlast/CVLCmd$Simple$Label$Start;", "nop", "Lspec/cvlast/CVLCmd$Simple$Nop;", "resetStorage", "Lspec/cvlast/CVLCmd$Simple$ResetStorage;", "resetTransientStorage", "Lspec/cvlast/CVLCmd$Simple$ResetTransientStorage;", "returnCmd", "Lspec/cvlast/CVLCmd$Simple$Return;", "revert", "Lspec/cvlast/CVLCmd$Simple$Revert;", "satisfyCmd", "Lspec/cvlast/CVLCmd$Simple$Satisfy;", "simple", "Lspec/cvlast/CVLCmd$Simple;", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLCmdTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLCmdTransformer.kt\nspec/cvlast/transformer/CVLCmdTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1549#2:172\n1620#2,3:173\n1549#2:176\n1620#2,3:177\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,3:185\n1549#2:188\n1620#2,3:189\n*S KotlinDebug\n*F\n+ 1 CVLCmdTransformer.kt\nspec/cvlast/transformer/CVLCmdTransformer\n*L\n53#1:172\n53#1:173,3\n106#1:176\n106#1:177,3\n113#1:180\n113#1:181,3\n152#1:184\n152#1:185,3\n158#1:188\n158#1:189,3\n*E\n"})
public class CVLCmdTransformer<E> {
    @NotNull
    private final CVLExpTransformer<E> expTransformer;

    public CVLCmdTransformer(@NotNull CVLExpTransformer<? extends E> expTransformer2) {
        Intrinsics.checkNotNullParameter(expTransformer2, "expTransformer");
        this.expTransformer = expTransformer2;
    }

    @NotNull
    public final CVLExpTransformer<E> getExpTransformer() {
        return this.expTransformer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CollectingResult<CVLCmd, E>> cmdList(@NotNull List<? extends CVLCmd> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CVLCmd cVLCmd = (CVLCmd)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cmd((CVLCmd)it2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public CollectingResult<CVLCmd, E> cmd(@NotNull CVLCmd cmd2) {
        CollectingResult<CVLCmd, E> collectingResult;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        CVLCmd cVLCmd = cmd2;
        if (cVLCmd instanceof CVLCmd.Simple) {
            collectingResult = this.simple((CVLCmd.Simple)cmd2);
        } else if (cVLCmd instanceof CVLCmd.Composite) {
            collectingResult = this.composite((CVLCmd.Composite)cmd2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collectingResult;
    }

    @NotNull
    public CollectingResult<CVLCmd, E> simple(@NotNull CVLCmd.Simple cmd2) {
        CollectingResult<CVLCmd, E> collectingResult;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        CVLCmd.Simple simple = cmd2;
        if (simple instanceof CVLCmd.Simple.Assert) {
            collectingResult = this.assertCmd((CVLCmd.Simple.Assert)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Satisfy) {
            collectingResult = this.satisfyCmd((CVLCmd.Simple.Satisfy)cmd2);
        } else if (simple instanceof CVLCmd.Simple.AssumeCmd.Assume) {
            collectingResult = this.assumeCmd((CVLCmd.Simple.AssumeCmd.Assume)cmd2);
        } else if (simple instanceof CVLCmd.Simple.AssumeCmd.AssumeInvariant) {
            collectingResult = this.assumeInv((CVLCmd.Simple.AssumeCmd.AssumeInvariant)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Declaration) {
            collectingResult = this.decl((CVLCmd.Simple.Declaration)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Definition) {
            collectingResult = this.def((CVLCmd.Simple.Definition)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Exp) {
            collectingResult = this.expCmd((CVLCmd.Simple.Exp)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Apply) {
            collectingResult = this.applyCmd((CVLCmd.Simple.Apply)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Havoc) {
            collectingResult = this.havoc((CVLCmd.Simple.Havoc)cmd2);
        } else if (simple instanceof CVLCmd.Simple.ResetStorage) {
            collectingResult = this.resetStorage((CVLCmd.Simple.ResetStorage)cmd2);
        } else if (simple instanceof CVLCmd.Simple.ResetTransientStorage) {
            collectingResult = this.resetTransientStorage((CVLCmd.Simple.ResetTransientStorage)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Return) {
            collectingResult = this.returnCmd((CVLCmd.Simple.Return)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Revert) {
            collectingResult = this.revert((CVLCmd.Simple.Revert)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Label.Start) {
            collectingResult = this.labelStartCmd((CVLCmd.Simple.Label.Start)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Label.End) {
            collectingResult = this.labelEndCmd((CVLCmd.Simple.Label.End)cmd2);
        } else if (simple instanceof CVLCmd.Simple.Nop) {
            collectingResult = this.nop((CVLCmd.Simple.Nop)cmd2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collectingResult;
    }

    @NotNull
    public CollectingResult<CVLCmd, E> composite(@NotNull CVLCmd.Composite cmd2) {
        CollectingResult<CVLCmd, E> collectingResult;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        CVLCmd.Composite composite = cmd2;
        if (composite instanceof CVLCmd.Composite.Block) {
            collectingResult = this.blockCmd((CVLCmd.Composite.Block)cmd2);
        } else if (composite instanceof CVLCmd.Composite.If) {
            collectingResult = this.ifCmd((CVLCmd.Composite.If)cmd2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collectingResult;
    }

    @NotNull
    public CollectingResult<CVLCmd, E> labelStartCmd(@NotNull CVLCmd.Simple.Label.Start cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.lift(cmd2);
    }

    @NotNull
    public CollectingResult<CVLCmd, E> labelEndCmd(@NotNull CVLCmd.Simple.Label.End cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.lift(cmd2);
    }

    @NotNull
    public CollectingResult<CVLCmd, E> assertCmd(@NotNull CVLCmd.Simple.Assert cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.Assert, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Assert $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Assert, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.Assert.copy$default(this.$cmd, this.$cmd.getRange(), exp2, this.$cmd.getDescription(), null, false, 24, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> satisfyCmd(@NotNull CVLCmd.Simple.Satisfy cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.Satisfy, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Satisfy $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Satisfy, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.Satisfy.copy$default(this.$cmd, this.$cmd.getRange(), exp2, this.$cmd.getDescription(), null, false, 24, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> assumeCmd(@NotNull CVLCmd.Simple.AssumeCmd.Assume cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.AssumeCmd.Assume, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.AssumeCmd.Assume $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.AssumeCmd.Assume, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.AssumeCmd.Assume.copy$default(this.$cmd, this.$cmd.getRange(), exp2, null, null, false, 28, null));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CollectingResult<CVLCmd, E> assumeInv(@NotNull CVLCmd.Simple.AssumeCmd.AssumeInvariant cmd2) {
        Collection<CollectingResult<CVLExp, E>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        Iterable iterable = cmd2.getParams();
        CollectingResult.Companion companion = CollectingResult.Companion;
        CollectingResult.Companion companion2 = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            CVLExp cVLExp = (CVLExp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.expTransformer.expr((CVLExp)param));
        }
        collection = (List)destination$iv$iv;
        return companion2.bind(companion.flatten(collection), new Function1<List<? extends CVLExp>, CollectingResult<? extends CVLCmd.Simple.AssumeCmd.AssumeInvariant, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.AssumeCmd.AssumeInvariant $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.AssumeCmd.AssumeInvariant, E> invoke(@NotNull List<? extends CVLExp> params) {
                Intrinsics.checkNotNullParameter(params, "params");
                return CollectingResult.Companion.lift(CVLCmd.Simple.AssumeCmd.AssumeInvariant.copy$default(this.$cmd, this.$cmd.getRange(), this.$cmd.getId(), params, null, 8, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> decl(@NotNull CVLCmd.Simple.Declaration cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.lift(cmd2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CollectingResult<CVLCmd, E> def(@NotNull CVLCmd.Simple.Definition cmd2) {
        Collection<CollectingResult<CVLLhs, E>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        Iterable iterable = cmd2.getIdL();
        CollectingResult.Companion companion = CollectingResult.Companion;
        CollectingResult.Companion companion2 = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void lhs;
            CVLLhs cVLLhs = (CVLLhs)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.expTransformer.lhs((CVLLhs)lhs));
        }
        collection = (List)destination$iv$iv;
        return companion2.bind(companion.flatten(collection), this.expTransformer.expr(cmd2.getExp()), new Function2<List<? extends CVLLhs>, CVLExp, CollectingResult<? extends CVLCmd.Simple.Definition, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Definition $cmd;
            {
                this.$cmd = $cmd;
                super(2);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Definition, E> invoke(@NotNull List<? extends CVLLhs> idL, @NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(idL, "idL");
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.Definition.copy$default(this.$cmd, this.$cmd.getRange(), this.$cmd.getType(), idL, exp2, null, 16, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> expCmd(@NotNull CVLCmd.Simple.Exp cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.Exp, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Exp $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Exp, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.Exp.copy$default(this.$cmd, this.$cmd.getRange(), exp2, null, 4, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> applyCmd(@NotNull CVLCmd.Simple.Apply cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.Apply, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Apply $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Apply, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                CVLExp.ApplicationExp applicationExp = exp2 instanceof CVLExp.ApplicationExp ? (CVLExp.ApplicationExp)exp2 : null;
                if (applicationExp == null) {
                    throw new IllegalStateException(("transformer must transform an ApplyExp to an ApplyExp (got " + exp2 + ")").toString());
                }
                return CollectingResult.Companion.lift(CVLCmd.Simple.Apply.copy$default(this.$cmd, this.$cmd.getRange(), applicationExp, null, 4, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> havoc(@NotNull CVLCmd.Simple.Havoc cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return ErrorCollector.Companion.collectingErrors(new Function1<ErrorCollector<E>, CVLCmd.Simple.Havoc>(cmd2, this){
            final /* synthetic */ CVLCmd.Simple.Havoc $cmd;
            final /* synthetic */ CVLCmdTransformer<E> this$0;
            {
                this.$cmd = $cmd;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CVLCmd.Simple.Havoc invoke(@NotNull ErrorCollector<E> $this$collectingErrors) {
                CollectingResult<CVLExp, E> collectingResult;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                Iterable iterable = this.$cmd.getTargets();
                CVLCmdTransformer<E> cVLCmdTransformer = this.this$0;
                CollectingResult.Companion companion = CollectingResult.Companion;
                boolean $i$f$map = false;
                CVLExpTransformer<E> cVLExpTransformer = $this$map$iv;
                Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void target;
                    CVLExp.HavocTarget havocTarget = (CVLExp.HavocTarget)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CVLExp.HavocTarget.Companion.downcastToHavocTarget(cVLCmdTransformer.getExpTransformer().expr(target.getAsExp())));
                }
                CollectingResult<List<R>, E> targets = companion.flatten((List)destination$iv$iv);
                CollectingResult.Companion companion2 = CollectingResult.Companion;
                CVLExp cVLExp = this.$cmd.getAssumingExp();
                if (cVLExp != null) {
                    void p0;
                    CVLExp cVLExp2 = cVLExp;
                    cVLExpTransformer = this.this$0.getExpTransformer();
                    destination$iv$iv = cVLExp2;
                    companion = companion2;
                    boolean bl = false;
                    collectingResult = cVLExpTransformer.expr((CVLExp)p0);
                    companion2 = companion;
                } else {
                    collectingResult = null;
                }
                CollectingResult<R, E> assumingExp2 = companion2.transpose(collectingResult);
                return (CVLCmd.Simple.Havoc)$this$collectingErrors.map(targets, assumingExp2, (Function2)new Function2<List<? extends CVLExp.HavocTarget>, CVLExp, CVLCmd.Simple.Havoc>(this.$cmd){
                    final /* synthetic */ CVLCmd.Simple.Havoc $cmd;
                    {
                        this.$cmd = $cmd;
                        super(2);
                    }

                    @NotNull
                    public final CVLCmd.Simple.Havoc invoke(@NotNull List<? extends CVLExp.HavocTarget> newTargets, @Nullable CVLExp newAssumingExp) {
                        Intrinsics.checkNotNullParameter(newTargets, "newTargets");
                        return CVLCmd.Simple.Havoc.copy$default(this.$cmd, null, newTargets, newAssumingExp, null, 9, null);
                    }
                });
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> resetStorage(@NotNull CVLCmd.Simple.ResetStorage cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.ResetStorage, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.ResetStorage $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.ResetStorage, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.ResetStorage.copy$default(this.$cmd, this.$cmd.getRange(), exp2, null, 4, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> resetTransientStorage(@NotNull CVLCmd.Simple.ResetTransientStorage cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getExp()), new Function1<CVLExp, CollectingResult<? extends CVLCmd.Simple.ResetTransientStorage, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.ResetTransientStorage $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.ResetTransientStorage, E> invoke(@NotNull CVLExp exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.ResetTransientStorage.copy$default(this.$cmd, this.$cmd.getRange(), exp2, null, 4, null));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CollectingResult<CVLCmd, E> returnCmd(@NotNull CVLCmd.Simple.Return cmd2) {
        Collection<CollectingResult<CVLExp, E>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        Iterable iterable = cmd2.getExps();
        CollectingResult.Companion companion = CollectingResult.Companion;
        CollectingResult.Companion companion2 = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void exp2;
            CVLExp cVLExp = (CVLExp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.expTransformer.expr((CVLExp)exp2));
        }
        collection = (List)destination$iv$iv;
        return companion2.bind(companion.flatten(collection), new Function1<List<? extends CVLExp>, CollectingResult<? extends CVLCmd.Simple.Return, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Simple.Return $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Simple.Return, E> invoke(@NotNull List<? extends CVLExp> exp2) {
                Intrinsics.checkNotNullParameter(exp2, "exp");
                return CollectingResult.Companion.lift(CVLCmd.Simple.Return.copy$default(this.$cmd, this.$cmd.getRange(), exp2, null, 4, null));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CollectingResult<CVLCmd, E> blockCmd(@NotNull CVLCmd.Composite.Block cmd2) {
        Collection<CollectingResult<CVLCmd, E>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        Iterable iterable = cmd2.getBlock();
        CollectingResult.Companion companion = CollectingResult.Companion;
        CollectingResult.Companion companion2 = CollectingResult.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cmd3;
            CVLCmd cVLCmd = (CVLCmd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cmd((CVLCmd)cmd3));
        }
        collection = (List)destination$iv$iv;
        return companion2.bind(companion.flatten(collection), new Function1<List<? extends CVLCmd>, CollectingResult<? extends CVLCmd.Composite.Block, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Composite.Block $cmd;
            {
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Composite.Block, E> invoke(@NotNull List<? extends CVLCmd> block2) {
                Intrinsics.checkNotNullParameter(block2, "block");
                return CollectingResult.Companion.lift(CVLCmd.Composite.Block.copy$default(this.$cmd, this.$cmd.getRange(), block2, null, 4, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> ifCmd(@NotNull CVLCmd.Composite.If cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.bind(this.expTransformer.expr(cmd2.getCond()), this.cmd(cmd2.getThenCmd()), this.cmd(cmd2.getElseCmd()), new Function3<CVLExp, CVLCmd, CVLCmd, CollectingResult<? extends CVLCmd.Composite.If, ? extends E>>(cmd2){
            final /* synthetic */ CVLCmd.Composite.If $cmd;
            {
                this.$cmd = $cmd;
                super(3);
            }

            @NotNull
            public final CollectingResult<CVLCmd.Composite.If, E> invoke(@NotNull CVLExp cond, @NotNull CVLCmd thenCmd, @NotNull CVLCmd elseCmd) {
                Intrinsics.checkNotNullParameter(cond, "cond");
                Intrinsics.checkNotNullParameter(thenCmd, "thenCmd");
                Intrinsics.checkNotNullParameter(elseCmd, "elseCmd");
                return CollectingResult.Companion.lift(CVLCmd.Composite.If.copy$default(this.$cmd, this.$cmd.getRange(), cond, thenCmd, elseCmd, null, 16, null));
            }
        });
    }

    @NotNull
    public CollectingResult<CVLCmd, E> nop(@NotNull CVLCmd.Simple.Nop cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.lift(cmd2);
    }

    @NotNull
    public CollectingResult<CVLCmd, E> revert(@NotNull CVLCmd.Simple.Revert cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return CollectingResult.Companion.lift(cmd2);
    }
}

