/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.typechecker.AssignFromVoid$;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import utils.Range;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="Expressions of type `void`, such as void functions, cannot be the RHS of an assignment.")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        using PrimaryContract as pc;\n        rule r(env e) {\n            #uint256 n = pc.voidFunction(e);#\n            assert false;\n        }\n    ", exampleMessage="EVM function `PrimaryContract.voidFunction()` has type `void`. It cannot be assigned to a variable."), @CVLErrorExample(exampleCVLWithRange="\n        function returnsVoid() {\n            return;\n        }\n        rule r {\n            #_ = returnsVoid();#\n            assert false;\n        }\n    ", exampleMessage="CVL function `returnsVoid` has type `void`. It cannot be assigned to a variable.")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B7\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c1\u0001\u00a2\u0006\u0002\b\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lspec/cvlast/typechecker/AssignFromVoid;", "Lspec/cvlast/typechecker/CVLError;", "seen1", "", "rhsKind", "Lspec/cvlast/typechecker/AssignFromVoid$RhsKind;", "rhs", "", "location", "Lutils/Range;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/typechecker/AssignFromVoid$RhsKind;Ljava/lang/String;Lutils/Range;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/typechecker/AssignFromVoid$RhsKind;Ljava/lang/String;Lutils/Range;)V", "getLocation", "()Lutils/Range;", "message", "getMessage", "()Ljava/lang/String;", "getRhs", "getRhsKind", "()Lspec/cvlast/typechecker/AssignFromVoid$RhsKind;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "RhsKind", "Shared"})
public final class AssignFromVoid
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RhsKind rhsKind;
    @NotNull
    private final String rhs;
    @NotNull
    private final Range location;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public AssignFromVoid(@NotNull RhsKind rhsKind, @NotNull String rhs, @NotNull Range location) {
        Intrinsics.checkNotNullParameter((Object)rhsKind, "rhsKind");
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        Intrinsics.checkNotNullParameter(location, "location");
        super(null);
        this.rhsKind = rhsKind;
        this.rhs = rhs;
        this.location = location;
    }

    @NotNull
    public final RhsKind getRhsKind() {
        return this.rhsKind;
    }

    @NotNull
    public final String getRhs() {
        return this.rhs;
    }

    @Override
    @NotNull
    public Range getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.rhsKind.getDescription() + " `" + this.rhs + "` has type `void`. It cannot be assigned to a variable.";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(AssignFromVoid self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.rhsKind);
        output.encodeStringElement(serialDesc, 1, self.rhs);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.getLocation());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ AssignFromVoid(int seen1, RhsKind rhsKind, String rhs, Range location, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 7, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.rhsKind = rhsKind;
        this.rhs = rhs;
        this.location = location;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{EnumsKt.createSimpleEnumSerializer((String)"spec.cvlast.typechecker.AssignFromVoid.RhsKind", (Enum[])RhsKind.values()), null, Range.Companion.serializer()};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/AssignFromVoid$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/AssignFromVoid;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AssignFromVoid> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lspec/cvlast/typechecker/AssignFromVoid$RhsKind;", "", "description", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "CVL_FUNC", "EVM_FUNC", "ADDRESS_FUNC", "Shared"})
    public static final class RhsKind
    extends Enum<RhsKind> {
        @NotNull
        private final String description;
        public static final /* enum */ RhsKind CVL_FUNC = new RhsKind("CVL function");
        public static final /* enum */ RhsKind EVM_FUNC = new RhsKind("EVM function");
        public static final /* enum */ RhsKind ADDRESS_FUNC = new RhsKind("Address function");
        private static final /* synthetic */ RhsKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RhsKind(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static RhsKind[] values() {
            return (RhsKind[])$VALUES.clone();
        }

        public static RhsKind valueOf(String value2) {
            return Enum.valueOf(RhsKind.class, value2);
        }

        @NotNull
        public static EnumEntries<RhsKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rhsKindArray = new RhsKind[]{RhsKind.CVL_FUNC, RhsKind.EVM_FUNC, RhsKind.ADDRESS_FUNC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

