/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.FieldSelectOnNonStruct$;
import utils.Range;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="Cannot use `var.fieldname` if `var` is not a struct type")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        rule r {\n            calldataarg args;\n            assert #args.non_existent_field#;\n        }\n        ", exampleMessage="Expression `args` is not a struct but a `calldataarg` type. Cannot use `.non_existent_field` on it."), @CVLErrorExample(exampleCVLWithRange="\n        methods { function externalFunction() external envfree; }\n        rule r(method f) {\n            assert f.selector == #externalFunction().selector#;\n        }\n        ", exampleMessage="Expression `PrimaryContract.externalFunction()` is not a struct but a `void` type. Cannot use `.selector` on it. Did you forget to use `sig:` for a method selector?")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u00c1\u0001\u00a2\u0006\u0002\b\u001cR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lspec/cvlast/typechecker/FieldSelectOnNonStruct;", "Lspec/cvlast/typechecker/CVLError;", "exp", "Lspec/cvlast/CVLExp$FieldSelectExp;", "ty", "Lspec/cvlast/CVLType$PureCVLType;", "(Lspec/cvlast/CVLExp$FieldSelectExp;Lspec/cvlast/CVLType$PureCVLType;)V", "seen1", "", "location", "Lutils/Range;", "message", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILutils/Range;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lutils/Range;Ljava/lang/String;)V", "getLocation", "()Lutils/Range;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class FieldSelectOnNonStruct
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private FieldSelectOnNonStruct(Range location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public Range getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public FieldSelectOnNonStruct(@NotNull CVLExp.FieldSelectExp exp2, @NotNull CVLType.PureCVLType ty) {
        Intrinsics.checkNotNullParameter(exp2, "exp");
        Intrinsics.checkNotNullParameter(ty, "ty");
        this(exp2.getRangeOrEmpty(), "Expression `" + exp2.getStructExp() + "` is not a struct but a `" + ty + "` type. Cannot use `." + exp2.getFieldName() + "` on it." + (Intrinsics.areEqual(exp2.getFieldName(), "selector") ? " Did you forget to use `sig:` for a method selector?" : ""));
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(FieldSelectOnNonStruct self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ FieldSelectOnNonStruct(int seen1, Range location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{Range.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/FieldSelectOnNonStruct$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/FieldSelectOnNonStruct;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<FieldSelectOnNonStruct> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

