/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.WithWrongNumberArguments$;
import utils.Range;

@Serializable
@CVLErrorType(category=CVLErrorCategory.SYNTAX, description="\n        A `with` must have the form `with(env <variable-name>)`.  See {ref}`with-env` or {ref}`preserved` for more information.\n        ")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        methods {\n            function externalFunction() external #with()# => summary(e1, e2);\n        }\n        ", exampleMessage="`with` clause has 0 arguments; `with` clauses must define a single argument of type `env` (e.g. `with(env e)`)"), @CVLErrorExample(exampleCVLWithRange="methods { function externalFunction() external #with(env e1, env e2)# => summary(e1, e2); }")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB5\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u00c1\u0001\u00a2\u0006\u0002\b\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lspec/cvlast/typechecker/WithWrongNumberArguments;", "Lspec/cvlast/typechecker/CVLError;", "seen1", "", "location", "Lutils/Range;", "number", "message", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILutils/Range;ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lutils/Range;I)V", "getLocation", "()Lutils/Range;", "getMessage", "()Ljava/lang/String;", "getNumber", "()I", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class WithWrongNumberArguments
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range location;
    private final int number;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public WithWrongNumberArguments(@NotNull Range location, int number) {
        Intrinsics.checkNotNullParameter(location, "location");
        super(null);
        this.location = location;
        this.number = number;
        this.message = "`with` clause has " + this.number + " arguments; `with` clauses must define a single argument of type `env` (e.g. `with(env e)`)";
    }

    @Override
    @NotNull
    public Range getLocation() {
        return this.location;
    }

    public final int getNumber() {
        return this.number;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(WithWrongNumberArguments self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeIntElement(serialDesc, 1, self.number);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.getMessage(), "`with` clause has " + self.number + " arguments; `with` clauses must define a single argument of type `env` (e.g. `with(env e)`)")) {
            output.encodeStringElement(serialDesc, 2, self.getMessage());
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ WithWrongNumberArguments(int seen1, Range location, int number, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.number = number;
        this.message = (seen1 & 4) == 0 ? "`with` clause has " + this.number + " arguments; `with` clauses must define a single argument of type `env` (e.g. `with(env e)`)" : message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{Range.Companion.serializer(), null, null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/WithWrongNumberArguments$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/WithWrongNumberArguments;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<WithWrongNumberArguments> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

