/*
 * Decompiled with CFR 0.152.
 */
package spec.genericrulegenerators;

import bridge.ContractInstanceInSDC;
import config.Config;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLScope;
import spec.cvlast.ContractFunction;
import spec.cvlast.MethodParamFilters;
import spec.cvlast.SpecType;
import spec.cvlast.UseDeclaration;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.FuzzTestBirWithoutFoundryFlag;
import spec.cvlast.typechecker.InvalidMethodParamFiltersOnBuiltinRule;
import spec.genericrulegenerators.BuiltInRuleId;
import spec.genericrulegenerators.DeepSanityGenerator;
import spec.genericrulegenerators.FoundryFuzzTestsGenerator;
import spec.genericrulegenerators.HasDelegateCalls;
import spec.genericrulegenerators.MsgValueInLoopGenerator;
import spec.genericrulegenerators.SanityGenerator;
import spec.genericrulegenerators.TrustedMethods;
import spec.genericrulegenerators.ViewReentrancyGenerator;
import spec.rules.ICVLRule;
import utils.CollectingResult;
import utils.HasKSerializable;
import utils.Range;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H$JD\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002 !\u00a8\u0006\""}, d2={"Lspec/genericrulegenerators/BuiltInRuleGenerator;", "", "()V", "birType", "Lspec/cvlast/SpecType$Single$BuiltIn;", "getBirType", "()Lspec/cvlast/SpecType$Single$BuiltIn;", "eId", "Lspec/genericrulegenerators/BuiltInRuleId;", "getEId", "()Lspec/genericrulegenerators/BuiltInRuleId;", "doGenerate", "Lutils/CollectingResult;", "Lspec/rules/ICVLRule;", "Lspec/cvlast/typechecker/CVLError;", "scope", "Lspec/cvlast/CVLScope;", "range", "Lutils/Range;", "mainContract", "", "functionsFromSpecFileAndContracts", "", "Lbridge/ContractInstanceInSDC;", "", "Lspec/cvlast/ContractFunction;", "generate", "getRange", "ast", "Lspec/cvlast/CVLAst;", "BirsMetadata", "Companion", "Lspec/genericrulegenerators/FoundryFuzzTestsGenerator;", "Lspec/genericrulegenerators/InstrumentingBuiltInRuleGenerator;", "Shared"})
@SourceDebugExtension(value={"SMAP\nBuiltInRuleGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInRuleGenerator.kt\nspec/genericrulegenerators/BuiltInRuleGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class BuiltInRuleGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private BuiltInRuleGenerator() {
    }

    @NotNull
    public abstract BuiltInRuleId getEId();

    @NotNull
    public abstract SpecType.Single.BuiltIn getBirType();

    @NotNull
    public final CollectingResult<ICVLRule, CVLError> generate(@NotNull CVLScope scope, @NotNull Range range, @NotNull String mainContract, @NotNull Map<ContractInstanceInSDC, ? extends List<ContractFunction>> functionsFromSpecFileAndContracts) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(mainContract, "mainContract");
        Intrinsics.checkNotNullParameter(functionsFromSpecFileAndContracts, "functionsFromSpecFileAndContracts");
        return CollectingResult.Companion.map(this.doGenerate(scope, range, mainContract, functionsFromSpecFileAndContracts), (Function1)new Function1<ICVLRule, ICVLRule>(this){
            final /* synthetic */ BuiltInRuleGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ICVLRule invoke(@NotNull ICVLRule it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                boolean bl = Intrinsics.areEqual(it2.getDeclarationId(), this.this$0.getEId().name());
                BuiltInRuleGenerator builtInRuleGenerator = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Could not generate builtin rule " + builtInRuleGenerator.getEId() + " - got instead rule " + it2.getDeclarationId();
                    throw new IllegalStateException(string.toString());
                }
                return it2;
            }
        });
    }

    @NotNull
    public final Range getRange(@NotNull CVLAst ast2) {
        HasKSerializable hasKSerializable;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(ast2, "ast");
            Iterable iterable = ast2.getUseDeclarations().getBuiltInRulesInUse();
            for (Object t : iterable) {
                UseDeclaration.BuiltInRule it2 = (UseDeclaration.BuiltInRule)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it2.getId(), this.getEId().name())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((hasKSerializable = (UseDeclaration.BuiltInRule)v0) == null || (hasKSerializable = hasKSerializable.getRange()) == null) {
            hasKSerializable = new Range.Empty(null, 1, null);
        }
        return hasKSerializable;
    }

    @NotNull
    protected abstract CollectingResult<ICVLRule, CVLError> doGenerate(@NotNull CVLScope var1, @NotNull Range var2, @NotNull String var3, @NotNull Map<ContractInstanceInSDC, ? extends List<ContractFunction>> var4);

    public /* synthetic */ BuiltInRuleGenerator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lspec/genericrulegenerators/BuiltInRuleGenerator$BirsMetadata;", "", "birUseDecl", "Lspec/cvlast/UseDeclaration$BuiltInRule;", "birId", "Lspec/genericrulegenerators/BuiltInRuleId;", "methodParamFilters", "Lspec/cvlast/MethodParamFilters;", "(Lspec/cvlast/UseDeclaration$BuiltInRule;Lspec/genericrulegenerators/BuiltInRuleId;Lspec/cvlast/MethodParamFilters;)V", "getBirId", "()Lspec/genericrulegenerators/BuiltInRuleId;", "getBirUseDecl", "()Lspec/cvlast/UseDeclaration$BuiltInRule;", "getMethodParamFilters", "()Lspec/cvlast/MethodParamFilters;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Shared"})
    public static final class BirsMetadata {
        @NotNull
        private final UseDeclaration.BuiltInRule birUseDecl;
        @NotNull
        private final BuiltInRuleId birId;
        @NotNull
        private final MethodParamFilters methodParamFilters;

        public BirsMetadata(@NotNull UseDeclaration.BuiltInRule birUseDecl, @NotNull BuiltInRuleId birId, @NotNull MethodParamFilters methodParamFilters2) {
            Intrinsics.checkNotNullParameter(birUseDecl, "birUseDecl");
            Intrinsics.checkNotNullParameter((Object)birId, "birId");
            Intrinsics.checkNotNullParameter(methodParamFilters2, "methodParamFilters");
            this.birUseDecl = birUseDecl;
            this.birId = birId;
            this.methodParamFilters = methodParamFilters2;
        }

        @NotNull
        public final UseDeclaration.BuiltInRule getBirUseDecl() {
            return this.birUseDecl;
        }

        @NotNull
        public final BuiltInRuleId getBirId() {
            return this.birId;
        }

        @NotNull
        public final MethodParamFilters getMethodParamFilters() {
            return this.methodParamFilters;
        }

        @NotNull
        public final UseDeclaration.BuiltInRule component1() {
            return this.birUseDecl;
        }

        @NotNull
        public final BuiltInRuleId component2() {
            return this.birId;
        }

        @NotNull
        public final MethodParamFilters component3() {
            return this.methodParamFilters;
        }

        @NotNull
        public final BirsMetadata copy(@NotNull UseDeclaration.BuiltInRule birUseDecl, @NotNull BuiltInRuleId birId, @NotNull MethodParamFilters methodParamFilters2) {
            Intrinsics.checkNotNullParameter(birUseDecl, "birUseDecl");
            Intrinsics.checkNotNullParameter((Object)birId, "birId");
            Intrinsics.checkNotNullParameter(methodParamFilters2, "methodParamFilters");
            return new BirsMetadata(birUseDecl, birId, methodParamFilters2);
        }

        public static /* synthetic */ BirsMetadata copy$default(BirsMetadata birsMetadata, UseDeclaration.BuiltInRule builtInRule, BuiltInRuleId builtInRuleId, MethodParamFilters methodParamFilters2, int n, Object object) {
            if ((n & 1) != 0) {
                builtInRule = birsMetadata.birUseDecl;
            }
            if ((n & 2) != 0) {
                builtInRuleId = birsMetadata.birId;
            }
            if ((n & 4) != 0) {
                methodParamFilters2 = birsMetadata.methodParamFilters;
            }
            return birsMetadata.copy(builtInRule, builtInRuleId, methodParamFilters2);
        }

        @NotNull
        public String toString() {
            return "BirsMetadata(birUseDecl=" + this.birUseDecl + ", birId=" + this.birId + ", methodParamFilters=" + this.methodParamFilters + ")";
        }

        public int hashCode() {
            int result2 = this.birUseDecl.hashCode();
            result2 = result2 * 31 + this.birId.hashCode();
            result2 = result2 * 31 + this.methodParamFilters.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BirsMetadata)) {
                return false;
            }
            BirsMetadata birsMetadata = (BirsMetadata)other;
            if (!Intrinsics.areEqual(this.birUseDecl, birsMetadata.birUseDecl)) {
                return false;
            }
            if (this.birId != birsMetadata.birId) {
                return false;
            }
            return Intrinsics.areEqual(this.methodParamFilters, birsMetadata.methodParamFilters);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lspec/genericrulegenerators/BuiltInRuleGenerator$Companion;", "", "()V", "fromBirMetadata", "Lutils/CollectingResult;", "Lspec/genericrulegenerators/BuiltInRuleGenerator;", "Lspec/cvlast/typechecker/CVLError;", "birMetadata", "Lspec/genericrulegenerators/BuiltInRuleGenerator$BirsMetadata;", "methodParamFilters", "Lspec/cvlast/MethodParamFilters;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CollectingResult<BuiltInRuleGenerator, CVLError> fromBirMetadata(@NotNull BirsMetadata birMetadata, @NotNull MethodParamFilters methodParamFilters2) {
            CollectingResult collectingResult;
            Intrinsics.checkNotNullParameter(birMetadata, "birMetadata");
            Intrinsics.checkNotNullParameter(methodParamFilters2, "methodParamFilters");
            BuiltInRuleId birId = birMetadata.getBirId();
            switch (WhenMappings.$EnumSwitchMapping$0[birId.ordinal()]) {
                case 1: {
                    collectingResult = CollectingResult.Companion.lift(new HasDelegateCalls(methodParamFilters2));
                    break;
                }
                case 2: {
                    collectingResult = CollectingResult.Companion.lift(new TrustedMethods(methodParamFilters2));
                    break;
                }
                case 3: {
                    if (!methodParamFilters2.isEmpty()) {
                        collectingResult = CollectingResult.Companion.asError(new InvalidMethodParamFiltersOnBuiltinRule(birMetadata.getBirUseDecl().getRange(), birId));
                        break;
                    }
                    collectingResult = CollectingResult.Companion.lift(MsgValueInLoopGenerator.INSTANCE);
                    break;
                }
                case 4: {
                    if (!methodParamFilters2.isEmpty()) {
                        collectingResult = CollectingResult.Companion.asError(new InvalidMethodParamFiltersOnBuiltinRule(birMetadata.getBirUseDecl().getRange(), birId));
                        break;
                    }
                    collectingResult = CollectingResult.Companion.lift(ViewReentrancyGenerator.INSTANCE);
                    break;
                }
                case 5: {
                    collectingResult = CollectingResult.Companion.lift(new DeepSanityGenerator(methodParamFilters2));
                    break;
                }
                case 6: {
                    collectingResult = CollectingResult.Companion.lift(new SanityGenerator(methodParamFilters2));
                    break;
                }
                case 7: 
                case 8: {
                    if (!((Boolean)Config.INSTANCE.getFoundry().get()).booleanValue()) {
                        collectingResult = CollectingResult.Companion.asError(new FuzzTestBirWithoutFoundryFlag(birMetadata.getBirUseDecl().getRange(), birId));
                        break;
                    }
                    if (!methodParamFilters2.isEmpty()) {
                        collectingResult = CollectingResult.Companion.asError(new InvalidMethodParamFiltersOnBuiltinRule(birMetadata.getBirUseDecl().getRange(), birId));
                        break;
                    }
                    collectingResult = CollectingResult.Companion.lift(new FoundryFuzzTestsGenerator(birId == BuiltInRuleId.verifyFoundryFuzzTests));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return collectingResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BuiltInRuleId.values().length];
                try {
                    nArray[BuiltInRuleId.hasDelegateCalls.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.trustedMethods.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.msgValueInLoopRule.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.viewReentrancy.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.deepSanity.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.sanity.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.verifyFoundryFuzzTests.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BuiltInRuleId.verifyFoundryFuzzTestsNoRevert.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

