/*
 * Decompiled with CFR 0.152.
 */
package utils;

import evm.EVMConstsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.ExtStdlibKt;
import utils.ModZm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u001c"}, d2={"Lutils/ConcreteModZm;", "Lutils/ModZm;", "bitwidth", "", "(I)V", "getBitwidth", "()I", "maxSigned", "Ljava/math/BigInteger;", "getMaxSigned", "()Ljava/math/BigInteger;", "maxUnsigned", "getMaxUnsigned", "minSigned2s", "getMinSigned2s", "minSignedMath", "getMinSignedMath", "modulus", "getModulus", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "GeneralUtils"})
public final class ConcreteModZm
implements ModZm {
    private final int bitwidth;
    @NotNull
    private final BigInteger modulus;
    @NotNull
    private final BigInteger maxUnsigned;
    @NotNull
    private final BigInteger maxSigned;
    @NotNull
    private final BigInteger minSignedMath;
    @NotNull
    private final BigInteger minSigned2s;

    public ConcreteModZm(int bitwidth) {
        this.bitwidth = bitwidth;
        this.modulus = EVMConstsKt.twoToThe(this.getBitwidth());
        this.maxUnsigned = ExtStdlibKt.minus(this.getModulus(), 1);
        this.maxSigned = ExtStdlibKt.minus(EVMConstsKt.twoToThe(this.getBitwidth() - 1), 1);
        BigInteger bigInteger = EVMConstsKt.twoToThe(this.getBitwidth() - 1).negate();
        Intrinsics.checkNotNullExpressionValue(bigInteger, "negate(...)");
        this.minSignedMath = bigInteger;
        this.minSigned2s = ExtStdlibKt.plus(this.getMaxSigned(), 1);
    }

    @Override
    public int getBitwidth() {
        return this.bitwidth;
    }

    @Override
    @NotNull
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    @NotNull
    public BigInteger getMaxUnsigned() {
        return this.maxUnsigned;
    }

    @Override
    @NotNull
    public BigInteger getMaxSigned() {
        return this.maxSigned;
    }

    @Override
    @NotNull
    public BigInteger getMinSignedMath() {
        return this.minSignedMath;
    }

    @Override
    @NotNull
    public BigInteger getMinSigned2s() {
        return this.minSigned2s;
    }

    @Override
    public <T> T invoke(@NotNull Function1<? super ModZm, ? extends T> f) {
        return ModZm.DefaultImpls.invoke(this, f);
    }

    @Override
    public boolean getInBounds(@NotNull BigInteger $this$inBounds) {
        return ModZm.DefaultImpls.getInBounds(this, $this$inBounds);
    }

    @Override
    public boolean getInSignedBounds(@NotNull BigInteger $this$inSignedBounds) {
        return ModZm.DefaultImpls.getInSignedBounds(this, $this$inSignedBounds);
    }

    @Override
    @NotNull
    public BigInteger checked(@NotNull BigInteger $this$checked) {
        return ModZm.DefaultImpls.checked(this, $this$checked);
    }

    @Override
    public boolean is2sNonNeg(@NotNull BigInteger $this$is2sNonNeg) {
        return ModZm.DefaultImpls.is2sNonNeg(this, $this$is2sNonNeg);
    }

    @Override
    public boolean is2sNeg(@NotNull BigInteger $this$is2sNeg) {
        return ModZm.DefaultImpls.is2sNeg(this, $this$is2sNeg);
    }

    @Override
    @NotNull
    public BigInteger to2s(@NotNull BigInteger $this$to2s) {
        return ModZm.DefaultImpls.to2s((ModZm)this, $this$to2s);
    }

    @Override
    @NotNull
    public BigInteger to2s(int $this$to2s) {
        return ModZm.DefaultImpls.to2s((ModZm)this, $this$to2s);
    }

    @Override
    @NotNull
    public BigInteger to2s(long $this$to2s) {
        return ModZm.DefaultImpls.to2s((ModZm)this, $this$to2s);
    }

    @Override
    @NotNull
    public BigInteger from2s(@NotNull BigInteger $this$from2s) {
        return ModZm.DefaultImpls.from2s((ModZm)this, $this$from2s);
    }

    @Override
    @NotNull
    public BigInteger from2s(int $this$from2s) {
        return ModZm.DefaultImpls.from2s((ModZm)this, $this$from2s);
    }

    @Override
    @NotNull
    public BigInteger from2s(long $this$from2s) {
        return ModZm.DefaultImpls.from2s((ModZm)this, $this$from2s);
    }

    @Override
    @NotNull
    public BigInteger checkAndMod(@NotNull BigInteger a, @NotNull BigInteger b, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> f) {
        return ModZm.DefaultImpls.checkAndMod(this, a, b, f);
    }

    @Override
    public <T> T checkAnd(@NotNull BigInteger a, @NotNull BigInteger b, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends T> f) {
        return ModZm.DefaultImpls.checkAnd(this, a, b, f);
    }

    @Override
    @NotNull
    public BigInteger add(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.add(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sub(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sub(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger mul(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.mul(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger mod(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.mod(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger exp(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.exp(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger signExtendFromBit(@NotNull BigInteger a, int fromBit) {
        return ModZm.DefaultImpls.signExtendFromBit(this, a, fromBit);
    }

    @Override
    @NotNull
    public BigInteger bwNot(@NotNull BigInteger a) {
        return ModZm.DefaultImpls.bwNot(this, a);
    }

    @Override
    @NotNull
    public BigInteger shl(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.shl(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sar(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sar(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger signedPred(@NotNull BigInteger a, @NotNull BigInteger b, @NotNull Function2<? super BigInteger, ? super BigInteger, Boolean> p2) {
        return ModZm.DefaultImpls.signedPred(this, a, b, p2);
    }

    @Override
    @NotNull
    public BigInteger slt(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.slt(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sle(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sle(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sgt(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sgt(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sge(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sge(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger highOnes(int width) {
        return ModZm.DefaultImpls.highOnes(this, width);
    }

    @Override
    @NotNull
    public BigInteger div(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.div(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger sdiv(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.sdiv(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger smod(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.smod(this, a, b);
    }

    @Override
    @NotNull
    public BigInteger shr(@NotNull BigInteger a, @NotNull BigInteger b) {
        return ModZm.DefaultImpls.shr(this, a, b);
    }

    public final int component1() {
        return this.bitwidth;
    }

    @NotNull
    public final ConcreteModZm copy(int bitwidth) {
        return new ConcreteModZm(bitwidth);
    }

    public static /* synthetic */ ConcreteModZm copy$default(ConcreteModZm concreteModZm, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = concreteModZm.bitwidth;
        }
        return concreteModZm.copy(n);
    }

    @NotNull
    public String toString() {
        return "ConcreteModZm(bitwidth=" + this.bitwidth + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.bitwidth);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConcreteModZm)) {
            return false;
        }
        ConcreteModZm concreteModZm = (ConcreteModZm)other;
        return this.bitwidth == concreteModZm.bitwidth;
    }
}

