"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Chunk(google.protobuf.message.Message):
    """The Chunk message represents a chunk of data in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    RETRIEVABLE_FIELD_NUMBER: builtins.int
    START_POS_FIELD_NUMBER: builtins.int
    END_POS_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    ORIGINAL_FILE_UID_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """unique identifier of the chunk"""
    retrievable: builtins.bool
    """whether the chunk is retrievable"""
    start_pos: builtins.int
    """start position of the chunk in the source file"""
    end_pos: builtins.int
    """end position of the chunk in the source file"""
    tokens: builtins.int
    """tokens of the chunk"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the chunk"""
    original_file_uid: builtins.str
    """original file unique identifier"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        retrievable: builtins.bool = ...,
        start_pos: builtins.int = ...,
        end_pos: builtins.int = ...,
        tokens: builtins.int = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        original_file_uid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uid", b"chunk_uid", "create_time", b"create_time", "end_pos", b"end_pos", "original_file_uid", b"original_file_uid", "retrievable", b"retrievable", "start_pos", b"start_pos", "tokens", b"tokens"]) -> None: ...

global___Chunk = Chunk

@typing_extensions.final
class ListChunksRequest(google.protobuf.message.Message):
    """The ListChunksRequest message represents a request to list chunks in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    KB_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner id (not uid)"""
    kb_id: builtins.str
    """knowledge base name (not uid)"""
    file_uid: builtins.str
    """unique identifier of the file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        kb_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid", "kb_id", b"kb_id", "namespace_id", b"namespace_id"]) -> None: ...

global___ListChunksRequest = ListChunksRequest

@typing_extensions.final
class ListChunksResponse(google.protobuf.message.Message):
    """The ListChunksResponse message represents a response containing a list of chunks in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Chunk]:
        """repeated chunks"""
    def __init__(
        self,
        *,
        chunks: collections.abc.Iterable[global___Chunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunks", b"chunks"]) -> None: ...

global___ListChunksResponse = ListChunksResponse

@typing_extensions.final
class SourceFile(google.protobuf.message.Message):
    """The SourceFile message represents a source file in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGINAL_FILE_UID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    original_file_uid: builtins.str
    """original file unique identifier"""
    content: builtins.str
    """content"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the source file"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time of the source file"""
    def __init__(
        self,
        *,
        original_file_uid: builtins.str = ...,
        content: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "create_time", b"create_time", "original_file_uid", b"original_file_uid", "update_time", b"update_time"]) -> None: ...

global___SourceFile = SourceFile

@typing_extensions.final
class GetSourceFileRequest(google.protobuf.message.Message):
    """get source file request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    KB_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner id"""
    kb_id: builtins.str
    """knowledge base name"""
    file_uid: builtins.str
    """unique identifier of the original uploaded file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        kb_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid", "kb_id", b"kb_id", "namespace_id", b"namespace_id"]) -> None: ...

global___GetSourceFileRequest = GetSourceFileRequest

@typing_extensions.final
class GetSourceFileResponse(google.protobuf.message.Message):
    """get source file response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FILE_FIELD_NUMBER: builtins.int
    @property
    def source_file(self) -> global___SourceFile:
        """source file(either orignal file or converted file)"""
    def __init__(
        self,
        *,
        source_file: global___SourceFile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["source_file", b"source_file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["source_file", b"source_file"]) -> None: ...

global___GetSourceFileResponse = GetSourceFileResponse

@typing_extensions.final
class UpdateChunkRequest(google.protobuf.message.Message):
    """Create chunk response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    RETRIEVABLE_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """chunk uid"""
    retrievable: builtins.bool
    """whether the chunk is retrievable"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        retrievable: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uid", b"chunk_uid", "retrievable", b"retrievable"]) -> None: ...

global___UpdateChunkRequest = UpdateChunkRequest

@typing_extensions.final
class UpdateChunkResponse(google.protobuf.message.Message):
    """Updae chunk response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_FIELD_NUMBER: builtins.int
    @property
    def chunk(self) -> global___Chunk:
        """chunk"""
    def __init__(
        self,
        *,
        chunk: global___Chunk | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chunk", b"chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk", b"chunk"]) -> None: ...

global___UpdateChunkResponse = UpdateChunkResponse

@typing_extensions.final
class SimilarityChunksSearchRequest(google.protobuf.message.Message):
    """Similar chunnk search request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    KB_ID_FIELD_NUMBER: builtins.int
    TEXT_PROMPT_FIELD_NUMBER: builtins.int
    TOPK_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner id"""
    kb_id: builtins.str
    """knowledge base name"""
    text_prompt: builtins.str
    """text prompt"""
    topk: builtins.int
    """topk"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        kb_id: builtins.str = ...,
        text_prompt: builtins.str = ...,
        topk: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["kb_id", b"kb_id", "namespace_id", b"namespace_id", "text_prompt", b"text_prompt", "topk", b"topk"]) -> None: ...

global___SimilarityChunksSearchRequest = SimilarityChunksSearchRequest

@typing_extensions.final
class SimilarityChunksSearchResponse(google.protobuf.message.Message):
    """Similar chunnk search response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMILAR_CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def similar_chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SimilarityChunk]:
        """chunks"""
    def __init__(
        self,
        *,
        similar_chunks: collections.abc.Iterable[global___SimilarityChunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["similar_chunks", b"similar_chunks"]) -> None: ...

global___SimilarityChunksSearchResponse = SimilarityChunksSearchResponse

@typing_extensions.final
class SimilarityChunk(google.protobuf.message.Message):
    """similarity chunks"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    SIMILARITY_SCORE_FIELD_NUMBER: builtins.int
    TEXT_CONTENT_FIELD_NUMBER: builtins.int
    SOURCE_FILE_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """chunk uid"""
    similarity_score: builtins.float
    """similarity score"""
    text_content: builtins.str
    """chunk"""
    source_file: builtins.str
    """source file"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        similarity_score: builtins.float = ...,
        text_content: builtins.str = ...,
        source_file: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uid", b"chunk_uid", "similarity_score", b"similarity_score", "source_file", b"source_file", "text_content", b"text_content"]) -> None: ...

global___SimilarityChunk = SimilarityChunk
