#
# Utility functions for the Cultural Heritage API
#
# This module provides utility functions commonly used in the Cultural Heritage API.
#
# Developed with the enthusiasm of Jay Suh (jay@joseon.space) from the non-profit organization Joseon Space
# (https://joseon.space). This module aims to facilitate efficient and accurate access  to Korea's rich cultural
# heritage data for developers and researchers globally.
#

# ------------------------------------------------------------
# Static variables
# ------------------------------------------------------------
#

event_type = {
    '01': '문화재야행',
    '02': '생생문화재',
    '03': '전통산사문화재',
    '04': '살아숨쉬는향교서원',
    '07': '국립무형유산원',
    '08': '한국문화재재단',
    '09': '고택종갓집',
    '10': '세계유산',
    '06': '기타행사'
}
province_code = {
    '11': '서울',
    '21': '부산',
    '22': '대구',
    '23': '인천',
    '24': '광주',
    '25': '대전',
    '26': '울산',
    '45': '세종',
    '31': '경기',
    '32': '강원',
    '33': '충북',
    '34': '충남',
    '35': '전북',
    '36': '전남',
    '37': '경북',
    '38': '경남',
    '50': '제주',
    'ZZ': '전국일원'
}
seoul_district = {
    '11': '종로구',
    '12': '중구',
    '13': '용산구',
    '14': '성동구',
    '15': '동대문구',
    '16': '성북구',
    '17': '도봉구',
    '18': '은평구',
    '19': '서대문구',
    '20': '마포구',
    '21': '강서구',
    '22': '구로구',
    '23': '영등포구',
    '24': '동작구',
    '25': '관악구',
    '26': '강남구',
    '27': '강동구',
    '28': '송파구',
    '29': '중랑구',
    '30': '노원구',
    '31': '서초구',
    '32': '양천구',
    '33': '광진구',
    '34': '강북구',
    '35': '금천구',
    '99': '한강일원',
    'ZZ': '서울전역'
}
busan_district = {
    '11': '중구',
    '12': '서구',
    '13': '동구',
    '14': '영도구',
    '15': '부산진구',
    '16': '동래구',
    '17': '남구',
    '18': '북구',
    '19': '해운대구',
    '20': '사하구',
    '21': '금정구',
    '22': '강서구',
    '23': '연제구',
    '24': '수영구',
    '25': '사상구',
    '26': '기장군',
    'ZZ': '부산전역'
}
daegu_district = {
    '11': '중구',
    '12': '동구',
    '13': '서구',
    '14': '남구',
    '15': '북구',
    '16': '수성구',
    '17': '달서구',
    '18': '달성군',
    'ZZ': '대구전역'
}
incheon_district = {
    '11': '중구',
    '12': '동구',
    '20': '미추홀구',
    '15': '서구',
    '16': '남동구',
    '17': '연수구',
    '18': '부평구',
    '19': '계양구',
    '30': '강화군',
    '31': '옹진군',
    'ZZ': '인천전역'
}
gwangju_district = {
    '11': '동구',
    '12': '서구',
    '13': '북구',
    '14': '광산구',
    '15': '남구',
    'ZZ': '광주전역'
}
daejeon_district = {
    '11': '동구',
    '12': '중구',
    '13': '서구',
    '14': '유성구',
    '15': '대덕구',
    'ZZ': '대전전역'
}
ulsan_district = {
    '01': '남구',
    '02': '동구',
    '03': '북구',
    '04': '중구',
    '05': '울주군',
    'ZZ': '울산전역'
}
sejong_district = {
    '00': '세종시전역'
}
gyeonggi_district = {
    '11': '수원시',
    '12': '성남시',
    '13': '의정부시',
    '14': '안양시',
    '15': '부천시',
    '16': '광명시',
    '17': '안성시',
    '18': '동두천시',
    '19': '구리시',
    '20': '평택시',
    '21': '과천시',
    '22': '안산시',
    '25': '오산시',
    '26': '의왕시',
    '27': '군포시',
    '28': '시흥시',
    '30': '하남시',
    '31': '양주시',
    '70': '여주시',
    '35': '화성시',
    '37': '파주시',
    '39': '광주시',
    '40': '연천군',
    '41': '포천시',
    '42': '가평군',
    '43': '양평군',
    '44': '이천시',
    '45': '용인시',
    '47': '김포시',
    '50': '고양시',
    '51': '남양주시',
    'ZZ': '경기전역'
}
gangwon_district = {
    '11': '춘천시',
    '12': '원주시',
    '13': '강릉시',
    '14': '동해시',
    '15': '태백시',
    '16': '속초시',
    '17': '삼척시',
    '32': '홍천군',
    '33': '횡성군',
    '35': '영월군',
    '36': '평창군',
    '37': '정선군',
    '38': '철원군',
    '39': '화천군',
    '40': '양구군',
    '41': '인제군',
    '42': '고성군',
    '43': '양양군',
    '44': '명주군',
    'ZZ': '강원전역'
}
chungbuk_district = {
    '20': '청주시',
    '12': '충주시',
    '13': '제천시',
    '32': '보은군',
    '33': '옥천군',
    '34': '영동군',
    '35': '진천군',
    '36': '괴산군',
    '37': '음성군',
    '40': '단양군',
    '42': '증평군',
    'ZZ': '충북전역'
}
chungnam_district = {
    '11': '천안시',
    '12': '공주시',
    '15': '서산시',
    '16': '아산시',
    '17': '보령시',
    '18': '계룡시',
    '31': '금산군',
    '35': '논산시',
    '36': '부여군',
    '37': '서천군',
    '39': '청양군',
    '40': '홍성군',
    '41': '예산군',
    '43': '당진시',
    '46': '태안군',
    'ZZ': '충남전역'
}
jeonbuk_district = {
    '11': '전주시',
    '12': '군산시',
    '15': '남원시',
    '16': '김제시',
    '17': '정읍시',
    '18': '익산시',
    '31': '완주군',
    '32': '진안군',
    '33': '무주군',
    '34': '장수군',
    '35': '임실군',
    '37': '순창군',
    '39': '고창군',
    '40': '부안군',
    'ZZ': '전북전역'
}
jeonnam_district = {
    '11': '목포시',
    '12': '여수시',
    '13': '순천시',
    '14': '나주시',
    '15': '여천시',
    '17': '광양시',
    '32': '담양군',
    '33': '곡성군',
    '34': '구례군',
    '36': '여천군',
    '38': '고흥군',
    '39': '보성군',
    '40': '화순군',
    '41': '장흥군',
    '42': '강진군',
    '43': '해남군',
    '44': '영암군',
    '45': '무안군',
    '47': '함평군',
    '48': '영광군',
    '49': '장성군',
    '50': '완도군',
    '51': '진도군',
    '52': '신안군',
    '53': '승주군',
    'ZZ': '전남전역'
}
gyeongbuk_district = {
    '11': '포항시',
    '12': '경주시',
    '13': '김천시',
    '14': '안동시',
    '15': '구미시',
    '16': '영주시',
    '17': '영천시',
    '18': '상주시',
    '20': '경산시',
    '21': '문경시',
    '33': '의성군',
    '35': '청송군',
    '36': '영양군',
    '37': '영덕군',
    '42': '청도군',
    '43': '고령군',
    '44': '성주군',
    '45': '칠곡군',
    '50': '예천군',
    '52': '봉화군',
    '53': '울진군',
    '54': '울릉군',
    'ZZ': '경북전역'
}
gyeongnam_district = {
    '13': '진주시',
    '50': '창원시',
    '18': '김해시',
    '22': '밀양시',
    '25': '통영시',
    '26': '거제시',
    '27': '사천시',
    '32': '의령군',
    '33': '함안군',
    '34': '창녕군',
    '36': '양산시',
    '39': '의창군',
    '42': '고성군',
    '44': '남해군',
    '45': '하동군',
    '46': '산청군',
    '47': '함양군',
    '48': '거창군',
    '49': '합천군',
    'ZZ': '경남전역'
}
jeju_district = {
    '01': '제주시',
    '02': '서귀포시',
    'ZZ': '제주전역'
}
