# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class Contributor(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'locale': 'str',
        'name': 'str',
        'role': 'str',
        'role_type': 'str'
    }

    attribute_map = {
        'locale': 'Locale',
        'name': 'Name',
        'role': 'Role',
        'role_type': 'RoleType'
    }

    def __init__(self, locale=None, name=None, role=None, role_type=None):  # noqa: E501
        """Contributor - a model defined in Swagger"""  # noqa: E501

        self._locale = None
        self._name = None
        self._role = None
        self._role_type = None
        self.discriminator = None

        if locale is not None:
            self.locale = locale
        if name is not None:
            self.name = name
        if role is not None:
            self.role = role
        if role_type is not None:
            self.role_type = role_type

    @property
    def locale(self):
        """Gets the locale of this Contributor.  # noqa: E501


        :return: The locale of this Contributor.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this Contributor.


        :param locale: The locale of this Contributor.  # noqa: E501
        :type: str
        """

        self._locale = locale

    @property
    def name(self):
        """Gets the name of this Contributor.  # noqa: E501


        :return: The name of this Contributor.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Contributor.


        :param name: The name of this Contributor.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def role(self):
        """Gets the role of this Contributor.  # noqa: E501


        :return: The role of this Contributor.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this Contributor.


        :param role: The role of this Contributor.  # noqa: E501
        :type: str
        """

        self._role = role

    @property
    def role_type(self):
        """Gets the role_type of this Contributor.  # noqa: E501


        :return: The role_type of this Contributor.  # noqa: E501
        :rtype: str
        """
        return self._role_type

    @role_type.setter
    def role_type(self, role_type):
        """Sets the role_type of this Contributor.


        :param role_type: The role_type of this Contributor.  # noqa: E501
        :type: str
        """

        self._role_type = role_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Contributor, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Contributor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
