# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from .browse_node_info import BrowseNodeInfo  # noqa: F401,E501
from .customer_reviews import CustomerReviews  # noqa: F401,E501
from .images import Images  # noqa: F401,E501
from .item_info import ItemInfo  # noqa: F401,E501
from .offers import Offers  # noqa: F401,E501
from .rental_offers import RentalOffers  # noqa: F401,E501
from .variation_attribute import VariationAttribute  # noqa: F401,E501


class Item(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'asin': 'str',
        'browse_node_info': 'BrowseNodeInfo',
        'customer_reviews': 'CustomerReviews',
        'detail_page_url': 'str',
        'images': 'Images',
        'item_info': 'ItemInfo',
        'offers': 'Offers',
        'parent_asin': 'str',
        'rental_offers': 'RentalOffers',
        'score': 'float',
        'variation_attributes': 'list[VariationAttribute]'
    }

    attribute_map = {
        'asin': 'ASIN',
        'browse_node_info': 'BrowseNodeInfo',
        'customer_reviews': 'CustomerReviews',
        'detail_page_url': 'DetailPageURL',
        'images': 'Images',
        'item_info': 'ItemInfo',
        'offers': 'Offers',
        'parent_asin': 'ParentASIN',
        'rental_offers': 'RentalOffers',
        'score': 'Score',
        'variation_attributes': 'VariationAttributes'
    }

    def __init__(self, asin=None, browse_node_info=None, customer_reviews=None, detail_page_url=None, images=None, item_info=None, offers=None, parent_asin=None, rental_offers=None, score=None, variation_attributes=None):  # noqa: E501
        """Item - a model defined in Swagger"""  # noqa: E501

        self._asin = None
        self._browse_node_info = None
        self._customer_reviews = None
        self._detail_page_url = None
        self._images = None
        self._item_info = None
        self._offers = None
        self._parent_asin = None
        self._rental_offers = None
        self._score = None
        self._variation_attributes = None
        self.discriminator = None

        if asin is not None:
            self.asin = asin
        if browse_node_info is not None:
            self.browse_node_info = browse_node_info
        if customer_reviews is not None:
            self.customer_reviews = customer_reviews
        if detail_page_url is not None:
            self.detail_page_url = detail_page_url
        if images is not None:
            self.images = images
        if item_info is not None:
            self.item_info = item_info
        if offers is not None:
            self.offers = offers
        if parent_asin is not None:
            self.parent_asin = parent_asin
        if rental_offers is not None:
            self.rental_offers = rental_offers
        if score is not None:
            self.score = score
        if variation_attributes is not None:
            self.variation_attributes = variation_attributes

    @property
    def asin(self):
        """Gets the asin of this Item.  # noqa: E501


        :return: The asin of this Item.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this Item.


        :param asin: The asin of this Item.  # noqa: E501
        :type: str
        """

        self._asin = asin

    @property
    def browse_node_info(self):
        """Gets the browse_node_info of this Item.  # noqa: E501


        :return: The browse_node_info of this Item.  # noqa: E501
        :rtype: BrowseNodeInfo
        """
        return self._browse_node_info

    @browse_node_info.setter
    def browse_node_info(self, browse_node_info):
        """Sets the browse_node_info of this Item.


        :param browse_node_info: The browse_node_info of this Item.  # noqa: E501
        :type: BrowseNodeInfo
        """

        self._browse_node_info = browse_node_info

    @property
    def customer_reviews(self):
        """Gets the customer_reviews of this Item.  # noqa: E501


        :return: The customer_reviews of this Item.  # noqa: E501
        :rtype: CustomerReviews
        """
        return self._customer_reviews

    @customer_reviews.setter
    def customer_reviews(self, customer_reviews):
        """Sets the customer_reviews of this Item.


        :param customer_reviews: The customer_reviews of this Item.  # noqa: E501
        :type: CustomerReviews
        """

        self._customer_reviews = customer_reviews

    @property
    def detail_page_url(self):
        """Gets the detail_page_url of this Item.  # noqa: E501


        :return: The detail_page_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._detail_page_url

    @detail_page_url.setter
    def detail_page_url(self, detail_page_url):
        """Sets the detail_page_url of this Item.


        :param detail_page_url: The detail_page_url of this Item.  # noqa: E501
        :type: str
        """

        self._detail_page_url = detail_page_url

    @property
    def images(self):
        """Gets the images of this Item.  # noqa: E501


        :return: The images of this Item.  # noqa: E501
        :rtype: Images
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this Item.


        :param images: The images of this Item.  # noqa: E501
        :type: Images
        """

        self._images = images

    @property
    def item_info(self):
        """Gets the item_info of this Item.  # noqa: E501


        :return: The item_info of this Item.  # noqa: E501
        :rtype: ItemInfo
        """
        return self._item_info

    @item_info.setter
    def item_info(self, item_info):
        """Sets the item_info of this Item.


        :param item_info: The item_info of this Item.  # noqa: E501
        :type: ItemInfo
        """

        self._item_info = item_info

    @property
    def offers(self):
        """Gets the offers of this Item.  # noqa: E501


        :return: The offers of this Item.  # noqa: E501
        :rtype: Offers
        """
        return self._offers

    @offers.setter
    def offers(self, offers):
        """Sets the offers of this Item.


        :param offers: The offers of this Item.  # noqa: E501
        :type: Offers
        """

        self._offers = offers

    @property
    def parent_asin(self):
        """Gets the parent_asin of this Item.  # noqa: E501


        :return: The parent_asin of this Item.  # noqa: E501
        :rtype: str
        """
        return self._parent_asin

    @parent_asin.setter
    def parent_asin(self, parent_asin):
        """Sets the parent_asin of this Item.


        :param parent_asin: The parent_asin of this Item.  # noqa: E501
        :type: str
        """

        self._parent_asin = parent_asin

    @property
    def rental_offers(self):
        """Gets the rental_offers of this Item.  # noqa: E501


        :return: The rental_offers of this Item.  # noqa: E501
        :rtype: RentalOffers
        """
        return self._rental_offers

    @rental_offers.setter
    def rental_offers(self, rental_offers):
        """Sets the rental_offers of this Item.


        :param rental_offers: The rental_offers of this Item.  # noqa: E501
        :type: RentalOffers
        """

        self._rental_offers = rental_offers

    @property
    def score(self):
        """Gets the score of this Item.  # noqa: E501


        :return: The score of this Item.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this Item.


        :param score: The score of this Item.  # noqa: E501
        :type: float
        """

        self._score = score

    @property
    def variation_attributes(self):
        """Gets the variation_attributes of this Item.  # noqa: E501


        :return: The variation_attributes of this Item.  # noqa: E501
        :rtype: list[VariationAttribute]
        """
        return self._variation_attributes

    @variation_attributes.setter
    def variation_attributes(self, variation_attributes):
        """Sets the variation_attributes of this Item.


        :param variation_attributes: The variation_attributes of this Item.  # noqa: E501
        :type: list[VariationAttribute]
        """

        self._variation_attributes = variation_attributes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Item, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Item):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
