# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class VariationDimension(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'display_name': 'str',
        'locale': 'str',
        'name': 'str',
        'values': 'list[str]'
    }

    attribute_map = {
        'display_name': 'DisplayName',
        'locale': 'Locale',
        'name': 'Name',
        'values': 'Values'
    }

    def __init__(self, display_name=None, locale=None, name=None, values=None):  # noqa: E501
        """VariationDimension - a model defined in Swagger"""  # noqa: E501

        self._display_name = None
        self._locale = None
        self._name = None
        self._values = None
        self.discriminator = None

        if display_name is not None:
            self.display_name = display_name
        if locale is not None:
            self.locale = locale
        if name is not None:
            self.name = name
        if values is not None:
            self.values = values

    @property
    def display_name(self):
        """Gets the display_name of this VariationDimension.  # noqa: E501


        :return: The display_name of this VariationDimension.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this VariationDimension.


        :param display_name: The display_name of this VariationDimension.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def locale(self):
        """Gets the locale of this VariationDimension.  # noqa: E501


        :return: The locale of this VariationDimension.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this VariationDimension.


        :param locale: The locale of this VariationDimension.  # noqa: E501
        :type: str
        """

        self._locale = locale

    @property
    def name(self):
        """Gets the name of this VariationDimension.  # noqa: E501


        :return: The name of this VariationDimension.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VariationDimension.


        :param name: The name of this VariationDimension.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def values(self):
        """Gets the values of this VariationDimension.  # noqa: E501


        :return: The values of this VariationDimension.  # noqa: E501
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """Sets the values of this VariationDimension.


        :param values: The values of this VariationDimension.  # noqa: E501
        :type: list[str]
        """

        self._values = values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VariationDimension, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VariationDimension):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
