"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuardDutyConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const gd = require("aws-cdk-lib/aws-guardduty");
const constructs_1 = require("constructs");
class GuardDutyConstruct extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const enableGuardDuty = props?.enableGuardDuty ?? true;
        const kubernetesAuditLogs = props?.kubernetesAuditLogs ?? true;
        const malwareProtection = props?.malwareProtection ?? true;
        const s3Logs = props?.s3Logs ?? true;
        // const runtimeMonitoring: boolean = props?.runtimeMonitoring ?? true;
        const guardDuty = new gd.CfnDetector(this, 'GuardDutyDetector', {
            enable: enableGuardDuty,
            dataSources: {
                kubernetes: {
                    auditLogs: {
                        enable: kubernetesAuditLogs,
                    },
                },
                malwareProtection: {
                    scanEc2InstanceWithFindings: {
                        ebsVolumes: malwareProtection,
                    },
                },
                s3Logs: {
                    enable: s3Logs,
                },
            },
            features: [
                {
                    name: 'RUNTIME_MONITORING',
                    status: 'ENABLED',
                },
            ],
        });
        this.detectorId = guardDuty.attrId;
    }
}
exports.GuardDutyConstruct = GuardDutyConstruct;
_a = JSII_RTTI_SYMBOL_1;
GuardDutyConstruct[_a] = { fqn: "@spensireli/cdk-guardduty.GuardDutyConstruct", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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