# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerRepositoriesResult',
    'AwaitableGetContainerRepositoriesResult',
    'get_container_repositories',
    'get_container_repositories_output',
]

@pulumi.output_type
class GetContainerRepositoriesResult:
    """
    A collection of values returned by getContainerRepositories.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, container_repository_collections=None, display_name=None, filters=None, id=None, is_public=None, repository_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if container_repository_collections and not isinstance(container_repository_collections, list):
            raise TypeError("Expected argument 'container_repository_collections' to be a list")
        pulumi.set(__self__, "container_repository_collections", container_repository_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_public and not isinstance(is_public, bool):
            raise TypeError("Expected argument 'is_public' to be a bool")
        pulumi.set(__self__, "is_public", is_public)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment in which the container repository exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="containerRepositoryCollections")
    def container_repository_collections(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionResult']:
        """
        The list of container_repository_collection.
        """
        return pulumi.get(self, "container_repository_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The container repository name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerRepositoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[bool]:
        """
        Whether the repository is public. A public repository allows unauthenticated access.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the container repository.
        """
        return pulumi.get(self, "state")


class AwaitableGetContainerRepositoriesResult(GetContainerRepositoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRepositoriesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            container_repository_collections=self.container_repository_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_public=self.is_public,
            repository_id=self.repository_id,
            state=self.state)


def get_container_repositories(compartment_id: Optional[str] = None,
                               compartment_id_in_subtree: Optional[bool] = None,
                               display_name: Optional[str] = None,
                               filters: Optional[Sequence[Union['GetContainerRepositoriesFilterArgs', 'GetContainerRepositoriesFilterArgsDict']]] = None,
                               is_public: Optional[bool] = None,
                               repository_id: Optional[str] = None,
                               state: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRepositoriesResult:
    """
    This data source provides the list of Container Repositories in Oracle Cloud Infrastructure Artifacts service.

    List container repositories in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_repositories = oci.Artifacts.get_container_repositories(compartment_id=compartment_id,
        compartment_id_in_subtree=container_repository_compartment_id_in_subtree,
        display_name=container_repository_display_name,
        is_public=container_repository_is_public,
        repository_id=test_repository["id"],
        state=container_repository_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are inspected depending on the the setting of `accessLevel`. Default is false. Can only be set to true when calling the API on the tenancy (root compartment).
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param bool is_public: A filter to return resources that match the isPublic value.
    :param str repository_id: A filter to return container images only for the specified container repository OCID.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isPublic'] = is_public
    __args__['repositoryId'] = repository_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Artifacts/getContainerRepositories:getContainerRepositories', __args__, opts=opts, typ=GetContainerRepositoriesResult).value

    return AwaitableGetContainerRepositoriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        container_repository_collections=pulumi.get(__ret__, 'container_repository_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_public=pulumi.get(__ret__, 'is_public'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        state=pulumi.get(__ret__, 'state'))
def get_container_repositories_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetContainerRepositoriesFilterArgs', 'GetContainerRepositoriesFilterArgsDict']]]]] = None,
                                      is_public: Optional[pulumi.Input[Optional[bool]]] = None,
                                      repository_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      state: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContainerRepositoriesResult]:
    """
    This data source provides the list of Container Repositories in Oracle Cloud Infrastructure Artifacts service.

    List container repositories in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_repositories = oci.Artifacts.get_container_repositories(compartment_id=compartment_id,
        compartment_id_in_subtree=container_repository_compartment_id_in_subtree,
        display_name=container_repository_display_name,
        is_public=container_repository_is_public,
        repository_id=test_repository["id"],
        state=container_repository_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are inspected depending on the the setting of `accessLevel`. Default is false. Can only be set to true when calling the API on the tenancy (root compartment).
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param bool is_public: A filter to return resources that match the isPublic value.
    :param str repository_id: A filter to return container images only for the specified container repository OCID.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isPublic'] = is_public
    __args__['repositoryId'] = repository_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Artifacts/getContainerRepositories:getContainerRepositories', __args__, opts=opts, typ=GetContainerRepositoriesResult)
    return __ret__.apply(lambda __response__: GetContainerRepositoriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        container_repository_collections=pulumi.get(__response__, 'container_repository_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_public=pulumi.get(__response__, 'is_public'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        state=pulumi.get(__response__, 'state')))
