# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataAssetsResult',
    'AwaitableGetDataAssetsResult',
    'get_data_assets',
    'get_data_assets_output',
]

@pulumi.output_type
class GetDataAssetsResult:
    """
    A collection of values returned by getDataAssets.
    """
    def __init__(__self__, catalog_id=None, created_by_id=None, data_asset_collections=None, display_name=None, display_name_contains=None, external_key=None, fields=None, filters=None, id=None, state=None, type_key=None):
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if created_by_id and not isinstance(created_by_id, str):
            raise TypeError("Expected argument 'created_by_id' to be a str")
        pulumi.set(__self__, "created_by_id", created_by_id)
        if data_asset_collections and not isinstance(data_asset_collections, list):
            raise TypeError("Expected argument 'data_asset_collections' to be a list")
        pulumi.set(__self__, "data_asset_collections", data_asset_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if external_key and not isinstance(external_key, str):
            raise TypeError("Expected argument 'external_key' to be a str")
        pulumi.set(__self__, "external_key", external_key)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type_key and not isinstance(type_key, str):
            raise TypeError("Expected argument 'type_key' to be a str")
        pulumi.set(__self__, "type_key", type_key)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        The data catalog's OCID.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> Optional[str]:
        """
        OCID of the user who created the data asset.
        """
        return pulumi.get(self, "created_by_id")

    @property
    @pulumi.getter(name="dataAssetCollections")
    def data_asset_collections(self) -> Sequence['outputs.GetDataAssetsDataAssetCollectionResult']:
        """
        The list of data_asset_collection.
        """
        return pulumi.get(self, "data_asset_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> Optional[str]:
        """
        External URI that can be used to reference the object. Format will differ based on the type of object.
        """
        return pulumi.get(self, "external_key")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataAssetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the data asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> Optional[str]:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.
        """
        return pulumi.get(self, "type_key")


class AwaitableGetDataAssetsResult(GetDataAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataAssetsResult(
            catalog_id=self.catalog_id,
            created_by_id=self.created_by_id,
            data_asset_collections=self.data_asset_collections,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            external_key=self.external_key,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            state=self.state,
            type_key=self.type_key)


def get_data_assets(catalog_id: Optional[str] = None,
                    created_by_id: Optional[str] = None,
                    display_name: Optional[str] = None,
                    display_name_contains: Optional[str] = None,
                    external_key: Optional[str] = None,
                    fields: Optional[Sequence[str]] = None,
                    filters: Optional[Sequence[Union['GetDataAssetsFilterArgs', 'GetDataAssetsFilterArgsDict']]] = None,
                    state: Optional[str] = None,
                    type_key: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataAssetsResult:
    """
    This data source provides the list of Data Assets in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of data assets within a data catalog.


    :param str catalog_id: Unique catalog identifier.
    :param str created_by_id: OCID of the user who created the resource.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str display_name_contains: A filter to return only resources that match display name pattern given. The match is not case sensitive. For Example : /folders?displayNameContains=Cu.* The above would match all folders with display name that starts with "Cu" or has the pattern "Cu" anywhere in between.
    :param str external_key: Unique external identifier of this resource in the external source system.
    :param Sequence[str] fields: Specifies the fields to return in a data asset summary response.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    :param str type_key: The key of the object type.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['createdById'] = created_by_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['externalKey'] = external_key
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['typeKey'] = type_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getDataAssets:getDataAssets', __args__, opts=opts, typ=GetDataAssetsResult).value

    return AwaitableGetDataAssetsResult(
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        created_by_id=pulumi.get(__ret__, 'created_by_id'),
        data_asset_collections=pulumi.get(__ret__, 'data_asset_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        external_key=pulumi.get(__ret__, 'external_key'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        type_key=pulumi.get(__ret__, 'type_key'))
def get_data_assets_output(catalog_id: Optional[pulumi.Input[str]] = None,
                           created_by_id: Optional[pulumi.Input[Optional[str]]] = None,
                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                           display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                           external_key: Optional[pulumi.Input[Optional[str]]] = None,
                           fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDataAssetsFilterArgs', 'GetDataAssetsFilterArgsDict']]]]] = None,
                           state: Optional[pulumi.Input[Optional[str]]] = None,
                           type_key: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataAssetsResult]:
    """
    This data source provides the list of Data Assets in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of data assets within a data catalog.


    :param str catalog_id: Unique catalog identifier.
    :param str created_by_id: OCID of the user who created the resource.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str display_name_contains: A filter to return only resources that match display name pattern given. The match is not case sensitive. For Example : /folders?displayNameContains=Cu.* The above would match all folders with display name that starts with "Cu" or has the pattern "Cu" anywhere in between.
    :param str external_key: Unique external identifier of this resource in the external source system.
    :param Sequence[str] fields: Specifies the fields to return in a data asset summary response.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    :param str type_key: The key of the object type.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['createdById'] = created_by_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['externalKey'] = external_key
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['typeKey'] = type_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataCatalog/getDataAssets:getDataAssets', __args__, opts=opts, typ=GetDataAssetsResult)
    return __ret__.apply(lambda __response__: GetDataAssetsResult(
        catalog_id=pulumi.get(__response__, 'catalog_id'),
        created_by_id=pulumi.get(__response__, 'created_by_id'),
        data_asset_collections=pulumi.get(__response__, 'data_asset_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        external_key=pulumi.get(__response__, 'external_key'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        type_key=pulumi.get(__response__, 'type_key')))
