# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDeploymentResult',
    'AwaitableGetDeploymentResult',
    'get_deployment',
    'get_deployment_output',
]

@pulumi.output_type
class GetDeploymentResult:
    """
    A collection of values returned by getDeployment.
    """
    def __init__(__self__, category=None, compartment_id=None, cpu_core_count=None, defined_tags=None, deployment_backup_id=None, deployment_diagnostic_datas=None, deployment_id=None, deployment_type=None, deployment_url=None, description=None, display_name=None, environment_type=None, fqdn=None, freeform_tags=None, id=None, ingress_ips=None, is_auto_scaling_enabled=None, is_healthy=None, is_latest_version=None, is_lock_override=None, is_public=None, is_storage_utilization_limit_exceeded=None, license_model=None, lifecycle_details=None, lifecycle_sub_state=None, load_balancer_id=None, load_balancer_subnet_id=None, locks=None, maintenance_configurations=None, maintenance_windows=None, next_maintenance_action_type=None, next_maintenance_description=None, nsg_ids=None, ogg_datas=None, private_ip_address=None, public_ip_address=None, state=None, storage_utilization_in_bytes=None, subnet_id=None, system_tags=None, time_created=None, time_of_next_maintenance=None, time_ogg_version_supported_until=None, time_updated=None, time_upgrade_required=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_backup_id and not isinstance(deployment_backup_id, str):
            raise TypeError("Expected argument 'deployment_backup_id' to be a str")
        pulumi.set(__self__, "deployment_backup_id", deployment_backup_id)
        if deployment_diagnostic_datas and not isinstance(deployment_diagnostic_datas, list):
            raise TypeError("Expected argument 'deployment_diagnostic_datas' to be a list")
        pulumi.set(__self__, "deployment_diagnostic_datas", deployment_diagnostic_datas)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if deployment_url and not isinstance(deployment_url, str):
            raise TypeError("Expected argument 'deployment_url' to be a str")
        pulumi.set(__self__, "deployment_url", deployment_url)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingress_ips and not isinstance(ingress_ips, list):
            raise TypeError("Expected argument 'ingress_ips' to be a list")
        pulumi.set(__self__, "ingress_ips", ingress_ips)
        if is_auto_scaling_enabled and not isinstance(is_auto_scaling_enabled, bool):
            raise TypeError("Expected argument 'is_auto_scaling_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if is_healthy and not isinstance(is_healthy, bool):
            raise TypeError("Expected argument 'is_healthy' to be a bool")
        pulumi.set(__self__, "is_healthy", is_healthy)
        if is_latest_version and not isinstance(is_latest_version, bool):
            raise TypeError("Expected argument 'is_latest_version' to be a bool")
        pulumi.set(__self__, "is_latest_version", is_latest_version)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if is_public and not isinstance(is_public, bool):
            raise TypeError("Expected argument 'is_public' to be a bool")
        pulumi.set(__self__, "is_public", is_public)
        if is_storage_utilization_limit_exceeded and not isinstance(is_storage_utilization_limit_exceeded, bool):
            raise TypeError("Expected argument 'is_storage_utilization_limit_exceeded' to be a bool")
        pulumi.set(__self__, "is_storage_utilization_limit_exceeded", is_storage_utilization_limit_exceeded)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if load_balancer_subnet_id and not isinstance(load_balancer_subnet_id, str):
            raise TypeError("Expected argument 'load_balancer_subnet_id' to be a str")
        pulumi.set(__self__, "load_balancer_subnet_id", load_balancer_subnet_id)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if maintenance_configurations and not isinstance(maintenance_configurations, list):
            raise TypeError("Expected argument 'maintenance_configurations' to be a list")
        pulumi.set(__self__, "maintenance_configurations", maintenance_configurations)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if next_maintenance_action_type and not isinstance(next_maintenance_action_type, str):
            raise TypeError("Expected argument 'next_maintenance_action_type' to be a str")
        pulumi.set(__self__, "next_maintenance_action_type", next_maintenance_action_type)
        if next_maintenance_description and not isinstance(next_maintenance_description, str):
            raise TypeError("Expected argument 'next_maintenance_description' to be a str")
        pulumi.set(__self__, "next_maintenance_description", next_maintenance_description)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ogg_datas and not isinstance(ogg_datas, list):
            raise TypeError("Expected argument 'ogg_datas' to be a list")
        pulumi.set(__self__, "ogg_datas", ogg_datas)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address and not isinstance(public_ip_address, str):
            raise TypeError("Expected argument 'public_ip_address' to be a str")
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_utilization_in_bytes and not isinstance(storage_utilization_in_bytes, str):
            raise TypeError("Expected argument 'storage_utilization_in_bytes' to be a str")
        pulumi.set(__self__, "storage_utilization_in_bytes", storage_utilization_in_bytes)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_next_maintenance and not isinstance(time_of_next_maintenance, str):
            raise TypeError("Expected argument 'time_of_next_maintenance' to be a str")
        pulumi.set(__self__, "time_of_next_maintenance", time_of_next_maintenance)
        if time_ogg_version_supported_until and not isinstance(time_ogg_version_supported_until, str):
            raise TypeError("Expected argument 'time_ogg_version_supported_until' to be a str")
        pulumi.set(__self__, "time_ogg_version_supported_until", time_ogg_version_supported_until)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if time_upgrade_required and not isinstance(time_upgrade_required, str):
            raise TypeError("Expected argument 'time_upgrade_required' to be a str")
        pulumi.set(__self__, "time_upgrade_required", time_upgrade_required)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The deployment category defines the broad separation of the deployment type into three categories. Currently the separation is 'DATA_REPLICATION', 'STREAM_ANALYTICS' and 'DATA_TRANSFORMS'.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentBackupId")
    def deployment_backup_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "deployment_backup_id")

    @property
    @pulumi.getter(name="deploymentDiagnosticDatas")
    def deployment_diagnostic_datas(self) -> Sequence['outputs.GetDeploymentDeploymentDiagnosticDataResult']:
        """
        Information regarding the deployment diagnostic collection
        """
        return pulumi.get(self, "deployment_diagnostic_datas")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="deploymentUrl")
    def deployment_url(self) -> str:
        """
        The URL of a resource.
        """
        return pulumi.get(self, "deployment_url")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        Specifies whether the deployment is used in a production or development/testing environment.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Sequence['outputs.GetDeploymentIngressIpResult']:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> bool:
        """
        Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> bool:
        """
        True if all of the aggregate resources are working correctly.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isLatestVersion")
    def is_latest_version(self) -> bool:
        """
        Indicates if the resource is the the latest available version.
        """
        return pulumi.get(self, "is_latest_version")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> bool:
        """
        True if this object is publicly available.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="isStorageUtilizationLimitExceeded")
    def is_storage_utilization_limit_exceeded(self) -> bool:
        """
        Deprecated: This field is not updated and will be removed in future versions. If storage utilization exceeds the limit, the respective warning message will appear in deployment messages, which can be accessed through /messages?deploymentId=. Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        """
        return pulumi.get(self, "is_storage_utilization_limit_exceeded")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        """
        The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> str:
        """
        Possible GGS lifecycle sub-states.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the loadbalancer in the customer's subnet. The loadbalancer of the public deployment created in the customer subnet.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="loadBalancerSubnetId")
    def load_balancer_subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        """
        return pulumi.get(self, "load_balancer_subnet_id")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDeploymentLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="maintenanceConfigurations")
    def maintenance_configurations(self) -> Sequence['outputs.GetDeploymentMaintenanceConfigurationResult']:
        """
        Attributes for configuring automatic deployment maintenance.
        """
        return pulumi.get(self, "maintenance_configurations")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDeploymentMaintenanceWindowResult']:
        """
        Defines the maintenance window, when automatic actions can be performed.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="nextMaintenanceActionType")
    def next_maintenance_action_type(self) -> str:
        """
        Type of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_action_type")

    @property
    @pulumi.getter(name="nextMaintenanceDescription")
    def next_maintenance_description(self) -> str:
        """
        Description of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_description")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="oggDatas")
    def ogg_datas(self) -> Sequence['outputs.GetDeploymentOggDataResult']:
        """
        Deployment Data for an OggDeployment
        """
        return pulumi.get(self, "ogg_datas")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        The public IP address representing the access point for the Deployment.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible lifecycle states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageUtilizationInBytes")
    def storage_utilization_in_bytes(self) -> str:
        """
        The amount of storage being utilized (in bytes)
        """
        return pulumi.get(self, "storage_utilization_in_bytes")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextMaintenance")
    def time_of_next_maintenance(self) -> str:
        """
        The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_of_next_maintenance")

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> str:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeUpgradeRequired")
    def time_upgrade_required(self) -> str:
        """
        Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_upgrade_required")


class AwaitableGetDeploymentResult(GetDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentResult(
            category=self.category,
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            defined_tags=self.defined_tags,
            deployment_backup_id=self.deployment_backup_id,
            deployment_diagnostic_datas=self.deployment_diagnostic_datas,
            deployment_id=self.deployment_id,
            deployment_type=self.deployment_type,
            deployment_url=self.deployment_url,
            description=self.description,
            display_name=self.display_name,
            environment_type=self.environment_type,
            fqdn=self.fqdn,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ingress_ips=self.ingress_ips,
            is_auto_scaling_enabled=self.is_auto_scaling_enabled,
            is_healthy=self.is_healthy,
            is_latest_version=self.is_latest_version,
            is_lock_override=self.is_lock_override,
            is_public=self.is_public,
            is_storage_utilization_limit_exceeded=self.is_storage_utilization_limit_exceeded,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            lifecycle_sub_state=self.lifecycle_sub_state,
            load_balancer_id=self.load_balancer_id,
            load_balancer_subnet_id=self.load_balancer_subnet_id,
            locks=self.locks,
            maintenance_configurations=self.maintenance_configurations,
            maintenance_windows=self.maintenance_windows,
            next_maintenance_action_type=self.next_maintenance_action_type,
            next_maintenance_description=self.next_maintenance_description,
            nsg_ids=self.nsg_ids,
            ogg_datas=self.ogg_datas,
            private_ip_address=self.private_ip_address,
            public_ip_address=self.public_ip_address,
            state=self.state,
            storage_utilization_in_bytes=self.storage_utilization_in_bytes,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_of_next_maintenance=self.time_of_next_maintenance,
            time_ogg_version_supported_until=self.time_ogg_version_supported_until,
            time_updated=self.time_updated,
            time_upgrade_required=self.time_upgrade_required)


def get_deployment(deployment_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentResult:
    """
    This data source provides details about a specific Deployment resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment = oci.GoldenGate.get_deployment(deployment_id=test_deployment_oci_golden_gate_deployment["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeployment:getDeployment', __args__, opts=opts, typ=GetDeploymentResult).value

    return AwaitableGetDeploymentResult(
        category=pulumi.get(__ret__, 'category'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deployment_backup_id=pulumi.get(__ret__, 'deployment_backup_id'),
        deployment_diagnostic_datas=pulumi.get(__ret__, 'deployment_diagnostic_datas'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        deployment_url=pulumi.get(__ret__, 'deployment_url'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_type=pulumi.get(__ret__, 'environment_type'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ingress_ips=pulumi.get(__ret__, 'ingress_ips'),
        is_auto_scaling_enabled=pulumi.get(__ret__, 'is_auto_scaling_enabled'),
        is_healthy=pulumi.get(__ret__, 'is_healthy'),
        is_latest_version=pulumi.get(__ret__, 'is_latest_version'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        is_public=pulumi.get(__ret__, 'is_public'),
        is_storage_utilization_limit_exceeded=pulumi.get(__ret__, 'is_storage_utilization_limit_exceeded'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        load_balancer_subnet_id=pulumi.get(__ret__, 'load_balancer_subnet_id'),
        locks=pulumi.get(__ret__, 'locks'),
        maintenance_configurations=pulumi.get(__ret__, 'maintenance_configurations'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        next_maintenance_action_type=pulumi.get(__ret__, 'next_maintenance_action_type'),
        next_maintenance_description=pulumi.get(__ret__, 'next_maintenance_description'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        ogg_datas=pulumi.get(__ret__, 'ogg_datas'),
        private_ip_address=pulumi.get(__ret__, 'private_ip_address'),
        public_ip_address=pulumi.get(__ret__, 'public_ip_address'),
        state=pulumi.get(__ret__, 'state'),
        storage_utilization_in_bytes=pulumi.get(__ret__, 'storage_utilization_in_bytes'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_next_maintenance=pulumi.get(__ret__, 'time_of_next_maintenance'),
        time_ogg_version_supported_until=pulumi.get(__ret__, 'time_ogg_version_supported_until'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        time_upgrade_required=pulumi.get(__ret__, 'time_upgrade_required'))
def get_deployment_output(deployment_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeploymentResult]:
    """
    This data source provides details about a specific Deployment resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment = oci.GoldenGate.get_deployment(deployment_id=test_deployment_oci_golden_gate_deployment["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDeployment:getDeployment', __args__, opts=opts, typ=GetDeploymentResult)
    return __ret__.apply(lambda __response__: GetDeploymentResult(
        category=pulumi.get(__response__, 'category'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        deployment_backup_id=pulumi.get(__response__, 'deployment_backup_id'),
        deployment_diagnostic_datas=pulumi.get(__response__, 'deployment_diagnostic_datas'),
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        deployment_url=pulumi.get(__response__, 'deployment_url'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment_type=pulumi.get(__response__, 'environment_type'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        ingress_ips=pulumi.get(__response__, 'ingress_ips'),
        is_auto_scaling_enabled=pulumi.get(__response__, 'is_auto_scaling_enabled'),
        is_healthy=pulumi.get(__response__, 'is_healthy'),
        is_latest_version=pulumi.get(__response__, 'is_latest_version'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        is_public=pulumi.get(__response__, 'is_public'),
        is_storage_utilization_limit_exceeded=pulumi.get(__response__, 'is_storage_utilization_limit_exceeded'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        load_balancer_subnet_id=pulumi.get(__response__, 'load_balancer_subnet_id'),
        locks=pulumi.get(__response__, 'locks'),
        maintenance_configurations=pulumi.get(__response__, 'maintenance_configurations'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        next_maintenance_action_type=pulumi.get(__response__, 'next_maintenance_action_type'),
        next_maintenance_description=pulumi.get(__response__, 'next_maintenance_description'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        ogg_datas=pulumi.get(__response__, 'ogg_datas'),
        private_ip_address=pulumi.get(__response__, 'private_ip_address'),
        public_ip_address=pulumi.get(__response__, 'public_ip_address'),
        state=pulumi.get(__response__, 'state'),
        storage_utilization_in_bytes=pulumi.get(__response__, 'storage_utilization_in_bytes'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_next_maintenance=pulumi.get(__response__, 'time_of_next_maintenance'),
        time_ogg_version_supported_until=pulumi.get(__response__, 'time_ogg_version_supported_until'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        time_upgrade_required=pulumi.get(__response__, 'time_upgrade_required')))
