# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSslCipherSuitesResult',
    'AwaitableGetSslCipherSuitesResult',
    'get_ssl_cipher_suites',
    'get_ssl_cipher_suites_output',
]

@pulumi.output_type
class GetSslCipherSuitesResult:
    """
    A collection of values returned by getSslCipherSuites.
    """
    def __init__(__self__, filters=None, id=None, load_balancer_id=None, ssl_cipher_suites=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if ssl_cipher_suites and not isinstance(ssl_cipher_suites, list):
            raise TypeError("Expected argument 'ssl_cipher_suites' to be a list")
        pulumi.set(__self__, "ssl_cipher_suites", ssl_cipher_suites)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSslCipherSuitesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="sslCipherSuites")
    def ssl_cipher_suites(self) -> Sequence['outputs.GetSslCipherSuitesSslCipherSuiteResult']:
        """
        The list of ssl_cipher_suites.
        """
        return pulumi.get(self, "ssl_cipher_suites")


class AwaitableGetSslCipherSuitesResult(GetSslCipherSuitesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSslCipherSuitesResult(
            filters=self.filters,
            id=self.id,
            load_balancer_id=self.load_balancer_id,
            ssl_cipher_suites=self.ssl_cipher_suites)


def get_ssl_cipher_suites(filters: Optional[Sequence[Union['GetSslCipherSuitesFilterArgs', 'GetSslCipherSuitesFilterArgsDict']]] = None,
                          load_balancer_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSslCipherSuitesResult:
    """
    This data source provides the list of Ssl Cipher Suites in Oracle Cloud Infrastructure Load Balancer service.

    Lists all SSL cipher suites associated with the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ssl_cipher_suites = oci.LoadBalancer.get_ssl_cipher_suites(load_balancer_id=test_load_balancer["id"])
    ```


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getSslCipherSuites:getSslCipherSuites', __args__, opts=opts, typ=GetSslCipherSuitesResult).value

    return AwaitableGetSslCipherSuitesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        ssl_cipher_suites=pulumi.get(__ret__, 'ssl_cipher_suites'))
def get_ssl_cipher_suites_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSslCipherSuitesFilterArgs', 'GetSslCipherSuitesFilterArgsDict']]]]] = None,
                                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSslCipherSuitesResult]:
    """
    This data source provides the list of Ssl Cipher Suites in Oracle Cloud Infrastructure Load Balancer service.

    Lists all SSL cipher suites associated with the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ssl_cipher_suites = oci.LoadBalancer.get_ssl_cipher_suites(load_balancer_id=test_load_balancer["id"])
    ```


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LoadBalancer/getSslCipherSuites:getSslCipherSuites', __args__, opts=opts, typ=GetSslCipherSuitesResult)
    return __ret__.apply(lambda __response__: GetSslCipherSuitesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        ssl_cipher_suites=pulumi.get(__response__, 'ssl_cipher_suites')))
