# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPublicationPackagesResult',
    'AwaitableGetPublicationPackagesResult',
    'get_publication_packages',
    'get_publication_packages_output',
]

@pulumi.output_type
class GetPublicationPackagesResult:
    """
    A collection of values returned by getPublicationPackages.
    """
    def __init__(__self__, filters=None, id=None, package_type=None, package_version=None, publication_id=None, publication_packages=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if package_version and not isinstance(package_version, str):
            raise TypeError("Expected argument 'package_version' to be a str")
        pulumi.set(__self__, "package_version", package_version)
        if publication_id and not isinstance(publication_id, str):
            raise TypeError("Expected argument 'publication_id' to be a str")
        pulumi.set(__self__, "publication_id", publication_id)
        if publication_packages and not isinstance(publication_packages, list):
            raise TypeError("Expected argument 'publication_packages' to be a list")
        pulumi.set(__self__, "publication_packages", publication_packages)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPublicationPackagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[str]:
        """
        The specified package's type.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[str]:
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter(name="publicationId")
    def publication_id(self) -> str:
        return pulumi.get(self, "publication_id")

    @property
    @pulumi.getter(name="publicationPackages")
    def publication_packages(self) -> Sequence['outputs.GetPublicationPackagesPublicationPackageResult']:
        """
        The list of publication_packages.
        """
        return pulumi.get(self, "publication_packages")


class AwaitableGetPublicationPackagesResult(GetPublicationPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicationPackagesResult(
            filters=self.filters,
            id=self.id,
            package_type=self.package_type,
            package_version=self.package_version,
            publication_id=self.publication_id,
            publication_packages=self.publication_packages)


def get_publication_packages(filters: Optional[Sequence[Union['GetPublicationPackagesFilterArgs', 'GetPublicationPackagesFilterArgsDict']]] = None,
                             package_type: Optional[str] = None,
                             package_version: Optional[str] = None,
                             publication_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicationPackagesResult:
    """
    This data source provides the list of Publication Packages in Oracle Cloud Infrastructure Marketplace service.

    Lists the packages in the specified publication.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_publication_packages = oci.Marketplace.get_publication_packages(publication_id=test_publication["id"],
        package_type=publication_package_package_type,
        package_version=publication_package_package_version)
    ```


    :param str package_type: A filter to return only packages that match the given package type exactly.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    :param str publication_id: The unique identifier for the publication.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['packageType'] = package_type
    __args__['packageVersion'] = package_version
    __args__['publicationId'] = publication_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getPublicationPackages:getPublicationPackages', __args__, opts=opts, typ=GetPublicationPackagesResult).value

    return AwaitableGetPublicationPackagesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        package_type=pulumi.get(__ret__, 'package_type'),
        package_version=pulumi.get(__ret__, 'package_version'),
        publication_id=pulumi.get(__ret__, 'publication_id'),
        publication_packages=pulumi.get(__ret__, 'publication_packages'))
def get_publication_packages_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPublicationPackagesFilterArgs', 'GetPublicationPackagesFilterArgsDict']]]]] = None,
                                    package_type: Optional[pulumi.Input[Optional[str]]] = None,
                                    package_version: Optional[pulumi.Input[Optional[str]]] = None,
                                    publication_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicationPackagesResult]:
    """
    This data source provides the list of Publication Packages in Oracle Cloud Infrastructure Marketplace service.

    Lists the packages in the specified publication.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_publication_packages = oci.Marketplace.get_publication_packages(publication_id=test_publication["id"],
        package_type=publication_package_package_type,
        package_version=publication_package_package_version)
    ```


    :param str package_type: A filter to return only packages that match the given package type exactly.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    :param str publication_id: The unique identifier for the publication.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['packageType'] = package_type
    __args__['packageVersion'] = package_version
    __args__['publicationId'] = publication_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Marketplace/getPublicationPackages:getPublicationPackages', __args__, opts=opts, typ=GetPublicationPackagesResult)
    return __ret__.apply(lambda __response__: GetPublicationPackagesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        package_type=pulumi.get(__response__, 'package_type'),
        package_version=pulumi.get(__response__, 'package_version'),
        publication_id=pulumi.get(__response__, 'publication_id'),
        publication_packages=pulumi.get(__response__, 'publication_packages')))
