# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretbundleResult',
    'AwaitableGetSecretbundleResult',
    'get_secretbundle',
    'get_secretbundle_output',
]

@pulumi.output_type
class GetSecretbundleResult:
    """
    A collection of values returned by getSecretbundle.
    """
    def __init__(__self__, id=None, metadata=None, secret_bundle_contents=None, secret_id=None, secret_version_name=None, stage=None, stages=None, time_created=None, time_of_deletion=None, time_of_expiry=None, version_name=None, version_number=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if secret_bundle_contents and not isinstance(secret_bundle_contents, list):
            raise TypeError("Expected argument 'secret_bundle_contents' to be a list")
        pulumi.set(__self__, "secret_bundle_contents", secret_bundle_contents)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_name and not isinstance(secret_version_name, str):
            raise TypeError("Expected argument 'secret_version_name' to be a str")
        pulumi.set(__self__, "secret_version_name", secret_version_name)
        if stage and not isinstance(stage, str):
            raise TypeError("Expected argument 'stage' to be a str")
        pulumi.set(__self__, "stage", stage)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if time_of_expiry and not isinstance(time_of_expiry, str):
            raise TypeError("Expected argument 'time_of_expiry' to be a str")
        pulumi.set(__self__, "time_of_expiry", time_of_expiry)
        if version_name and not isinstance(version_name, str):
            raise TypeError("Expected argument 'version_name' to be a str")
        pulumi.set(__self__, "version_name", version_name)
        if version_number and not isinstance(version_number, str):
            raise TypeError("Expected argument 'version_number' to be a str")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Customer-provided contextual metadata for the secret.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="secretBundleContents")
    def secret_bundle_contents(self) -> Sequence['outputs.GetSecretbundleSecretBundleContentResult']:
        """
        The contents of the secret.
        """
        return pulumi.get(self, "secret_bundle_contents")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersionName")
    def secret_version_name(self) -> Optional[str]:
        return pulumi.get(self, "secret_version_name")

    @property
    @pulumi.getter
    def stage(self) -> Optional[str]:
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def stages(self) -> Sequence[str]:
        """
        A list of possible rotation states for the secret version.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the secret bundle was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the secret version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfExpiry")
    def time_of_expiry(self) -> str:
        """
        An optional property indicating when the secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_expiry")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        The name of the secret version. Labels are unique across the different versions of a particular secret.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        The version number of the secret.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetSecretbundleResult(GetSecretbundleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretbundleResult(
            id=self.id,
            metadata=self.metadata,
            secret_bundle_contents=self.secret_bundle_contents,
            secret_id=self.secret_id,
            secret_version_name=self.secret_version_name,
            stage=self.stage,
            stages=self.stages,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion,
            time_of_expiry=self.time_of_expiry,
            version_name=self.version_name,
            version_number=self.version_number)


def get_secretbundle(secret_id: Optional[str] = None,
                     secret_version_name: Optional[str] = None,
                     stage: Optional[str] = None,
                     version_number: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretbundleResult:
    """
    This data source provides details about a specific Secretbundle resource in Oracle Cloud Infrastructure Secrets service.

    Gets a secret bundle that matches either the specified `stage`, `label`, or `versionNumber` parameter.
    If none of these parameters are provided, the bundle for the secret version marked as `CURRENT` will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_secretbundle = oci.Secrets.get_secretbundle(secret_id=test_secret["id"],
        secret_version_name=test_secret_version["name"],
        stage=secretbundle_stage,
        version_number=secretbundle_version_number)
    ```


    :param str secret_id: The OCID of the secret.
    :param str secret_version_name: The name of the secret. (This might be referred to as the name of the secret version. Names are unique across the different versions of a secret.)
    :param str stage: The rotation state of the secret version.
    :param str version_number: The version number of the secret.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['secretVersionName'] = secret_version_name
    __args__['stage'] = stage
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Secrets/getSecretbundle:getSecretbundle', __args__, opts=opts, typ=GetSecretbundleResult).value

    return AwaitableGetSecretbundleResult(
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        secret_bundle_contents=pulumi.get(__ret__, 'secret_bundle_contents'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        secret_version_name=pulumi.get(__ret__, 'secret_version_name'),
        stage=pulumi.get(__ret__, 'stage'),
        stages=pulumi.get(__ret__, 'stages'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        time_of_expiry=pulumi.get(__ret__, 'time_of_expiry'),
        version_name=pulumi.get(__ret__, 'version_name'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_secretbundle_output(secret_id: Optional[pulumi.Input[str]] = None,
                            secret_version_name: Optional[pulumi.Input[Optional[str]]] = None,
                            stage: Optional[pulumi.Input[Optional[str]]] = None,
                            version_number: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretbundleResult]:
    """
    This data source provides details about a specific Secretbundle resource in Oracle Cloud Infrastructure Secrets service.

    Gets a secret bundle that matches either the specified `stage`, `label`, or `versionNumber` parameter.
    If none of these parameters are provided, the bundle for the secret version marked as `CURRENT` will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_secretbundle = oci.Secrets.get_secretbundle(secret_id=test_secret["id"],
        secret_version_name=test_secret_version["name"],
        stage=secretbundle_stage,
        version_number=secretbundle_version_number)
    ```


    :param str secret_id: The OCID of the secret.
    :param str secret_version_name: The name of the secret. (This might be referred to as the name of the secret version. Names are unique across the different versions of a secret.)
    :param str stage: The rotation state of the secret version.
    :param str version_number: The version number of the secret.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['secretVersionName'] = secret_version_name
    __args__['stage'] = stage
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Secrets/getSecretbundle:getSecretbundle', __args__, opts=opts, typ=GetSecretbundleResult)
    return __ret__.apply(lambda __response__: GetSecretbundleResult(
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        secret_bundle_contents=pulumi.get(__response__, 'secret_bundle_contents'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        secret_version_name=pulumi.get(__response__, 'secret_version_name'),
        stage=pulumi.get(__response__, 'stage'),
        stages=pulumi.get(__response__, 'stages'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion'),
        time_of_expiry=pulumi.get(__response__, 'time_of_expiry'),
        version_name=pulumi.get(__response__, 'version_name'),
        version_number=pulumi.get(__response__, 'version_number')))
