"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_ssm_1 = require("@aws-cdk/aws-ssm");
const base_edge_construct_1 = require("./base-edge-construct");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
const with_configuration_1 = require("./with-configuration");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { name, parameterName = `/cloudcomponents/edge-lambda/${this.stack.stackName}/${name}/${this.stack.node.addr}` } = props;
        this.edgeRole = (_a = props.edgeRole) !== null && _a !== void 0 ? _a : new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_lambda_1.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_ssm_1.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
        this.lambdaFunction = this.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
//# sourceMappingURL=data:application/json;base64,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