# Copyright 2022-2023 Laurent Defert
#
#  This file is part of SOSSE.
#
# SOSSE is free software: you can redistribute it and/or modify it under the terms of the GNU Affero
# General Public License as published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# SOSSE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License along with SOSSE.
# If not, see <https://www.gnu.org/licenses/>.

# Generated by Django 3.2.19 on 2023-09-16 08:08

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('se', '0007_sosse_1_5_0'),
    ]

    operations = [
        migrations.AlterField(
            model_name='crawlpolicy',
            name='snapshot_html',
            field=models.BooleanField(default=True, help_text='Store pages as HTML and download requisite assets', verbose_name='Snapshot HTML 🔖'),
        ),
        migrations.AlterField(
            model_name='crawlpolicy',
            name='take_screenshots',
            field=models.BooleanField(default=False, help_text='Store pages as screenshots', verbose_name='Take screenshots 📷'),
        ),
        migrations.AlterField(
            model_name='crawlpolicy',
            name='default_browse_mode',
            field=models.CharField(choices=[('detect', 'Detect'), ('selenium', 'Chromium'), ('firefox', 'Firefox'), ('requests', 'Python Requests')], default='selenium', help_text="Python Request is faster, but can't execute Javascript and may break pages", max_length=8),
        ),
        migrations.AlterField(
            model_name='domainsetting',
            name='browse_mode',
            field=models.CharField(choices=[('detect', 'Detect'), ('selenium', 'Chromium'), ('firefox', 'Firefox'), ('requests', 'Python Requests')], default='detect', max_length=10),
        ),
    ]
