/*
 * Copyright (c) 2021, 2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#pragma once

#ifdef __aarch64__

namespace {

void a64_transpose_interleave_16_2x4_fp32bf16(bfloat16 *out, const float *in, size_t width, size_t in_stride, size_t height)
{
    float *pad_row = reinterpret_cast<float *>(alloca(width * sizeof(float)));

    if (height % 4) {
        memset(pad_row, 0, width * sizeof(float));
    }

    size_t out_stride = 16 * roundup<size_t>(height, 4) * sizeof(bfloat16);

    __asm__ __volatile__(
      "cmp %x[height], #0x8\n"
      "blt 8f\n"
      "1:"  // Main row loop: Head
      "mov x9, %x[in]\n"
      "add x28, x9, %x[in_stride]\n"
      "add x27, x28, %x[in_stride]\n"
      "add x26, x27, %x[in_stride]\n"
      "add x25, x26, %x[in_stride]\n"
      "mov x24, %x[width]\n"
      "add x23, x25, %x[in_stride]\n"
      "add x22, x23, %x[in_stride]\n"
      "add x20, x22, %x[in_stride]\n"
      "cmp x24, #0x10\n"
      "add %x[in], x20, %x[in_stride]\n"
      "mov x21, %x[out]\n"
      "sub %x[height], %x[height], #0x8\n"
      "blt 3f\n"
      "2:"  // Main row loop: Column loop
      "ldr q13, [x9], #0x10\n"
      "ldr q12, [x28], #0x10\n"
      "sub x24, x24, #0x10\n"
      "cmp x24, #0x10\n"
      "ldr q1, [x27], #0x10\n"
      "ldr q9, [x26], #0x10\n"
      "zip1 v19.4s, v13.4s, v1.4s\n"
      "zip1 v14.4s, v12.4s, v9.4s\n"
      "ldr q15, [x25], #0x10\n"
      "ldr q4, [x23], #0x10\n"
      "zip2 v8.4s, v13.4s, v1.4s\n"
      "zip2 v28.4s, v12.4s, v9.4s\n"
      "ldr q0, [x22], #0x10\n"
      "ldr q1, [x20], #0x10\n"
      "zip1 v16.4s, v15.4s, v0.4s\n"
      "zip1 v5.4s, v4.4s, v1.4s\n"
      "ldr q25, [x9], #0x10\n"
      "ldr q24, [x28], #0x10\n"
      "zip2 v3.4s, v15.4s, v0.4s\n"
      "zip2 v2.4s, v4.4s, v1.4s\n"
      "ldr q21, [x27], #0x10\n"
      "ldr q30, [x26], #0x10\n"
      "zip1 v18.4s, v25.4s, v21.4s\n"
      "zip1 v27.4s, v24.4s, v30.4s\n"
      "ldr q22, [x25], #0x10\n"
      "ldr q20, [x23], #0x10\n"
      "zip2 v9.4s, v25.4s, v21.4s\n"
      "zip2 v10.4s, v24.4s, v30.4s\n"
      "ldr q1, [x22], #0x10\n"
      "ldr q21, [x20], #0x10\n"
      "zip1 v25.4s, v22.4s, v1.4s\n"
      "zip1 v7.4s, v20.4s, v21.4s\n"
      "ldr q31, [x9], #0x10\n"
      "ldr q17, [x28], #0x10\n"
      "zip2 v30.4s, v22.4s, v1.4s\n"
      "zip2 v20.4s, v20.4s, v21.4s\n"
      "ldr q15, [x27], #0x10\n"
      "ldr q24, [x26], #0x10\n"
      "zip1 v6.4s, v31.4s, v15.4s\n"
      "zip1 v4.4s, v17.4s, v24.4s\n"
      "ldr q12, [x25], #0x10\n"
      "ldr q29, [x23], #0x10\n"
      "zip2 v22.4s, v31.4s, v15.4s\n"
      "zip2 v26.4s, v17.4s, v24.4s\n"
      "ldr q0, [x22], #0x10\n"
      "ldr q24, [x20], #0x10\n"
      "zip1 v17.4s, v12.4s, v0.4s\n"
      "zip1 v31.4s, v29.4s, v24.4s\n"
      "ldr q21, [x9], #0x10\n"
      "ldr q1, [x28], #0x10\n"
      "zip2 v23.4s, v12.4s, v0.4s\n"
      "zip2 v24.4s, v29.4s, v24.4s\n"
      "ldr q11, [x27], #0x10\n"
      "ldr q29, [x26], #0x10\n"
      "zip1 v0.4s, v21.4s, v11.4s\n"
      "zip1 v13.4s, v1.4s, v29.4s\n"
      "ldr q15, [x25], #0x10\n"
      "ldr q12, [x23], #0x10\n"
      "zip2 v21.4s, v21.4s, v11.4s\n"
      "zip2 v29.4s, v1.4s, v29.4s\n"
      "ldr q1, [x22], #0x10\n"
      "zip1 v11.4s, v15.4s, v1.4s\n"
      "zip2 v1.4s, v15.4s, v1.4s\n"
      "zip1 v15.4s, v19.4s, v14.4s\n"
      ".inst 0x0ea169ef  // bfcvtn v15.4h, v15.4s\n"
      "zip2 v14.4s, v19.4s, v14.4s\n"
      "ldr q19, [x20], #0x10\n"
      ".inst 0x4ea169cf  // bfcvtn2 v15.8h, v14.4s\n"
      "str q15, [x21, #0x0]\n"
      "zip1 v14.4s, v12.4s, v19.4s\n"
      "zip2 v15.4s, v12.4s, v19.4s\n"
      "zip1 v12.4s, v8.4s, v28.4s\n"
      "zip1 v19.4s, v18.4s, v27.4s\n"
      ".inst 0x0ea1698c  // bfcvtn v12.4h, v12.4s\n"
      "zip2 v28.4s, v8.4s, v28.4s\n"
      "zip1 v8.4s, v9.4s, v10.4s\n"
      ".inst 0x0ea16a73  // bfcvtn v19.4h, v19.4s\n"
      "zip2 v18.4s, v18.4s, v27.4s\n"
      "zip1 v27.4s, v6.4s, v4.4s\n"
      ".inst 0x0ea16908  // bfcvtn v8.4h, v8.4s\n"
      "zip2 v10.4s, v9.4s, v10.4s\n"
      "zip1 v9.4s, v22.4s, v26.4s\n"
      ".inst 0x0ea16b7b  // bfcvtn v27.4h, v27.4s\n"
      "zip2 v6.4s, v6.4s, v4.4s\n"
      "zip1 v4.4s, v0.4s, v13.4s\n"
      ".inst 0x0ea16929  // bfcvtn v9.4h, v9.4s\n"
      "zip2 v22.4s, v22.4s, v26.4s\n"
      "zip1 v26.4s, v21.4s, v29.4s\n"
      ".inst 0x0ea16884  // bfcvtn v4.4h, v4.4s\n"
      "zip2 v13.4s, v0.4s, v13.4s\n"
      "zip1 v0.4s, v16.4s, v5.4s\n"
      ".inst 0x0ea16b5a  // bfcvtn v26.4h, v26.4s\n"
      "zip2 v21.4s, v21.4s, v29.4s\n"
      "zip1 v29.4s, v3.4s, v2.4s\n"
      ".inst 0x0ea16800  // bfcvtn v0.4h, v0.4s\n"
      "zip2 v5.4s, v16.4s, v5.4s\n"
      "zip1 v16.4s, v25.4s, v7.4s\n"
      ".inst 0x0ea16bbd  // bfcvtn v29.4h, v29.4s\n"
      "zip2 v2.4s, v3.4s, v2.4s\n"
      "zip1 v3.4s, v30.4s, v20.4s\n"
      ".inst 0x0ea16a10  // bfcvtn v16.4h, v16.4s\n"
      "zip2 v7.4s, v25.4s, v7.4s\n"
      "zip1 v25.4s, v17.4s, v31.4s\n"
      ".inst 0x0ea16863  // bfcvtn v3.4h, v3.4s\n"
      "zip2 v30.4s, v30.4s, v20.4s\n"
      "zip1 v20.4s, v23.4s, v24.4s\n"
      ".inst 0x0ea16b39  // bfcvtn v25.4h, v25.4s\n"
      "zip2 v17.4s, v17.4s, v31.4s\n"
      "zip1 v31.4s, v11.4s, v14.4s\n"
      ".inst 0x0ea16a94  // bfcvtn v20.4h, v20.4s\n"
      "zip2 v24.4s, v23.4s, v24.4s\n"
      "zip1 v23.4s, v1.4s, v15.4s\n"
      ".inst 0x0ea16bff  // bfcvtn v31.4h, v31.4s\n"
      "zip2 v14.4s, v11.4s, v14.4s\n"
      ".inst 0x0ea16af7  // bfcvtn v23.4h, v23.4s\n"
      "zip2 v1.4s, v1.4s, v15.4s\n"
      ".inst 0x4ea16b8c  // bfcvtn2 v12.8h, v28.4s\n"
      "str q12, [x21, #0x10]\n"
      ".inst 0x4ea16a53  // bfcvtn2 v19.8h, v18.4s\n"
      ".inst 0x4ea16948  // bfcvtn2 v8.8h, v10.4s\n"
      "str q19, [x21, #0x20]\n"
      ".inst 0x4ea168db  // bfcvtn2 v27.8h, v6.4s\n"
      ".inst 0x4ea16ac9  // bfcvtn2 v9.8h, v22.4s\n"
      "str q8, [x21, #0x30]\n"
      ".inst 0x4ea169a4  // bfcvtn2 v4.8h, v13.4s\n"
      ".inst 0x4ea16aba  // bfcvtn2 v26.8h, v21.4s\n"
      "str q27, [x21, #0x40]\n"
      ".inst 0x4ea168a0  // bfcvtn2 v0.8h, v5.4s\n"
      ".inst 0x4ea1685d  // bfcvtn2 v29.8h, v2.4s\n"
      "str q9, [x21, #0x50]\n"
      ".inst 0x4ea168f0  // bfcvtn2 v16.8h, v7.4s\n"
      ".inst 0x4ea16bc3  // bfcvtn2 v3.8h, v30.4s\n"
      "str q4, [x21, #0x60]\n"
      ".inst 0x4ea16a39  // bfcvtn2 v25.8h, v17.4s\n"
      ".inst 0x4ea16b14  // bfcvtn2 v20.8h, v24.4s\n"
      "str q26, [x21, #0x70]\n"
      ".inst 0x4ea169df  // bfcvtn2 v31.8h, v14.4s\n"
      ".inst 0x4ea16837  // bfcvtn2 v23.8h, v1.4s\n"
      "str q0, [x21, #0x80]\n"
      "str q29, [x21, #0x90]\n"
      "str q16, [x21, #0xa0]\n"
      "str q3, [x21, #0xb0]\n"
      "str q25, [x21, #0xc0]\n"
      "str q20, [x21, #0xd0]\n"
      "str q31, [x21, #0xe0]\n"
      "str q23, [x21, #0xf0]\n"
      "add x21, x21, %x[out_stride]\n"
      "bge 2b\n"
      "3:"  // Main row loop: Column loop skip
      "cmp x24, #0x4\n"
      "blt 5f\n"
      "4:"  // Main row loop: width 4 loop: loop
      "ldr q23, [x9], #0x10\n"
      "ldr q20, [x28], #0x10\n"
      "sub x24, x24, #0x4\n"
      "cmp x24, #0x4\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v22.4s, v23.4s, v17.4s\n"
      "zip1 v21.4s, v20.4s, v16.4s\n"
      "ldr q19, [x25], #0x10\n"
      "ldr q18, [x23], #0x10\n"
      "zip2 v28.4s, v23.4s, v17.4s\n"
      "zip2 v20.4s, v20.4s, v16.4s\n"
      "ldr q17, [x22], #0x10\n"
      "ldr q16, [x20], #0x10\n"
      "zip1 v27.4s, v19.4s, v17.4s\n"
      "zip1 v26.4s, v18.4s, v16.4s\n"
      "zip2 v25.4s, v19.4s, v17.4s\n"
      "zip2 v24.4s, v18.4s, v16.4s\n"
      "zip1 v19.4s, v22.4s, v21.4s\n"
      "zip1 v18.4s, v28.4s, v20.4s\n"
      "zip1 v17.4s, v27.4s, v26.4s\n"
      "zip1 v16.4s, v25.4s, v24.4s\n"
      ".inst 0x0ea16a77  // bfcvtn v23.4h, v19.4s\n"
      "zip2 v22.4s, v22.4s, v21.4s\n"
      ".inst 0x0ea16a55  // bfcvtn v21.4h, v18.4s\n"
      "zip2 v20.4s, v28.4s, v20.4s\n"
      ".inst 0x0ea16a33  // bfcvtn v19.4h, v17.4s\n"
      "zip2 v18.4s, v27.4s, v26.4s\n"
      ".inst 0x0ea16a11  // bfcvtn v17.4h, v16.4s\n"
      "zip2 v16.4s, v25.4s, v24.4s\n"
      ".inst 0x4ea16ad7  // bfcvtn2 v23.8h, v22.4s\n"
      ".inst 0x4ea16a95  // bfcvtn2 v21.8h, v20.4s\n"
      "str q23, [x21, #0x0]\n"
      ".inst 0x4ea16a53  // bfcvtn2 v19.8h, v18.4s\n"
      ".inst 0x4ea16a11  // bfcvtn2 v17.8h, v16.4s\n"
      "str q21, [x21, #0x10]\n"
      "str q19, [x21, #0x80]\n"
      "str q17, [x21, #0x90]\n"
      "add x21, x21, #0x20\n"
      "bge 4b\n"
      "5:"  // Main row loop: width 4 loop: skip
      "cmp x24, #0x1\n"
      "blt 7f\n"
      "6:"  // Main row loop: width 1 loop: loop
      "ldr s19, [x9], #0x4\n"
      "ldr s18, [x28], #0x4\n"
      "sub x24, x24, #0x1\n"
      "cmp x24, #0x1\n"
      "ldr s17, [x27], #0x4\n"
      "ldr s16, [x26], #0x4\n"
      "zip1 v17.4s, v19.4s, v17.4s\n"
      "zip1 v16.4s, v18.4s, v16.4s\n"
      "ldr s20, [x25], #0x4\n"
      "ldr s19, [x23], #0x4\n"
      "zip1 v16.4s, v17.4s, v16.4s\n"
      ".inst 0x0ea16a12  // bfcvtn v18.4h, v16.4s\n"
      "ldr s17, [x22], #0x4\n"
      "ldr s16, [x20], #0x4\n"
      "zip1 v17.4s, v20.4s, v17.4s\n"
      "zip1 v16.4s, v19.4s, v16.4s\n"
      "zip1 v16.4s, v17.4s, v16.4s\n"
      ".inst 0x0ea16a10  // bfcvtn v16.4h, v16.4s\n"
      "str d18, [x21, #0x0]\n"
      "str d16, [x21, #0x80]\n"
      "add x21, x21, #0x8\n"
      "bge 6b\n"
      "7:"  // Main row loop: width 1 loop: skip
      "cmp %x[height], #0x8\n"
      "add %x[out], %x[out], #0x100\n"
      "bge 1b\n"
      "cbz %x[height], 16f\n"
      "8:"  // Main loop skip

      "9:"  // Tail row loop: Head
      "mov x9, %x[in]\n"
      "add x28, x9, %x[in_stride]\n"
      "add x27, x28, %x[in_stride]\n"
      "mov x20, %x[width]\n"
      "add x26, x27, %x[in_stride]\n"
      "cmp %x[height], #0x3\n"
      "add %x[in], x26, %x[in_stride]\n"
      "csel x26, x26, %x[pad_row], GT\n"
      "csel x27, x27, %x[pad_row], GE\n"
      "cmp %x[height], #0x1\n"
      "csel x28, x28, %x[pad_row], GT\n"
      "cmp x20, #0x10\n"
      "mov x21, %x[out]\n"
      "sub %x[height], %x[height], #0x4\n"
      "blt 11f\n"
      "10:"  // Tail row loop: Column loop
      "ldr q21, [x9], #0x10\n"
      "ldr q20, [x28], #0x10\n"
      "sub x20, x20, #0x10\n"
      "cmp x20, #0x10\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v30.4s, v21.4s, v17.4s\n"
      "zip1 v29.4s, v20.4s, v16.4s\n"
      "ldr q19, [x9], #0x10\n"
      "ldr q18, [x28], #0x10\n"
      "zip2 v28.4s, v21.4s, v17.4s\n"
      "zip2 v27.4s, v20.4s, v16.4s\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v26.4s, v19.4s, v17.4s\n"
      "zip1 v25.4s, v18.4s, v16.4s\n"
      "ldr q21, [x9], #0x10\n"
      "ldr q20, [x28], #0x10\n"
      "zip2 v8.4s, v19.4s, v17.4s\n"
      "zip2 v24.4s, v18.4s, v16.4s\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v7.4s, v21.4s, v17.4s\n"
      "zip1 v6.4s, v20.4s, v16.4s\n"
      "ldr q19, [x9], #0x10\n"
      "ldr q18, [x28], #0x10\n"
      "zip2 v5.4s, v21.4s, v17.4s\n"
      "zip2 v4.4s, v20.4s, v16.4s\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v3.4s, v19.4s, v17.4s\n"
      "zip1 v2.4s, v18.4s, v16.4s\n"
      "zip2 v1.4s, v19.4s, v17.4s\n"
      "zip2 v0.4s, v18.4s, v16.4s\n"
      "zip1 v23.4s, v30.4s, v29.4s\n"
      "zip1 v22.4s, v28.4s, v27.4s\n"
      "zip1 v21.4s, v26.4s, v25.4s\n"
      "zip1 v20.4s, v8.4s, v24.4s\n"
      "zip1 v19.4s, v7.4s, v6.4s\n"
      "zip1 v18.4s, v5.4s, v4.4s\n"
      "zip1 v17.4s, v3.4s, v2.4s\n"
      "zip1 v16.4s, v1.4s, v0.4s\n"
      ".inst 0x0ea16aff  // bfcvtn v31.4h, v23.4s\n"
      "zip2 v30.4s, v30.4s, v29.4s\n"
      ".inst 0x0ea16add  // bfcvtn v29.4h, v22.4s\n"
      "zip2 v28.4s, v28.4s, v27.4s\n"
      ".inst 0x0ea16abb  // bfcvtn v27.4h, v21.4s\n"
      "zip2 v26.4s, v26.4s, v25.4s\n"
      ".inst 0x0ea16a99  // bfcvtn v25.4h, v20.4s\n"
      "zip2 v24.4s, v8.4s, v24.4s\n"
      ".inst 0x0ea16a77  // bfcvtn v23.4h, v19.4s\n"
      "zip2 v22.4s, v7.4s, v6.4s\n"
      ".inst 0x0ea16a55  // bfcvtn v21.4h, v18.4s\n"
      "zip2 v20.4s, v5.4s, v4.4s\n"
      ".inst 0x0ea16a33  // bfcvtn v19.4h, v17.4s\n"
      "zip2 v18.4s, v3.4s, v2.4s\n"
      ".inst 0x0ea16a11  // bfcvtn v17.4h, v16.4s\n"
      "zip2 v16.4s, v1.4s, v0.4s\n"
      ".inst 0x4ea16bdf  // bfcvtn2 v31.8h, v30.4s\n"
      ".inst 0x4ea16b9d  // bfcvtn2 v29.8h, v28.4s\n"
      "str q31, [x21, #0x0]\n"
      ".inst 0x4ea16b5b  // bfcvtn2 v27.8h, v26.4s\n"
      ".inst 0x4ea16b19  // bfcvtn2 v25.8h, v24.4s\n"
      "str q29, [x21, #0x10]\n"
      ".inst 0x4ea16ad7  // bfcvtn2 v23.8h, v22.4s\n"
      ".inst 0x4ea16a95  // bfcvtn2 v21.8h, v20.4s\n"
      "str q27, [x21, #0x20]\n"
      ".inst 0x4ea16a53  // bfcvtn2 v19.8h, v18.4s\n"
      ".inst 0x4ea16a11  // bfcvtn2 v17.8h, v16.4s\n"
      "str q25, [x21, #0x30]\n"
      "str q23, [x21, #0x40]\n"
      "str q21, [x21, #0x50]\n"
      "str q19, [x21, #0x60]\n"
      "str q17, [x21, #0x70]\n"
      "add x21, x21, %x[out_stride]\n"
      "bge 10b\n"
      "11:"  // Tail row loop: Column loop skip
      "cmp x20, #0x4\n"
      "blt 13f\n"
      "12:"  // Tail row loop: width 4 loop: loop
      "ldr q20, [x9], #0x10\n"
      "ldr q19, [x28], #0x10\n"
      "sub x20, x20, #0x4\n"
      "cmp x20, #0x4\n"
      "ldr q17, [x27], #0x10\n"
      "ldr q16, [x26], #0x10\n"
      "zip1 v22.4s, v20.4s, v17.4s\n"
      "zip1 v18.4s, v19.4s, v16.4s\n"
      "zip2 v21.4s, v20.4s, v17.4s\n"
      "zip2 v20.4s, v19.4s, v16.4s\n"
      "zip1 v17.4s, v22.4s, v18.4s\n"
      "zip1 v16.4s, v21.4s, v20.4s\n"
      ".inst 0x0ea16a33  // bfcvtn v19.4h, v17.4s\n"
      "zip2 v18.4s, v22.4s, v18.4s\n"
      ".inst 0x0ea16a11  // bfcvtn v17.4h, v16.4s\n"
      "zip2 v16.4s, v21.4s, v20.4s\n"
      ".inst 0x4ea16a53  // bfcvtn2 v19.8h, v18.4s\n"
      ".inst 0x4ea16a11  // bfcvtn2 v17.8h, v16.4s\n"
      "str q19, [x21, #0x0]\n"
      "str q17, [x21, #0x10]\n"
      "add x21, x21, #0x20\n"
      "bge 12b\n"
      "13:"  // Tail row loop: width 4 loop: skip
      "cmp x20, #0x1\n"
      "blt 15f\n"
      "14:"  // Tail row loop: width 1 loop: loop
      "ldr s19, [x9], #0x4\n"
      "ldr s18, [x28], #0x4\n"
      "sub x20, x20, #0x1\n"
      "cmp x20, #0x1\n"
      "ldr s17, [x27], #0x4\n"
      "ldr s16, [x26], #0x4\n"
      "zip1 v17.4s, v19.4s, v17.4s\n"
      "zip1 v16.4s, v18.4s, v16.4s\n"
      "zip1 v16.4s, v17.4s, v16.4s\n"
      ".inst 0x0ea16a10  // bfcvtn v16.4h, v16.4s\n"
      "str d16, [x21, #0x0]\n"
      "add x21, x21, #0x8\n"
      "bge 14b\n"
      "15:"  // Tail row loop: width 1 loop: skip
      "cmp %x[height], #0x1\n"
      "add %x[out], %x[out], #0x80\n"
      "bge 9b\n"
      "16:"  // Done

      : [height] "+&r" (height), [in] "+&r" (in), [out] "+&r" (out)
      : [in_stride] "r" (in_stride), [out_stride] "r" (out_stride), [pad_row] "r" (pad_row), [width] "r" (width)
      : "cc", "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "x9", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28"
    );
}

} // anonymous namespace
template<>
void Transform<16, 4, true, VLType::None>(
    bfloat16 *out, const float *in, int stride, int x0, int xmax, int k0, int kmax)
{
    a64_transpose_interleave_16_2x4_fp32bf16(
        out,
        in + k0 * stride + x0,
        (xmax-x0),
        stride * sizeof(float),
        (kmax-k0)
    );
}

#endif
