"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildStartBuild = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an AWS CodeBuild as a target for AWS EventBridge Scheduler.
 */
class CodeBuildStartBuild extends target_1.ScheduleTargetBase {
    constructor(project, props = {}) {
        super(props, project.projectArn);
        this.project = project;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeBuildStartBuild);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.project.env.region, schedule.env.region)) {
            throw new Error(`Cannot assign project in region ${this.project.env.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the project must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.project.env.account, schedule.env.account)) {
            throw new Error(`Cannot assign project in account ${this.project.env.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the project must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, schedule.env.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.account}. Both the target and the execution role must be in the same account.`);
        }
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['codebuild:StartBuild'],
            resources: [this.project.projectArn],
        }));
    }
}
exports.CodeBuildStartBuild = CodeBuildStartBuild;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildStartBuild[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.CodeBuildStartBuild", version: "2.150.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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