"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Send an event to an AWS EventBridge by AWS EventBridge Scheduler.
 */
class EventBridgePutEvents extends target_1.ScheduleTargetBase {
    constructor(entry, props) {
        super(props, entry.eventBus.eventBusArn);
        this.entry = entry;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_EventBridgePutEventsEntry(entry);
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgePutEvents);
            }
            throw error;
        }
        if (this.props.input) {
            throw new Error('ScheduleTargetBaseProps.input is not supported for EventBridgePutEvents. Please use entry.detail instead.');
        }
    }
    addTargetActionToRole(schedule, role) {
        const eventBus = this.entry.eventBus;
        const eventBusEnv = eventBus.env;
        if (!(0, util_1.sameEnvDimension)(eventBusEnv.region, schedule.env.region)) {
            throw new Error(`Cannot assign eventBus in region ${eventBusEnv.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the eventBus must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(eventBusEnv.account, schedule.env.account)) {
            throw new Error(`Cannot assign eventBus in account ${eventBusEnv.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the eventBus must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, eventBusEnv.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(eventBus.node)} in account ${eventBusEnv.account}. Both the target and the execution role must be in the same account.`);
        }
        eventBus.grantPutEventsTo(role);
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            input: this.entry.detail,
            eventBridgeParameters: {
                detailType: this.entry.detailType,
                source: this.entry.source,
            },
        };
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.EventBridgePutEvents", version: "2.150.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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