"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSettlementChargebacksQueryParamEmbed(str, Enum):
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    PAYMENT = "payment"


class GetSettlementChargebacksRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[GetSettlementChargebacksQueryParamEmbed]
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetSettlementChargebacksRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[GetSettlementChargebacksQueryParamEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementChargebacksSettlementsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetSettlementChargebacksSettlementsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetSettlementChargebacksSettlementsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[
        GetSettlementChargebacksSettlementsResponseDocumentationTypedDict
    ]
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementChargebacksSettlementsResponseLinks(BaseModel):
    documentation: Optional[
        GetSettlementChargebacksSettlementsResponseDocumentation
    ] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementChargebacksSettlementsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetSettlementChargebacksSettlementsResponseLinks],
        pydantic.Field(alias="_links"),
    ] = None


class GetSettlementChargebacksSettlementsResponseResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementChargebacksSettlementsResponseResponseBodyData

    def __init__(
        self, data: GetSettlementChargebacksSettlementsResponseResponseBodyData
    ):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementChargebacksSettlementsResponseResponseBodyData
        )


class GetSettlementChargebacksSettlementsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetSettlementChargebacksSettlementsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetSettlementChargebacksSettlementsLinksTypedDict(TypedDict):
    documentation: NotRequired[
        GetSettlementChargebacksSettlementsDocumentationTypedDict
    ]
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementChargebacksSettlementsLinks(BaseModel):
    documentation: Optional[GetSettlementChargebacksSettlementsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementChargebacksSettlementsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetSettlementChargebacksSettlementsLinks],
        pydantic.Field(alias="_links"),
    ] = None


class GetSettlementChargebacksSettlementsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementChargebacksSettlementsResponseBodyData

    def __init__(self, data: GetSettlementChargebacksSettlementsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementChargebacksSettlementsResponseBodyData
        )


class GetSettlementChargebacksAmountTypedDict(TypedDict):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementChargebacksAmount(BaseModel):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementChargebacksSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementChargebacksSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementChargebacksReasonTypedDict(TypedDict):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: NotRequired[str]
    r"""Technical code provided by the bank."""
    description: NotRequired[str]
    r"""A more detailed human-friendly description."""


class GetSettlementChargebacksReason(BaseModel):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: Optional[str] = None
    r"""Technical code provided by the bank."""

    description: Optional[str] = None
    r"""A more detailed human-friendly description."""


class GetSettlementChargebacksSettlementsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlementsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlementsResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlementsResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSettlementsResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementChargebacksSettlementsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: NotRequired[GetSettlementChargebacksPaymentTypedDict]
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""
    settlement: NotRequired[Nullable[GetSettlementChargebacksSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""
    documentation: NotRequired[
        GetSettlementChargebacksSettlementsResponse200DocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementChargebacksSettlementsResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementChargebacksSettlementsSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: Optional[GetSettlementChargebacksPayment] = None
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    settlement: OptionalNullable[GetSettlementChargebacksSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    documentation: Optional[
        GetSettlementChargebacksSettlementsResponse200Documentation
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "payment", "settlement", "documentation"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementChargebacksChargebacksTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""
    amount: NotRequired[GetSettlementChargebacksAmountTypedDict]
    r"""The amount charged back by the customer."""
    settlement_amount: NotRequired[
        Nullable[GetSettlementChargebacksSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    reason: NotRequired[Nullable[GetSettlementChargebacksReasonTypedDict]]
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    reversed_at: NotRequired[Nullable[str]]
    r"""The date and time the chargeback was reversed if applicable, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetSettlementChargebacksSettlementsResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementChargebacksChargebacks(BaseModel):
    resource: Optional[str] = "chargeback"
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""

    amount: Optional[GetSettlementChargebacksAmount] = None
    r"""The amount charged back by the customer."""

    settlement_amount: Annotated[
        OptionalNullable[GetSettlementChargebacksSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    reason: OptionalNullable[GetSettlementChargebacksReason] = UNSET
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    reversed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="reversedAt")
    ] = UNSET
    r"""The date and time the chargeback was reversed if applicable, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[GetSettlementChargebacksSettlementsResponse200Links],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "amount",
            "settlementAmount",
            "reason",
            "paymentId",
            "settlementId",
            "createdAt",
            "reversedAt",
            "_links",
        ]
        nullable_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementChargebacksEmbeddedTypedDict(TypedDict):
    chargebacks: NotRequired[List[GetSettlementChargebacksChargebacksTypedDict]]
    r"""A list of chargeback objects."""


class GetSettlementChargebacksEmbedded(BaseModel):
    chargebacks: Optional[List[GetSettlementChargebacksChargebacks]] = None
    r"""A list of chargeback objects."""


class GetSettlementChargebacksSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementChargebacksSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[GetSettlementChargebacksPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[GetSettlementChargebacksNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[GetSettlementChargebacksDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementChargebacksLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementChargebacksSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[GetSettlementChargebacksPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[GetSettlementChargebacksNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[GetSettlementChargebacksDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementChargebacksResponseBodyTypedDict(TypedDict):
    r"""A list of chargeback objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[GetSettlementChargebacksEmbeddedTypedDict]
    links: NotRequired[GetSettlementChargebacksLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class GetSettlementChargebacksResponseBody(BaseModel):
    r"""A list of chargeback objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[GetSettlementChargebacksEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[GetSettlementChargebacksLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
