# Generated by Django 4.1.13 on 2023-12-05 11:42

from django.db import migrations
from packageurl import normalize_qualifiers


class Migration(migrations.Migration):

    def copy_qualifiers(apps, schema_editor):
        """
        Bulk update qualifiers_temp from the legacy JSON field
        """
        Package = apps.get_model("vulnerabilities", "Package")
        updatables = []
        for package in Package.objects.all():
            qualifiers = package.qualifiers
            normalized_string = normalize_qualifiers(qualifiers, encode=True) or ""
            package.qualifiers_temp = normalized_string
            updatables.append(package)
        
        updated = Package.objects.bulk_update(
            objs = updatables,
            fields=["qualifiers_temp",], 
            batch_size=500,
        )
        print(f"Copied {updated} qualifiers to qualifiers_temp")            



    dependencies = [
        ("vulnerabilities", "0046_package_qualifiers_temp"),
    ]

    operations = [
        migrations.RunPython(copy_qualifiers, reverse_code=migrations.RunPython.noop),
    ]
