# Generated by Django 4.1.13 on 2024-05-29 19:14

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0056_alter_packagechangelog_software_version_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="Kev",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "date_added",
                    models.DateField(
                        blank=True,
                        help_text="The date the vulnerability was added to the Known Exploited Vulnerabilities (KEV) catalog in the format YYYY-MM-DD.",
                        null=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        help_text="Description of the vulnerability in the Known Exploited Vulnerabilities (KEV) catalog, usually a refinement of the original CVE description"
                    ),
                ),
                (
                    "required_action",
                    models.TextField(
                        help_text="The required action to address the vulnerability, typically to apply vendor updates or apply vendor mitigations or to discontinue use."
                    ),
                ),
                (
                    "due_date",
                    models.DateField(
                        help_text="The date the required action is due in the format YYYY-MM-DD,which applies to all USA federal civilian executive branch (FCEB) agencies,but all organizations are strongly encouraged to execute the required action."
                    ),
                ),
                (
                    "resources_and_notes",
                    models.TextField(
                        help_text="Additional notes and resources about the vulnerability, often a URL to vendor instructions."
                    ),
                ),
                (
                    "known_ransomware_campaign_use",
                    models.BooleanField(
                        default=False,
                        help_text="Known if this vulnerability is known to have been leveraged as part of a ransomware campaign; \n        or 'Unknown' if CISA lacks confirmation that the vulnerability has been utilized for ransomware.",
                    ),
                ),
                (
                    "vulnerability",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="kev",
                        to="vulnerabilities.vulnerability",
                    ),
                ),
            ],
        ),
    ]
