# Generated by Django 4.2.15 on 2024-09-21 15:37

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0068_update_nvd_advisory_created_by"),
    ]

    operations = [
        migrations.CreateModel(
            name="Exploit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "date_added",
                    models.DateField(
                        blank=True,
                        help_text="The date the vulnerability was added to an exploit catalog.",
                        null=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Description of the vulnerability in an exploit catalog, often a refinement of the original CVE description",
                        null=True,
                    ),
                ),
                (
                    "required_action",
                    models.TextField(
                        blank=True,
                        help_text="The required action to address the vulnerability, typically to apply vendor updates or apply vendor mitigations or to discontinue use.",
                        null=True,
                    ),
                ),
                (
                    "due_date",
                    models.DateField(
                        blank=True,
                        help_text="The date the required action is due, which applies to all USA federal civilian executive branch (FCEB) agencies, but all organizations are strongly encouraged to execute the required action",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        help_text="Additional notes and resources about the vulnerability, often a URL to vendor instructions.",
                        null=True,
                    ),
                ),
                (
                    "known_ransomware_campaign_use",
                    models.BooleanField(
                        default=False,
                        help_text="Known' if this vulnerability is known to have been leveraged as part of a ransomware campaign; \n        or 'Unknown' if there is no confirmation that the vulnerability has been utilized for ransomware.",
                    ),
                ),
                (
                    "source_date_published",
                    models.DateField(
                        blank=True,
                        help_text="The date that the exploit was published or disclosed.",
                        null=True,
                    ),
                ),
                (
                    "exploit_type",
                    models.TextField(
                        blank=True,
                        help_text="The type of the exploit as provided by the original upstream data source.",
                        null=True,
                    ),
                ),
                (
                    "platform",
                    models.TextField(
                        blank=True,
                        help_text="The platform associated with the exploit as provided by the original upstream data source.",
                        null=True,
                    ),
                ),
                (
                    "source_date_updated",
                    models.DateField(
                        blank=True,
                        help_text="The date the exploit was updated in the original upstream data source.",
                        null=True,
                    ),
                ),
                (
                    "data_source",
                    models.TextField(
                        blank=True,
                        help_text="The source of the exploit information, such as CISA KEV, exploitdb, metaspoit, or others.",
                        null=True,
                    ),
                ),
                (
                    "source_url",
                    models.URLField(
                        blank=True,
                        help_text="The URL to the exploit as provided in the original upstream data source.",
                        null=True,
                    ),
                ),
                (
                    "vulnerability",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="exploits",
                        to="vulnerabilities.vulnerability",
                    ),
                ),
            ],
        ),
        migrations.DeleteModel(
            name="Kev",
        ),
    ]
