# Generated by Django 4.2.16 on 2024-12-18 10:09

import aboutcode.hashid
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0084_alter_package_options_package_version_rank"),
    ]

    operations = [
        migrations.AlterField(
            model_name="package",
            name="is_ghost",
            field=models.BooleanField(
                db_index=True,
                default=False,
                help_text="True if the package does not exist in the upstream package manager or its repository.",
            ),
        ),
        migrations.AlterField(
            model_name="package",
            name="version_rank",
            field=models.IntegerField(
                db_index=True,
                default=0,
                help_text="Rank of the version to support ordering by version. Rank zero means the rank has not been defined yet",
            ),
        ),
        migrations.AlterField(
            model_name="vulnerability",
            name="vulnerability_id",
            field=models.CharField(
                blank=True,
                db_index=True,
                default=aboutcode.hashid.build_vcid,
                help_text="Unique identifier for a vulnerability in the external representation. It is prefixed with VCID-",
                max_length=20,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="vulnerabilityreference",
            name="reference_id",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="An optional reference ID, such as DSA-4465-1 when available",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="vulnerabilityseverity",
            name="url",
            field=models.URLField(
                db_index=True,
                help_text="URL to the vulnerability severity",
                max_length=1024,
                null=True,
            ),
        ),
        migrations.AddIndex(
            model_name="package",
            index=models.Index(
                fields=["type", "namespace", "name"], name="vulnerabili_type_825918_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="package",
            index=models.Index(
                fields=["type", "namespace", "name", "qualifiers", "subpath"],
                name="vulnerabili_type_8e6aff_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="package",
            index=models.Index(
                fields=["type", "namespace", "name", "version"], name="vulnerabili_type_f6687a_idx"
            ),
        ),
    ]
